/* ***************************************************************************************
* FILE:          Connection.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Connection.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef Connection_h
#define Connection_h

#include "AppHmi_MasterBase/AudioInterface/Source.h"
#include "AppHmi_MasterBase/AudioInterface/Sink.h"

namespace hmibase {
namespace apphmi_master {
namespace audio {

class Connection
{
   public:
      Connection(int& nID, Source*& pSource, Sink*& pSink): m_ID(nID), m_pSource(pSource), m_pSink(pSink), m_Delay(0), m_State(0), m_bPurge(false) {}
      Connection(int& nID, Source*& pSource, Sink*& pSink, int& nDelay, int& nState): m_ID(nID), m_pSource(pSource), m_pSink(pSink), m_Delay(nDelay), m_State(nState), m_bPurge(false) {}

      ~Connection();

      inline int getConnectionID() const
      {
         return m_ID;
      }

      inline int getConnectionDelay() const
      {
         return m_Delay;
      }

      inline int getState() const
      {
         return m_State;
      }

      inline void setConnectionState(int state)
      {
         m_State = state;
      }

      inline Source* getSource() const
      {
         return m_pSource;
      }

      inline Sink* getSink() const
      {
         return m_pSink;
      }

      inline bool getPurge() const
      {
         return m_bPurge;
      }

      inline void setPurge(bool bPurge)
      {
         m_bPurge = bPurge;
      }

      void updateConnectionData(int nSrcID, int nSinkID, int nDelay, int nState);
      bool IsConnectionStateAttained();

   private:
      int m_ID;
      Source* m_pSource;
      Sink* m_pSink;
      int m_Delay;
      int m_State;
      bool m_bPurge;
};


}
}


}

#endif //Connection_h
