/* ***************************************************************************************
* FILE:          Connection.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Connection.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "AppHmi_MasterBase/AudioInterface/Connection.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_AUDIO_IF
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/Connection.cpp.trc.h"
#endif

namespace hmibase {
namespace apphmi_master {
namespace audio {

Connection::~Connection()
{
   m_pSink = 0;
   m_pSource = 0;
}


void Connection::updateConnectionData(int nSrcID, int nSinkID, int nDelay, int nState)
{
   ETG_TRACE_USR4_THR(("updateConnectionData with SrcID %d, SinkID %d and state %d",  nSrcID, nSinkID, nState));
   if (m_pSource->GetID() == nSrcID)
   {
      m_Delay = nDelay;
      m_State = nState;
   }
}


bool Connection::IsConnectionStateAttained()
{
   if ((m_pSource->GetResponseState() == m_State) || (STATE_SUSPENDED == m_State))
   {
      return true;
   }
   return false;
}


}
}


}
