/* ***************************************************************************************
* FILE:          AudioDefines.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AudioDefines.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef AudioDefines_h
#define AudioDefines_h

//The following defines should be removed and values to be directly taken from FC Audio once made available
//Source string defines
#define TUNER_FM_STR                "TUNER_FM"
#define TUNER_AM_STR                "TUNER_AM"
#define TUNER_DAB_STR               "TUNER_DAB"
#define TUNER_TA_FM_STR             "TUNER_TA_FM"
#define TUNER_TA_DAB_STR            "TUNER_TA_DAB"
#define TUNER_XM_STR                "TUNER_XM"
#define TUNER_DRM_STR               "TUNER_DRM"
#define TUNER_TI_AM_STR             "TUNER_TI_AM"
#define DTV_STR                     "DTV"
#define TUNER_WX_STR                "WX"
#define MEDIA_PLAYER_STR            "MEDIA_PLAYER"
#define MEDIA_CDDA_STR              "MEDIA_CDDA"
#define MEDIA_AUX_STR               "AUX_1"
#define PHONE_BTAUDIO_STR           "PHONE_BTAUDIO"
#define USB_VIDEO_STR               "USB_VIDEO"
#define MEDIA_BLURAY_STR            "BLU_RAY"
#define PHONE_STR                   "PHONE"
#define PHONE_OUTBAND_RING_STR      "PHONE_OUTBAND_RING"
#define PHONE_INBAND_RING_STR       "PHONE_INBAND_RING"
#define PHONE_SPEECHRECOGNITION_STR "PHONE_SPEECHRECOGNITION"
#define SMS_SPEECH_STR              "SMS_SPEECH"
#define TCU_ECALL_STR               "TCU_ECALL"
#define TCU_SERVICE_CALL_STR        "TCU_SERVICE_CALL"
#define SPI_ENTERTAIN_STR           "SPI_ENTERTAIN"
#define SPI_INFO_STR                "SPI_INFO"
#define SPI_PHONE_STR               "SPI_PHONE"
#define SPI_SPEECHRECOGNITION_STR   "SPI_SPEECHRECOGNITION"
#define SPI_ALERT_STR               "SPI_ALERT"
#define SDS_SPEECHRECOGNITION_STR   "SDS_SPEECHRECOGNITION"
#define WEB_ENTERTAIN_STR           "WEB_ENTERTAIN"
#define NAVI_SPEECH_STR             "NAVI_SPEECH"
#define SXM_TTS_STR                 "SXM_TTS"
#define SXM_NEWS_STR                "SXM_NEWS"
#define TCU_TTS_STR                 "TCU_TTS"
#define IPA_TTS_STR                 "IPA_TTS"
#define INTERNET_APPS_STR           "INTERNET_APPS"
#define PHONE_ECALL_STR             "PHONE_ECALL"
#define NAVI_BY_SDS_STR             "NAVI_BY_SDS"
#define RSE_IN_STR                  "RSE_IN"
#define SPI_VR_STEREO_STR           "SPI_VR_STEREO"
#define SPI_ML_INFO_STR             "SPI_ML_INFO"
#define EXT_NAVI_STR                "EXT_NAVI"
#define EXT_LVDS_MEDIA              "EXT_LVDS_MEDIA"
#define WEATHER_ALERT_STR			"WX_ALERT"
#define CMR_USB1_VIDEO_STR          "CMR1_USB1_Video"
#define CMR_USB2_VIDEO_STR          "CMR1_USB2_Video"
#define CMR_USB1_AUDIO_STR  		"CMR1_USB1_Audio"
#define CMR_USB2_AUDIO_STR  		"CMR1_USB2_Audio"


//Mic1 announcement
#define MIC_PRIVATE_STR             "MIC_PRIVATE"
#define AVB_MIC2_STR                "AVB_Mic2"
#define AVB_MIC3_STR                "AVB_Mic3"
#define INTERCOM                    "INTERCOM"

//CAMERAPORT USB SOURCES INF4CV
#define CAMERAPORT1_CAM1_STR             "CMP1_CAM1"
#define CAMERAPORT1_CAM2_STR             "CMP1_CAM2"
#define CAMERAPORT1_CAM3_STR             "CMP1_CAM3"
#define CAMERAPORT1_CAM4_STR             "CMP1_CAM4"
#define CAMERAPORT1_IPCAM_STR            "CMP1_IPCAM"
#define CAMERAPORT1_SPLITSCREEN_STR      "CMP1_SPLITSCREEN"
#define CAMERAPORT1_USB_VIDEO_STR        "CMP1_USB_VIDEO"
#define CAMERAPORT1_USB_AUDIO_STR        "CMP1_USB_AUDIO"
#define CAMERAPORT1_HDMI_STR             "CMP1_HDMI"
#define CAMERAPORT2_CAM1_STR             "CMP2_CAM1"
#define CAMERAPORT2_CAM2_STR             "CMP2_CAM2"
#define CAMERAPORT2_CAM3_STR             "CMP2_CAM3"
#define CAMERAPORT2_CAM4_STR             "CMP2_CAM4"
#define CAMERAPORT2_IPCAM_STR            "CMP2_IPCAM"
#define CAMERAPORT2_SPLITSCREEN_STR      "CMP2_SPLITSCREEN"
#define CAMERAPORT2_USB_VIDEO_STR        "CMP2_USB_VIDEO"
#define CAMERAPORT2_HDMI_STR             "CMP2_HDMI"
#define CAMERAPORT3_CAM1_STR             "CMP3_CAM1"
#define CAMERAPORT3_CAM2_STR             "CMP3_CAM2"
#define CAMERAPORT3_CAM3_STR             "CMP3_CAM3"
#define CAMERAPORT3_CAM4_STR             "CMP3_CAM4"
#define CAMERAPORT3_IPCAM_STR            "CMP3_IPCAM"
#define CAMERAPORT3_SPLITSCREEN_STR      "CMP3_SPLITSCREEN"
#define CAMERAPORT3_USB_VIDEO_STR        "CMP3_USB_VIDEO"
#define CAMERAPORT3_HDMI_STR             "CMP3_HDMI"
#define CAMERAPORT4_CAM1_STR             "CMP4_CAM1"
#define CAMERAPORT4_CAM2_STR             "CMP4_CAM2"
#define CAMERAPORT4_CAM3_STR             "CMP4_CAM3"
#define CAMERAPORT4_CAM4_STR             "CMP4_CAM4"
#define CAMERAPORT4_IPCAM_STR            "CMP4_IPCAM"
#define CAMERAPORT4_SPLITSCREEN_STR      "CMP4_SPLITSCREEN"
#define CAMERAPORT4_USB_VIDEO_STR        "CMP4_USB_VIDEO"
#define CAMERAPORT4_HDMI_STR             "CMP4_HDMI"

//Connection States
#define STATE_UNKNOWN 0
#define STATE_CONNECTING 1
#define STATE_CONNECTED 2
#define STATE_DISCONNECTING 3
#define STATE_DISCONNECTED 4
#define STATE_SUSPENDED 5

//Volume defines
#define VOL_MODE_INC 1
#define VOL_MODE_DEC 2

#define STATE_UNKNOWN 0
#define STATE_MUTED 1
#define STATE_UNMUTED 2

#define AUDIO_OFF_MUTE_OFF 0
#define AUDIO_OFF_MUTE_ON 1

//Resource defines
#define RES_UNKNOWN 0
#define RES_AVAILABLE 1
#define RES_UNAVAILABLE 2

//Source Availability reasons
#define SRC_AVAIL_UNKNOWN 0
#define SRC_AVAIL_NEWMEDIA 1
#define SRC_AVAIL_SAMEMEDIA 2
#define SRC_AVAIL_NOMEDIA 3
#define SRC_AVAIL_TEMPERATURE 4
#define SRC_AVAIL_VOLTAGE 5
#define SRC_AVAIL_ERRORMEDIA 6

//System property defines
#define SYP_BEEP 1
#define SYP_HMISTARTUP_MUTE 7
#define SYP_USER_MUTE_STATUS 9

#define DEFAULT_MAIN_SINK_ID 1
//Audio sinks INF4CV
#define COCKPIT_SINK "AMPLIFIER_MAINFIELD"
#define CABIN_A_SINK "AMP_A"
#define CABIN_B_SINK "AMP_B"
#define PRIVATE_SPEAKER_SINK "ADR_2"

//Media Glass sinks INF4CV
#define CABIN_A_MEDIAGLASS1_SINK "Glass_A1"
#define CABIN_A_MEDIAGLASS2_SINK "Glass_A2"
#define CABIN_B_MEDIAGLASS1_SINK "Glass_B1"
#define CABIN_B_MEDIAGLASS2_SINK "Glass_B2"

enum _Sink
{
   COCKPIT_SINK_ID             = 1,
   PRIVATE_SPEAKER_SINK_ID     = 2,
   CABIN_A_SINK_ID             = 3,
   CABIN_A_MEDIAGLASS1_SINK_ID = 4,
   CABIN_A_MEDIAGLASS2_SINK_ID = 5,
   CABIN_B_SINK_ID             = 6,
   CABIN_B_MEDIAGLASS1_SINK_ID = 7,
   CABIN_B_MEDIAGLASS2_SINK_ID = 8,
   SINK_INVALID                = 255
};


//Source Group Size
#define SRC_GROUP_SIZE 100

enum enSoundPropertyType
{
   UNKNOWN = 0,
   SOUND_BASS = 1,
   SOUND_BASS_RELATIVE = 2,
   SOUND_MIDDLE = 3,
   SOUND_MIDDLE_RELATIVE = 4,
   SOUND_TREBLE = 5,
   SOUND_TREBLE_RELATIVE = 6,
   SOUND_LOUDNESS = 7,
   SOUND_LOUDNESS_RELATIVE = 8,
   SOUND_BALANCE = 9,
   SOUND_BALANCE_RELATIVE = 10,
   SOUND_FADER = 11,
   SOUND_FADER_RELATIVE = 12,
   SOUND_DYN_COMPRESSION = 13,
   EQUALIZER_PRESET = 14,
   SPEED_DEPENDENT_VOLUME = 15,
   MIC_STATUS_CONNECTION = 16,
   MIC_STATUS_LEVEL = 17,
   SOUND_OPTIMIZATION = 18,
   SOUND_ROOM_EFFECT = 19,
   LEVEL_AUX_IN = 20,
   LEVEL_BEEP = 21,
   LEVEL_CENTER = 22,
   LEVEL_SUBWOOFER = 23,
   SETTING_SURROUND = 24,
   MODE_AUDIO = 25,
   VOLUME_ENTERTAINMENT = 26,
   VOLUME_PHONE = 27,
   VOLUME_ONVOL = 28,
   VOLUME_TA = 29,
   VOLUME_BEEP = 30,
   PDC_ATTENUATION_LEVEL = 31,
   LEVEL_BTAUDIO_IN = 32,
   GALA_GAIN = 33,
   PDC_ACTIVE = 34,
   VOLUME_LOCK = 35,
   SYSTEM_MUTE = 36,
   AUDIO_OFF_MUTE = 40,
   VOLUME_SOURCE = 41,
   MSP_USER_MUTE_STATUS = 107,
};


// All the Audio clients can use these defines for source request
enum _SrcGroup
{
   GROUP_TUNER,     // Refers to FM, AM and DAB
   GROUP_PHONE,     // Refers to Phone
   GROUP_MEDIA,     // Refers to USB, IPOD, CD/MP3...
   GROUP_WEBAPPS,
   GROUP_OTHERS,
   GROUP_COUNT
};


enum _Src
{
   SRC_TUNER_FM = GROUP_TUNER * SRC_GROUP_SIZE,
   SRC_TUNER_AM,
   SRC_DAB,
   SRC_TUNER_TA_FM,
   SRC_TUNER_TA_DAB,
   SRC_TUNER_XM,
   SRC_TUNER_DRM,
   SRC_TUNER_TI_AM,
   SRC_DTV,
   SRC_TUNER_WX,
   SRC_MEDIA_AUX = GROUP_MEDIA * SRC_GROUP_SIZE,
   SRC_MEDIA_PLAYER,
   SRC_MEDIA_CDDA,
   SRC_PHONE_BTAUDIO,
   SRC_SPI_ENTERTAIN,
   SRC_SPI_INFO,
   SRC_SPI_PHONE,
   SRC_USB_VIDEO,
   SRC_MEDIA_BLURAY,
   SRC_REAR,
   SRC_EXT_LVDS_MEDIA,
   SRC_MEDIA_NO_SRC,
   SRC_PHONE = GROUP_PHONE * SRC_GROUP_SIZE,
   SRC_PHONE_OUTBAND_RING,
   SRC_PHONE_INBAND_RING,
   SRC_PHONE_SPEECHRECOGNITION,
   SRC_SMS_SPEECH,
   SRC_TCU_ECALL,
   SRC_TCU_SERVICE_CALL,
   SRC_PHONE_ECALL,
   SRC_INTERCOM,
   SRC_WEB_ENTERTAIN = GROUP_WEBAPPS * SRC_GROUP_SIZE,
   SRC_NAVI_SPEECH = GROUP_OTHERS * SRC_GROUP_SIZE,
   SRC_SDS_SPEECHRECOGNITION,
   SRC_TCU_TTS,
   SRC_IPA_TTS,
   SRC_INTERNET_APPS,
   SRC_SXM_TTS,
   SRC_SXM_NEWS,
   SRC_SPI_SPEECHRECOGNITION,
   SRC_SPI_ALERT,
   SRC_NAVI_BY_SDS,
   SRC_SPI_VR_STEREO,
   SRC_SPI_ML_INFO,
   SRC_EXT_NAVI,
   SRC_CAMERAPORT1_CAM1,
   SRC_CAMERAPORT1_CAM2,
   SRC_CAMERAPORT1_CAM3,
   SRC_CAMERAPORT1_CAM4,
   SRC_CAMERAPORT1_IPCAM,
   SRC_CAMERAPORT1_SPLITSCREEN,
   SRC_CAMERAPORT1_USB_VIDEO,
   SRC_CAMERAPORT1_HDMI,
   SRC_CAMERAPORT2_CAM1,
   SRC_CAMERAPORT2_CAM2,
   SRC_CAMERAPORT2_CAM3,
   SRC_CAMERAPORT2_CAM4,
   SRC_CAMERAPORT2_IPCAM,
   SRC_CAMERAPORT2_SPLITSCREEN,
   SRC_CAMERAPORT2_USB_VIDEO,
   SRC_CAMERAPORT2_HDMI,
   SRC_CAMERAPORT3_CAM1,
   SRC_CAMERAPORT3_CAM2,
   SRC_CAMERAPORT3_CAM3,
   SRC_CAMERAPORT3_CAM4,
   SRC_CAMERAPORT3_IPCAM,
   SRC_CAMERAPORT3_SPLITSCREEN,
   SRC_CAMERAPORT3_USB_VIDEO,
   SRC_CAMERAPORT3_HDMI,
   SRC_CAMERAPORT4_CAM1,
   SRC_CAMERAPORT4_CAM2,
   SRC_CAMERAPORT4_CAM3,
   SRC_CAMERAPORT4_CAM4,
   SRC_CAMERAPORT4_IPCAM,
   SRC_CAMERAPORT4_SPLITSCREEN,
   SRC_CAMERAPORT4_USB_VIDEO,
   SRC_CAMERAPORT4_HDMI,
   SRC_MIC1_ANNOUNCEMENT,
   SRC_MIC2_ANNOUNCEMENT,
   SRC_MIC3_ANNOUNCEMENT,
   SRC_CAMERAPORT1_USB_AUDIO,
   SRC_WEATHER_ALERT,
   SRC_CMR1_USB1_VIDEO,
   SRC_CMR1_USB2_VIDEO,
   SRC_CMR1_USB1_AUDIO,
   SRC_CMR1_USB2_AUDIO,
   SRC_INVALID = GROUP_COUNT * SRC_GROUP_SIZE
};


enum _SourceType
{
   SOURCE_MAIN,
   SOURCE_ANNOUNCEMENT,
   SOURCE_MIX
};


#endif // AudioDefines_h
