/* ***************************************************************************************
* FILE:          AudioControllerObjectManager.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AudioControllerObjectManager.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMI_APPMASTER_AUDIOCONTROLLEROBJECTMANAGER_H
#define HMI_APPMASTER_AUDIOCONTROLLEROBJECTMANAGER_H

#include "boost/smart_ptr/shared_ptr.hpp"
#include "boost/make_shared.hpp"
#include "asf/core/Types.h"
#include "AppHmi_MasterBase/AudioInterface/ConnectionController.h"
#include "AppHmi_MasterBase/AudioInterface/SoundController.h"
#include "AppHmi_MasterBase/AudioInterface/ResourceController.h"
#include "AppHmi_MasterBase/AudioInterface/SoundPropertiesClient/SoundPropertiesReceiverClient.h"
#include "AppHmi_MasterBase/AudioInterface/SoundPropertiesClient/SoundPropertiesSenderClient.h"
#include "AppHmi_MasterBase/AudioInterface/HmiSoundProperties.h"

namespace hmibase {
namespace apphmi_master {
namespace audio {

class AudioControllerObjectManager
{
   public:

      static bool initialize(boost::shared_ptr<ConnectionController> connectionController = boost::make_shared<ConnectionController>(),
                             boost::shared_ptr<SoundController> soundController = boost::make_shared<SoundController>(),
                             boost::shared_ptr<ResourceController> resourceController = boost::make_shared<ResourceController>());

      static AudioControllerObjectManager& getInstance()
      {
         return *_theInstance;
      }

      template< class TConnectionController >
      boost::shared_ptr<TConnectionController> getConnectionController()
      {
         return boost::dynamic_pointer_cast<TConnectionController>(_connectionController);
      }

      template< class TSoundController >
      boost::shared_ptr<TSoundController> getSoundController()
      {
         return boost::dynamic_pointer_cast<TSoundController>(_soundController);
      }

      template< class TResourceController >
      boost::shared_ptr<TResourceController> getResourceController()
      {
         return boost::dynamic_pointer_cast<TResourceController>(_resourceController);
      }

   private:
      AudioControllerObjectManager();

      // Copy constructor
      AudioControllerObjectManager(const AudioControllerObjectManager&);

      AudioControllerObjectManager(boost::shared_ptr<ConnectionController> connectionController,
                                   boost::shared_ptr<SoundController> soundController,
                                   boost::shared_ptr<ResourceController> resourceController);

      // assignment operator shall never be call, therefore make it private
      AudioControllerObjectManager& operator=(const AudioControllerObjectManager& rhc);

      static AudioControllerObjectManager* _theInstance;

      boost::shared_ptr<hmibase::apphmi_master::audio::ConnectionController> _connectionController;
      boost::shared_ptr<hmibase::apphmi_master::audio::SoundController> _soundController;
      boost::shared_ptr<hmibase::apphmi_master::audio::ResourceController> _resourceController;
};


}
}


}
#endif // HMI_APPMASTER_AUDIOCONTROLLEROBJECTMANAGER_H
