/* ***************************************************************************************
* FILE:          AppHmi_MasterHallBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AppHmi_MasterHallBase.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef APPHMI_MASTERHALLBASE_H
#define APPHMI_MASTERHALLBASE_H

#include <map>
#include <string>
#include "asf/core/Proxy.h"
#include "AppBase/HallComponentBase.h"
#include "AppHmi_MasterBase/AudioInterface/ConnectionController.h"
#include "AppHmi_MasterBase/AudioInterface/SoundController.h"
#include "AppHmi_MasterBase/AudioInterface/ResourceController.h"
#include "AppHmi_MasterBase/AudioInterface/HmiGeniviAudioClient.h"
#include "AppHmi_MasterBase/AudioInterface/HmiAudioSourceChange.h"
#include "AppHmi_MasterBase/AudioInterface/HmiSoundProperties.h"

#include "AppHmi_MasterBase/AudioInterface/AudioControllerObjectManager.h"

#define APPHMI_MASTER_INIT_AUDIO_COMPONENTS(connectionCtrl_class, soundCtrl_class, resourceCtrl_class) \
	boost::shared_ptr<connectionCtrl_class> _connectionController ( new connectionCtrl_class() ); \
    boost::shared_ptr<soundCtrl_class> _soundController ( new soundCtrl_class() );                \
    boost::shared_ptr<resourceCtrl_class> _resourceController ( new resourceCtrl_class());             \
    initializeAudioComponents(_connectionController, _soundController, _resourceController);

namespace hmibase {
namespace app {
namespace master {

class AppHmi_MasterHallBase : public hmibase::app::base::HallComponentBase
{
   public:
      AppHmi_MasterHallBase();
      AppHmi_MasterHallBase(const std::string& objname);
      virtual ~AppHmi_MasterHallBase();

      // ServiceAvailableIF implementation
      virtual void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

      // StartupSync::PropertyRegistrationIF
      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

   protected:

#ifdef __never_used__
      // this has to be called in the constructor of the derived class, so therefore it is not made virtual here
//   virtual void initApplicationMap() = 0;
#endif
      using hmibase::app::base::HallComponentBase::onCourierMessage;
#ifdef __never_used__
      inline std::string getApplicationName(int nAppId)
      {
         std::string sRet = "";
         std::map<int, std::string>::iterator itr;
         itr = m_ApplicationStringMap.find(nAppId);
         if (itr != m_ApplicationStringMap.end())
         {
            sRet = itr->second;
         }
         return sRet;
      }
#endif
      void initializeAudioComponents(boost::shared_ptr<hmibase::apphmi_master::audio::ConnectionController> connCtrl,
                                     boost::shared_ptr<hmibase::apphmi_master::audio::SoundController> soundCtrl,
                                     boost::shared_ptr<hmibase::apphmi_master::audio::ResourceController> resourceCtrl);

#ifdef __never_used__
      std::map<int, std::string> m_ApplicationStringMap;
#endif
      hmibase::apphmi_master::audio::HmiGeniviAudioClient _masterAudioClient;
      hmibase::services::audio::HmiAudioSourceChange _audioClientHandler;
      hmibase::services::audio::HmiSoundProperties _hmiSoundProperties;

   private:
};


}
}


namespace appbase {
namespace apphmi_master {
HMIBASE_DEPRECATED_TYPE_ALIAS(AppHmi_MasterHallBase, ::hmibase::app::master::AppHmi_MasterHallBase)
}


}
}


#endif // APPHMI_MASTERHALLBASE_H
