/* ***************************************************************************************
* FILE:          StartupSync.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  StartupSync.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef StartupSync_h
#define StartupSync_h

#include "asf/core/Proxy.h"
#include <set>

class StartupSync
{
   public:
      class PropertyRegistrationIF
      {
         public:
            virtual ~PropertyRegistrationIF() {};
            virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange) = 0;
            virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange) = 0;
            virtual void onServiceSuspended(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/) { }
            virtual void onServiceResumed(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/) { }
      };
      virtual ~StartupSync();
      static StartupSync& getInstance();
      void registerPropertyRegistrationIF(PropertyRegistrationIF* propRegIF, const std::string& portName);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void notifyRegisteredClients();
      void onGuiStartupFinished();

   private:
      std::map<boost::shared_ptr< asf::core::Proxy>, asf::core::ServiceStateChange> _pendingNotifications;
      std::multimap<const std::string, PropertyRegistrationIF*> _propertyRegistration;
      bool _guiReady;
      static StartupSync* _theInstance;

      StartupSync();
      StartupSync(const StartupSync&);
      StartupSync& operator=(const StartupSync& rhc)
      {
         if (this == &rhc)
         {
            return *this;
         }

         _propertyRegistration = rhc._propertyRegistration;
         _pendingNotifications = rhc._pendingNotifications;
         _guiReady = rhc._guiReady;
         return *this;
      }
      void notifyRegisteredClients(const boost::shared_ptr< asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);
};


#endif
