/* ***************************************************************************************
* FILE:          IUserInputObserver.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IUserInputObserver.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "AppBase/ScreenBrokerClient/IUserInputObserver.h"

namespace hmibase {
namespace input {
void IUserInputObserver::onTouchEventDown(int x, int y, uint32_t surface, int32_t id, uint32_t timestamp)
{
   PARAM_UNUSED(x);
   PARAM_UNUSED(y);
   PARAM_UNUSED(surface);
   PARAM_UNUSED(id);
   PARAM_UNUSED(timestamp);
   onInputEvent();
}


void IUserInputObserver::onTouchEventUp(int x, int y, uint32_t surface, int32_t id, uint32_t timestamp)
{
   PARAM_UNUSED(x);
   PARAM_UNUSED(y);
   PARAM_UNUSED(surface);
   PARAM_UNUSED(id);
   PARAM_UNUSED(timestamp);
   onInputEvent();
}


void IUserInputObserver::onTouchEventMove(int x, int y, uint32_t surface, int32_t id, uint32_t timestamp)
{
   PARAM_UNUSED(x);
   PARAM_UNUSED(y);
   PARAM_UNUSED(surface);
   PARAM_UNUSED(id);
   PARAM_UNUSED(timestamp);
   onInputEvent();
}


}
}
