/* ***************************************************************************************
* FILE:          RootDaemonCaller.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RootDaemonCaller.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "RootDaemonClient/RootDaemon.h"
#include "RootDaemonHelper.h"

#include "hmi_trace_if.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/RootDaemonCaller.cpp.trc.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

extern CmdData HMIBASE_ROOTDAEMON_CLIENT_PerformRootOpAsRoot(const int cmdNum, std::string args);


CmdData HMIBASE_ROOTDAEMON_CALLER_PerformRootOp( /*const char                 *clientName,*/
   const tenHmiBaseRootDaemonCmdCode cmdNum,
   std::string                       args)
{
#if(defined(_LINUXX86_64_))
#else
   ETG_TRACE_USR1_THR(("Perform root command %u, effective user id %u, args %s", ETG_CENUM(tenHmiBaseRootDaemonCmdCode, cmdNum), geteuid(), args.c_str()));
#endif
   // When user is root then perform the root operation directly, otherwise
   // perform the root operation via the root daemon.
   if (geteuid() == 0)
   {
      return (HMIBASE_ROOTDAEMON_CLIENT_PerformRootOpAsRoot(cmdNum, args));
   }
   else
   {
      return (RootDaemonHelper::performRootOp("aid_hmibase",
                                              cmdNum,
                                              std::string(args)));
   }
}


/******************************************************************************/

#ifdef __cplusplus
} // extern "C"
#endif
