/* ***************************************************************************************
* FILE:          LcmHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LcmHandler.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMI_APPBASE_LCMHANDLER_H
#define HMI_APPBASE_LCMHANDLER_H
/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     LcmHandler.h
 *\brief   hand crafted code
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifdef _LINUXX86_64_
#include "LcmHandlerDummy.h"
#else
#include "lint_deactivation.h"
#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"
#include "asf/core/Timer.h"
#include "org/bosch/cm/lcm/lcmbaseappcomponent/LcmBaseAppComponent.h"
#include "SPM_CORE_FIProxy.h"
#include "View/IMessageSystem.h"

#include "AppUtils/HmiMacros.h"
#include "hmi_trace_if.h"

namespace hmibase {
namespace app {
namespace base {
namespace lcm {


enum ShutdownType
{
   SHUTDOWN_NOT,
   SHUTDOWN_NORMAL,
   SHUTDOWN_FAST,
   SHUTDOWN_RUNUP
};


class LcmHandlerCallback
{
   public:

      virtual ~LcmHandlerCallback()
      {
      }

      virtual void onLoadPersistency() = 0;
      virtual void onSavePersistency() = 0;
      virtual void onAppSubStateReady(hmibase::HMIStateEnum val) = 0;

      /**
       * return false if positive feedback can be given to LCM, false if response should be given later
       */
      virtual bool OnAppModeChange(ShutdownType newState, ShutdownType oldState) = 0;
};


class LcmHandler:
   public asf::core::TimerCallbackIF
   , public asf::core::ServiceAvailableIF
   , public org::bosch::cm::lcm::lcmbaseappcomponent::LcmApplicationControlIF
   , public SPM_CORE_FI::HmiStateCallbackIF

{
   private:
      LcmHandler();

   public:
      LcmHandler(const std::string& busname, const std::string& objname, LcmHandlerCallback* cb);
      virtual ~LcmHandler();
      // ServiceAvailableIF implementation
      virtual void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

      // TimerCallbackIF implementation
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> payload);

      // LCM Interface implementation
      virtual ::org::bosch::cm::lcm::lcmbaseappcomponent::_NsmErrorStatus_e OnAppModeChange(::org::bosch::cm::lcm::lcmbaseappcomponent::_Nsm_Shutdown_Type_e newAppMode, ::org::bosch::cm::lcm::lcmbaseappcomponent::_Nsm_Shutdown_Type_e oldAppMode);

      virtual bool OnAppWatchdog();
      virtual void OnLcmRegistered();
      // handling persistency
      virtual void onLoadPersistency();
      virtual void onSavePersistency();

      // SPM_CORE_FI::HmiStateCallbackIF
      virtual void onHmiStateError(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SPM_CORE_FI::HmiStateError >& error);
      virtual void onHmiStateStatus(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SPM_CORE_FI::HmiStateStatus >& status);

      void setAppStartReady();
      void sendHmiStateMessage();

      /**
       * send async response to LCM for previously received AppModeChangeRequest
       */
      void SendLifeCycleRequestCompleteRequest()
      {
         _lcmAppComponent.SendLifeCycleRequestCompleteRequest();
      }

   private:
      org::bosch::cm::lcm::lcmbaseappcomponent::LcmBaseAppComponent _lcmAppComponent;

   private:
      ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy > _spmProxy;
      LcmHandlerCallback* _cb;
      bool _appReady;

      void sendHmiStateMessage(::spm_core_fi_types::T_SPM_e32_HMI_STATE state);
      ShutdownType mapPowerState(::org::bosch::cm::lcm::lcmbaseappcomponent::_Nsm_Shutdown_Type_e mode);
};


}
}


}

namespace appbase {
namespace lcm {
HMIBASE_DEPRECATED_TYPE_ALIAS(ShutdownType, ::hmibase::app::base::lcm::ShutdownType)
HMIBASE_DEPRECATED_TYPE_ALIAS(LcmHandlerCallback, ::hmibase::app::base::lcm::LcmHandlerCallback)
HMIBASE_DEPRECATED_CONST_ALIAS(SHUTDOWN_NOT, ::hmibase::app::base::lcm::SHUTDOWN_NOT, ::hmibase::app::base::lcm::ShutdownType)
HMIBASE_DEPRECATED_CONST_ALIAS(SHUTDOWN_NORMAL, ::hmibase::app::base::lcm::SHUTDOWN_NORMAL, ::hmibase::app::base::lcm::ShutdownType)
HMIBASE_DEPRECATED_CONST_ALIAS(SHUTDOWN_FAST, ::hmibase::app::base::lcm::SHUTDOWN_FAST, ::hmibase::app::base::lcm::ShutdownType)
HMIBASE_DEPRECATED_CONST_ALIAS(SHUTDOWN_RUNUP, ::hmibase::app::base::lcm::SHUTDOWN_RUNUP, ::hmibase::app::base::lcm::ShutdownType)
}


}
}


#endif
#endif
