/* ***************************************************************************************
* FILE:          HmiAsfComponentBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HmiAsfComponentBase.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIASFCOMPONENTBASE_H
#define HMIASFCOMPONENTBASE_H

#include <string>
#include "AppUtils/HmiMacros.h"

namespace hmibase {
namespace app {
namespace base {

class HmiAsfComponentBase
{
   public:
      HmiAsfComponentBase();
      explicit HmiAsfComponentBase(const char* appName);
      virtual ~HmiAsfComponentBase();
      static const char* getAppName()
      {
         return _appName.c_str();
      }
      static void setAppName(const char* name)
      {
         _appName = name;
      }
   private:
      static std::string _appName;
};


}
}


}


HMIBASE_DEPRECATED_TYPE_ALIAS(HmiAsfComponentBase, ::hmibase::app::base::HmiAsfComponentBase)


#endif // HMIASFCOMPONENTBASE_H
