/* ***************************************************************************************
* FILE:          HallComponentBaseMessaging.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HallComponentBaseMessaging.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef _HallComponentBaseMessaging_H_
#define _HallComponentBaseMessaging_H_

#include "View/IMessageSystem.h"

namespace hmibase {
namespace app {
namespace base {

class IHallComponentBaseMessaging
{
   public:
      virtual bool onGuiStartupFinished() = 0;
      virtual bool onStatemachineStartupFinished() = 0;
      virtual bool onChangeHmiSubStateReq() = 0;
};


#ifdef VARIANT_S_FTR_ENABLE_COURIERMESSAGING

class HallComponentBaseMessaging : public IHallComponentBaseMessaging
{
   public:
      void processViewEvents();
   public:
      virtual bool onCourierMessage(const Courier::StartupMsg& /*msg*/)
      {
         return onGuiStartupFinished();
      }
      virtual bool onCourierMessage(const GuiStartupFinishedUpdMsg& /*msg*/)
      {
         return onStatemachineStartupFinished();
      }
      virtual bool onCourierMessage(const ChangeHmiSubStateReqMsg& /*msg*/)
      {
         return onChangeHmiSubStateReq();
      }
      COURIER_MSG_MAP_BEGIN(/*TR_CLASS_HMI_FW*/0)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)
      ON_COURIER_MESSAGE(ChangeHmiSubStateReqMsg)
      COURIER_MSG_MAP_END()
};


#endif // VARIANT_S_FTR_ENABLE_COURIERMESSAGING


#ifdef  VARIANT_S_FTR_ENABLE_QT_MESSAGING

class HallComponentBaseMessaging : public QObject, public IHallComponentBaseMessaging
{
      Q_OBJECT
   public:
      void processViewEvents();
   public slots:
      virtual bool onContractMessage(const GuiStartupFinishedUpdMsg& msg);
      virtual bool onContractMessage(const ChangeHmiSubStateReqMsg& msg);
};


#endif
} // namespace
} // namespace
} // namespace


#endif // _HallComponentBaseMessaging_H_
