/* ***************************************************************************************
* FILE:          GuiComponentMessageHandler.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GuiComponentMessageHandler.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "GuiComponentMessageHandler.h"

#include "View/CGI/CgiExtensions/CourierMsgQueue2ASF.h"

::hmibase::view::CourierMsgQueue2ASF _ASFCourierMsgQueue;

namespace hmibase {
namespace app {
namespace base {

//
// OnMessage is called Courier::ModelComponent, fills the message in the queue
// and triggers with triggerHall() ASF with a blob message.
// via ASF onReceiveCourierMessageRequest() hall will be informed to
// dispatch the messages that stored by the GUI into the queue _ASFCourierMsgQueue
//
bool GuiComponentMessageHandler::OnMessage(const Courier::Message& message)
{
   _ASFCourierMsgQueue.addToQueue(message);
   triggerHall();
   // return false here, as we do not know if the message will really be consumed
   //  we only have pushed it into the ASF queue
   return false;
}


POST_MESSAGE_IMPLEMENTATION(GuiComponentMessageHandler, HMISubStateChangedUpdMsg);
}


}
}
