/* ***************************************************************************************
* FILE:          AppControllerBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AppControllerBase.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef _AppControllerBase_H
#define _AppControllerBase_H

#include "View/IMessageSystem.h"

namespace hmibase {
namespace services {
namespace hmiappctrl {

class ProxyHandler;
} // namespace hmiappctrl
} // namespace services
} // namespace hmibase

namespace hmibase {
namespace app {
namespace base {

class AppControllerBase : public Courier::ControllerComponent
{
   public:
      explicit AppControllerBase(::hmibase::services::hmiappctrl::ProxyHandler& proxyHandler);

      AppControllerBase& operator=(const AppControllerBase&)
      {
         return *this;
      }

      static AppControllerBase* getInstance()
      {
         return _controllerbase;
      }
   public:
      bool setSynchronizedSurfaces(unsigned int* surface, unsigned int count);
      bool removeSynchronizedSurfaces(unsigned int* surface, unsigned int count);

      COURIER_MSG_MAP_BEGIN(0/*TR_CLASS_HMI_FW*/)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(HKStatusChangedUpdMsg)
      ON_COURIER_MESSAGE(EncoderStatusChangedUpdMsg)
      ON_COURIER_MESSAGE(PlayBeepReqMsg)
      ON_COURIER_MESSAGE(SetApplicationAsMandatoryReqMsg)
      ON_COURIER_MESSAGE(ShowHMISubSurfaceReqMsg)
      ON_COURIER_MESSAGE(PopupFilterPrioEnableReqMsg)
      ON_COURIER_MESSAGE(PopupFilterAllEnableReqMsg)
      ON_COURIER_MESSAGE(PopupFilterDisableReqMsg)
      ON_COURIER_MESSAGE(MultiDisplayPopupFilterReqMsg)
      ON_COURIER_MESSAGE(hmibase::gadget::ExternalImageProviderReqMsg)
      ON_COURIER_MESSAGE(hmibase::gadget::ExternalImageProviderGroupReqMsg)
      ON_COURIER_MESSAGE(hmibase::gadget::TouchForwardReqMsg)
      ON_COURIER_MESSAGE(hmibase::gadget::TouchAbortReqMsg)
      ON_COURIER_MESSAGE(hmibase::gadget::SlaveSurfaceRepositionReqMsg)
      ON_COURIER_MESSAGE(hmibase::gadget::SlaveSurfaceRepositionResMsg)
      ON_COURIER_MESSAGE(hmibase::gadget::PositionInfoReqMsg)
      ON_COURIER_MESSAGE(hmibase::gadget::PositionInfoResMsg)
      ON_COURIER_MESSAGE(hmibase::gadget::DrmAllocationStatusMsg)
      ON_COURIER_MESSAGE(RenderingCompleteMsg)
      ON_COURIER_MESSAGE(SurfaceStateChangedUpdMsg)
      ON_COURIER_MESSAGE(ClosePopupOnExternalTouchReqMsg)
      ON_COURIER_MESSAGE(ApplicationStateUpdMsg)
      ON_COURIER_MESSAGE(StartLayerAnimationReqMsg)
      COURIER_MSG_MAP_END()

      virtual bool onCourierMessage(const Courier::StartupMsg& msg);
      virtual bool onCourierMessage(const HKStatusChangedUpdMsg& msg);
      virtual bool onCourierMessage(const EncoderStatusChangedUpdMsg& msg);
      virtual bool onCourierMessage(const PlayBeepReqMsg& msg);
      virtual bool onCourierMessage(const SetApplicationAsMandatoryReqMsg& msg);
      virtual bool onCourierMessage(const hmibase::gadget::ExternalImageProviderReqMsg& msg);
      virtual bool onCourierMessage(const hmibase::gadget::ExternalImageProviderGroupReqMsg& msg);
      virtual bool onCourierMessage(const ShowHMISubSurfaceReqMsg& msg);
      virtual bool onCourierMessage(const PopupFilterPrioEnableReqMsg& msg);
      virtual bool onCourierMessage(const PopupFilterAllEnableReqMsg& msg);
      virtual bool onCourierMessage(const PopupFilterDisableReqMsg& msg);
      virtual bool onCourierMessage(const MultiDisplayPopupFilterReqMsg& msg);
      virtual bool onCourierMessage(const hmibase::gadget::TouchForwardReqMsg& msg);
      virtual bool onCourierMessage(const hmibase::gadget::TouchAbortReqMsg& msg);
      virtual bool onCourierMessage(const hmibase::gadget::SlaveSurfaceRepositionReqMsg& msg);
      virtual bool onCourierMessage(const hmibase::gadget::SlaveSurfaceRepositionResMsg& msg);
      virtual bool onCourierMessage(const hmibase::gadget::PositionInfoReqMsg& msg);
      virtual bool onCourierMessage(const hmibase::gadget::PositionInfoResMsg& msg);
      virtual bool onCourierMessage(const hmibase::gadget::DrmAllocationStatusMsg& msg);
      virtual bool onCourierMessage(const RenderingCompleteMsg& msg);
      virtual bool onCourierMessage(const SurfaceStateChangedUpdMsg& msg);
      virtual bool onCourierMessage(const ClosePopupOnExternalTouchReqMsg& msg);
      virtual bool onCourierMessage(const ApplicationStateUpdMsg& msg);
      virtual bool onCourierMessage(const StartLayerAnimationReqMsg& msg);
   protected:
      ::hmibase::services::hmiappctrl::ProxyHandler& _hmiAppCtrlProxyHandler;
      bool                                           _standalone;
      static AppControllerBase*                      _controllerbase;
};


} // namespace
} // namespace
} // namespace


#include "AppUtils/HmiMacros.h"
HMIBASE_DEPRECATED_TYPE_ALIAS(CGIAppControllerBase, ::hmibase::app::base::AppControllerBase)

#endif // AppControllerBase_H
