/* ***************************************************************************************
* FILE:          CCASocketGateway.h
* SW-COMPONENT:  LCM-Generic
*  DESCRIPTION:  CCASocketGateway.h is part of Bosch LCM framework Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include <vector>
#include <string>
#include <stdint.h>


class MessageReceiverMirror
{
   private:
      static void ccaMessageReceiverThreadProc(uint32_t appid);
   public:
      static void startCcaMessageReceiver(uint32_t appId);
};


class SocketReceiver
{
   private:
      uint32_t waitForSocketHeader(int sockId, uint32_t& cmdId);
   public:
      bool waitForSocketMessage(int sockId);
};


class TargetCcaSocketGateway : public SocketReceiver
{
   private:
      static void* socketServerThreadProc(void* ptrClass);
      bool socketServerThread();
   public:
      TargetCcaSocketGateway();
      bool startSocketServer(uint32_t port);
};


class HostCcaSocketGateway : public SocketReceiver
{
   private:
      static void* clientMainThreadProc(void* ptrClass);
      bool clientMainThread();
      void addServicesToMirror(std::string csvMboxNumbers);
      void addAppIdsToMirror(std::string csvMboxNumbers);
      std::vector<uint32_t> _vecServiceID;
      std::vector<uint32_t> _vecAppId;
      uint32_t              _port;
   public:
      HostCcaSocketGateway();
      void addServiceIdToMirror(uint32_t id);
      void addAppIdToMirror(uint32_t id);
      void connectTarget();
      void connectTarget(const char* csvMailboxesServices, const char* csvMailboxesAppId);
};


#ifdef __cplusplus
extern "C" {
#endif

void vStartApp(int argc, char** argv);

#ifdef __cplusplus
}


#endif
