/*
 * g3g_dbusconnection.cpp
 *
 *  Created on: Sep 13, 2012
 *      Author: rjk2hi
 */


#include <dbus/dbus.h>

#include "g3g_dbus.h"
#include "CAmSocketHandler.h"
#include "g3g_dbusconnection.h"
#include <iostream>
using namespace std;

/*
 * Initialize all static variables here
 */

am::CAmSocketHandler* g_poSocketHandler;

std::map<DBusBusType,g3g_dbusconnection*> g3g_dbusconnection::mMapHandleConnections;

/*
 * Get Socket Handler Pointer
 */
am::CAmSocketHandler* pSocketHandler()
{
	if(g_poSocketHandler == NULL)
	{
		g_poSocketHandler = new am::CAmSocketHandler();
	}
	return g_poSocketHandler;
}

/*
 * Constructor
 */
g3g_dbusconnection::g3g_dbusconnection(DBusBusType eType)
:mMapHandleWatch(),
mpListTimerHandles(),
pDbusCheckCallback(this, &g3g_dbusconnection::bCheckCallback),
pDbusTimerCallback(this, &g3g_dbusconnection::vTimerCallback),
pDbusFireCallback(this, &g3g_dbusconnection::vFireCallback),
pDbusDispatchCallback(this, &g3g_dbusconnection::bDispatchCallback),
e8ErrCode(DBERR_NONE),
m_eBusType(eType)
{
	dbus_threads_init_default();//Init dbus locking mechanism
	if(!bSetup(eType))
	{
		cout<<"Setup DBUs Connection Failed !!!!!!!"<<endl;
	}
}

/*
 * Destructor
 */
g3g_dbusconnection::~g3g_dbusconnection()
{
	dbus_connection_close(m_ptrConn);
	//Remove reference from map list
	std::map<DBusBusType,g3g_dbusconnection*>::iterator it = g3g_dbusconnection::mMapHandleConnections.find(m_eBusType);
	if(it != g3g_dbusconnection::mMapHandleConnections.end())
	{
		g3g_dbusconnection::mMapHandleConnections.erase(it);
	}
	m_ptrConn = NULL;
}

/*
 * Helper function to setup dbus connection
 */
bool g3g_dbusconnection::bSetup(DBusBusType eType)
{
	DBusError err;

	dbus_error_init(&err);

	m_ptrConn = dbus_bus_get_private(eType,&err);

	if(m_ptrConn == NULL)
	{
		cout<<"connection is NULL "<<endl;
		return false;
	}
	else
	{
#ifdef DEBUG_ENABLE
		cout<<"connection to DBus : "<<m_ptrConn<<endl;
#endif
	}

	if(dbus_error_is_set(&err))
	{
		cout<<"Error to get connection to dbus"<<endl;
		dbus_error_free(&err);
		return false;
	}

	dbus_bool_t re;

	//Set watch functions
	re = dbus_connection_set_watch_functions(m_ptrConn,bAddWatch,vRemoveWatch,vToggleWatch,this,0);

	if(!re)
	{
		cout<<"Setting watch failed"<<endl;
		return false;
	}

	re = re & dbus_connection_set_timeout_functions(m_ptrConn,bAddTimeout,vRemoveTimeout,vToggleTimeout,this,0);

	if(!re)
	{
		cout<<"Dbus set timeout functions failed "<<endl;
		return false;
	}
	return true;
}

/************************************************************
 * Timer functions
 ************************************************************/

/*
 * Function to Add timeout
 */
dbus_bool_t	g3g_dbusconnection::bAddTimeout(DBusTimeout *timeout, void* pvUserData)
{
	g3g_dbusconnection* ptrself = reinterpret_cast<g3g_dbusconnection*>(pvUserData);

	if(ptrself)
	{
		/*
		 *If timeout get is not enabled, return false
		 */
		if(!dbus_timeout_get_enabled(timeout))
		{
			return false;
		}

		//Calculate timeout in interval
		timespec polltimeout;
		int localtimeout = dbus_timeout_get_interval(timeout);
		polltimeout.tv_sec = localtimeout / 1000;
		polltimeout.tv_nsec = (localtimeout % 1000)* 1000000;

		//Prepare handle and callback
		am::sh_timerHandle_t* handle = new am::sh_timerHandle_t;
		if(handle == NULL)//Satisfying lint
			return false;
		ptrself->mpListTimerHandles.push_back(handle);

		//add timer to poll loop
		pSocketHandler()->addTimer(polltimeout,&ptrself->pDbusTimerCallback, *handle, timeout);

		//Save handle with dbus context
		dbus_timeout_set_data(timeout,handle,NULL);

		//Save timeout in Socket context
		pvUserData = timeout;//ToDo : This is wrong to do here ???
#ifdef DEBUG_ENABLE
		std::cout<<"Added timeout "<<localtimeout<<", Handle :"<<*handle<<std::endl;
#endif
		return true;
	}
	return false;
}
/*
 * Function to remove timeout
 */
void g3g_dbusconnection::vRemoveTimeout(DBusTimeout *timeout, void* pvUserData)
{
	g3g_dbusconnection* ptrself = reinterpret_cast<g3g_dbusconnection*>(pvUserData);
    if(ptrself)
    {
    	//get the pointer to the handle and remove the timer
    	am::sh_timerHandle_t* handle = (am::sh_timerHandle_t*) dbus_timeout_get_data(timeout);
    	pSocketHandler()->removeTimer(*handle);

    	//now go throught the timerlist and remove the pointer, free memory
    	std::vector<am::sh_timerHandle_t*>::iterator it = ptrself->mpListTimerHandles.begin();
    	for (; it != ptrself->mpListTimerHandles.end(); ++it)
    	{
    		if (*it == handle)
    		{
    			ptrself->mpListTimerHandles.erase(it);
    			break;
    		}
    	}
    	delete handle;
#ifdef DEBUG_ENABLE
    	std::cout<<"g3g_dbusconnection::removeTimeoutDelegate a timeout was removed"<<std::endl;
#endif
    }
}

/*
 * Function to toggle timeout
 */
void g3g_dbusconnection::vToggleTimeout(DBusTimeout *timeout, void* pvUserData)
{
	g3g_dbusconnection* ptrself = reinterpret_cast<g3g_dbusconnection*>(pvUserData);
    if(ptrself)
    {
    	//get the pointer to the handle and remove the timer
    	am::sh_timerHandle_t* handle = (am::sh_timerHandle_t*) dbus_timeout_get_data(timeout);

    	//stop or restart?
    	if (dbus_timeout_get_enabled(timeout))
    	{
    		//calculate the timeout in timeval
    		timespec pollTimeout;
    		int localTimeout = dbus_timeout_get_interval(timeout);
    		pollTimeout.tv_sec = localTimeout / 1000;
    		pollTimeout.tv_nsec = (localTimeout % 1000) * 1000000;
    		pSocketHandler()->updateTimer(*handle, pollTimeout);
    	}
    	else
    	{
    		pSocketHandler()->stopTimer(*handle);
    	}
#ifdef DEBUG_ENABLE
    	std::cout<<"g3g_dbusconnection::toggleTimeoutDelegate was called"<<std::endl;
#endif
    }
}

/************************************************************
 * Watch functions
 ************************************************************/
/*
 * Function to add watch
 */
dbus_bool_t g3g_dbusconnection::bAddWatch(DBusWatch *watch, void* pvUserData)
{

	g3g_dbusconnection* ptrself = static_cast<g3g_dbusconnection*>(pvUserData);
	if(ptrself)
	{
		int16_t events = 0;
		uint flags;
		am::sh_pollHandle_t handle = 0;

		//Extract flags from watch
		flags = dbus_watch_get_flags(watch);

		//Check if watch is enabled
		if(dbus_watch_get_enabled(watch))
		{
			if(flags & DBUS_WATCH_READABLE)
			{
				events |= POLLIN;
			}
			if(flags & DBUS_WATCH_WRITABLE)
			{
				events |= POLLOUT;
			}
			T_e8_internalerror_e error = pSocketHandler()->addFDPoll(dbus_watch_get_unix_fd(watch), events, NULL, &ptrself->pDbusFireCallback, &ptrself->pDbusCheckCallback, &ptrself->pDbusDispatchCallback, watch,handle);
			if((error == E_OK)&& (handle != 0))
			{
				ptrself->mMapHandleWatch.insert(std::make_pair(watch,handle));
#ifdef DEBUG_ENABLE
				std::cout<<"Added watch with handle "<<handle<<std::endl;
#endif
				return (true);
			}
			std::cout<<"Adding watch failed, as no watches are enabled"<<std::endl;
		}
	}
	else
	{
		cout<<"g3g_dbusconnection::bAddWatch Recieved NULL as user data"<<endl;
	}
	return (true);
}

/*
 * Function to remove watch
 */
void g3g_dbusconnection::vRemoveWatch(DBusWatch *watch, void* pvUserData)
{
	g3g_dbusconnection* ptrself = reinterpret_cast<g3g_dbusconnection*>(pvUserData);
	if(ptrself)
	{
		std::map<DBusWatch*, am::sh_pollHandle_t>::iterator it = ptrself->mMapHandleWatch.begin();

		it = ptrself->mMapHandleWatch.find(watch);

		if(it != ptrself->mMapHandleWatch.end())
		{
			pSocketHandler()->removeFDPoll(it->second);
#ifdef DEBUG_ENABLE
			std::cout<<"Removed watch with handle "<<it->second<<std::endl;
#endif
			ptrself->mMapHandleWatch.erase(it);
		}
	}
}

/*
 * Function to toggle watch
 */
void g3g_dbusconnection::vToggleWatch(DBusWatch *watch, void* pvUserData)
{
	g3g_dbusconnection* ptrself = reinterpret_cast<g3g_dbusconnection*>(pvUserData);
	if(ptrself)
	{
		int16_t event = 0;
		dbus_watch_get_unix_fd(watch);
		uint flags = dbus_watch_get_flags(watch);
		if(dbus_watch_get_enabled(watch))
		{
			if(flags & DBUS_WATCH_READABLE)
			{
				event |= POLLIN;
			}
			if(flags & DBUS_WATCH_WRITABLE)
			{
				event |= POLLOUT;
			}
		}
		std::map<DBusWatch*, am::sh_pollHandle_t>::iterator it = ptrself->mMapHandleWatch.begin();
		it = ptrself->mMapHandleWatch.find(watch);
		if(it != ptrself->mMapHandleWatch.end())
		{
			pSocketHandler()->updateEventFlags(it->second, event);
#ifdef DEBUG_ENABLE
			std::cout <<"Watch toggled: "<<it->second<<std::endl;
#endif
		}
		else
		{
			std::cout << "Watch not found"<<std::endl;
		}
	}
}

/****************************************************************************************
 * SOCKET HANDLER RELATED FUNCTIONS
 ****************************************************************************************/
/*
 * Dispatch callback function
 */
bool g3g_dbusconnection::bDispatchCallback(const am::sh_pollHandle_t handle, void* pvuserdata)
{
	(void)handle;
	(void)pvuserdata;

	bool bretval = true;

	//get the corresponding connection
	dbus_connection_ref(m_ptrConn);
	if(dbus_connection_dispatch(m_ptrConn) == DBUS_DISPATCH_COMPLETE)
	{
		bretval = false;
	}
	dbus_connection_unref(m_ptrConn);
	return bretval;
}

/*
 * Check callback fucntion
 */
bool g3g_dbusconnection::bCheckCallback(const am::sh_pollHandle_t handle, void* pvuserdata)
{
	(void)handle;
	(void)pvuserdata;

	bool bretval = false;
	dbus_connection_ref(m_ptrConn);
	if(dbus_connection_get_dispatch_status(m_ptrConn) == DBUS_DISPATCH_DATA_REMAINS)
		bretval = true;
	dbus_connection_unref(m_ptrConn);
	return bretval;
}

/*
 * fire callback function
 */
void g3g_dbusconnection::vFireCallback(const pollfd polfd, const am::sh_pollHandle_t handle, void* pvuserdata)
{
	(void)handle;
	(void)pvuserdata;

	if(pvuserdata != NULL)
	{
		uint flags = 0;

		if(polfd.revents & POLLIN)
		{
			flags |= DBUS_WATCH_READABLE;
		}
		if(polfd.revents & POLLOUT)
		{
			flags |= DBUS_WATCH_WRITABLE;
		}
		if(polfd.revents & POLLHUP)
		{
			flags |= DBUS_WATCH_HANGUP;
		}
		if(polfd.revents & POLLERR)
		{
			flags |= DBUS_WATCH_ERROR;
		}

		DBusWatch *watch = (DBusWatch*)pvuserdata;

		dbus_connection_ref(m_ptrConn);
		dbus_watch_handle(watch, flags);
		dbus_connection_unref(m_ptrConn);
	}
	else
	{
		std::cout <<"vFireCallback > User data is NULL !!!!"<<std::endl;
	}
}
/*
 * Timer callback function
 */
void g3g_dbusconnection::vTimerCallback(am::sh_timerHandle_t handle, void* pvuserdata)
{
	if(pvuserdata != NULL)
	{
		if(dbus_timeout_get_enabled((DBusTimeout*) pvuserdata))//TODo : What to do now??? Mostly handled
		{
			pSocketHandler()->restartTimer(handle);
		}
	}
	else
	{
		std::cout<<"User Data is NULL !!!"<<std::endl;
	}
}

/*******************************************************
 * Other functions
 *******************************************************/
DBusConnection* g3g_dbusconnection::pGetDbusConnectionPtr()
{
	return m_ptrConn;
}

g3g_dbusconnection* g3g_dbusconnection::getConnection(DBusBusType eType)
{
	g3g_dbusconnection* rfConnect = NULL;
	std::map<DBusBusType,g3g_dbusconnection*>::iterator it = mMapHandleConnections.find(eType);
	if(it != mMapHandleConnections.end())
	{
		rfConnect = it->second;
	}
	else
	{
		rfConnect = new g3g_dbusconnection(eType);
		if(NULL == rfConnect)
		{
			std::cout<<"Not Enough Memory"<<std::endl;
		}
		else
		{
			//Manage
			mMapHandleConnections.insert(std::make_pair(eType,rfConnect));
		}
	}
	return rfConnect;
}

