#ifndef ETHERNET_H
#define ETHERNET_H
/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     ethernetbus.h
 *\brief
 *
 *\author   CM-PS/ESW-Feldhaus
 *\par Copyright:
 *(c) 2012 Robert Bosch Car Multimedia GmbH
 *\par History:
 * See history of revision control system
 ***************************************************************************/

/****************************************************************************
| includes
|--------------------------------------------------------------------------*/

#include <list>
#include <map>

#include <string>
#include <stdio.h>
#include <sys/socket.h>
#include <unistd.h>
#include <sys/types.h>
#include <netdb.h>
#include <pthread.h>

#include "DoIP_ServerCfg.h"



class DoIP_Protocoll;
class DoIP_Server;
class DoIP_Factory;

class tclEthernetBus
{
    // Must not be copied or assigned to prevent multiple delete calls
    // for pszDeviceName member in destructor.
    tclEthernetBus ( const tclEthernetBus& obj ) = delete;                                                           \
    tclEthernetBus& operator = ( const tclEthernetBus& obj ) = delete;

public:
   tclEthernetBus(tU8 u8Number, const char* pszDevice);
   tclEthernetBus(tU8 u8Number, sockaddr_in rAddr);

    virtual ~tclEthernetBus();

    MOCK_VIRTUAL void vTraceStackDump(void);

   MOCK_VIRTUAL DoIP_Protocoll* poSetDoIPConfig(tU16 u16Port, tU16 u16SourceAddr, const char* pszEID, const char* pszGID, DoIP_Factory *poFactory);
   MOCK_VIRTUAL DoIP_Protocoll* poSetDoIPConfig(tU16 u16Port, tU16 u16SourceAddr, const char* pszEID, const char* pszGID);

    MOCK_VIRTUAL DoIP_Protocoll* poGetDoIPProtocoll() { return poDoIP_Protocoll; }

    /*!
    * \brief   Starts the CAN bus to DOWN mode. State changes may be requested
    *          from now on. (see vCommReq)
    *          Client registrations are now allowed.
    */
    MOCK_VIRTUAL bool bStart();

    /*!
    * \brief   Stops the CAN bus and sets it to INITIALIZED mode.
    */
    MOCK_VIRTUAL bool bStop();


   MOCK_VIRTUAL bool bRegister(DoIP_Server* poServer, char const* acVIN, tU8 u8VINlen);
   MOCK_VIRTUAL bool bRemove(DoIP_Server* poServer);

   static tS32 s32GetTimestamp();
   static void vUpdateTimestamp();


   static const tU32 cu32CommonTimerStep  = 10; // ms

   MOCK_VIRTUAL void vCommonTimerTick(void);

   const tU8 cu8BusNumber;

   MOCK_VIRTUAL bool bHasValidMacAddress() { return bValidMacAddress; }
   MOCK_VIRTUAL tU8* pu8GetMacAddress() { return au8MacAddress; }
   MOCK_VIRTUAL const char* pszGetDeviceName() { return pszDeviceName == NULL ? "" : pszDeviceName; }

public:
   virtual bool bEnterCriticalSection() = 0;
   virtual bool bLeaveCriticalSection() = 0;

protected:
   bool bCheckIPAddress();


   char* pszDeviceName;
   tU8   au8MacAddress[6];
   bool  bValidMacAddress;

   struct sockaddr_in   IPv4;
   struct sockaddr_in   IPv4_bcast;
   struct sockaddr_in6  IPv6;
   bool bIPv4allocated;
   bool bIPv6allocated;


private:
   tU8 bcd2byte(char highNibble, char lowNibble);
   DoIP_Protocoll* poDoIP_Protocoll;

   static const tU32 cu32IPCheckIntervall = 1000; //ms
   tU32 u32IPCheckTimer;

private:
   static tS32 s32CurrentTime;

};

#endif //ETHERNET_H

