#ifndef DOIP_SOCKET_H
#define DOIP_SOCKET_H
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
class DoIP_Socket {
public:
   DoIP_Socket():mFd(0) {}
   DoIP_Socket(int fd):mFd(fd) {}
   virtual ~DoIP_Socket() {}

   MOCK_VIRTUAL int create(int domain, int type, int protocol) {
      mFd=::socket(domain, type, protocol);
      return mFd;
   }

   MOCK_VIRTUAL int bind(const struct sockaddr *addr, socklen_t addren) {
      return ::bind(mFd, addr, addren);
   }

   MOCK_VIRTUAL int listen(int backlog) {
      return ::listen(mFd, backlog);
   }

   MOCK_VIRTUAL int accept(struct sockaddr *addr, socklen_t *addren) {
      return ::accept(mFd, addr, addren);
   }

   MOCK_VIRTUAL ssize_t send(const void *buf, size_t len) {
      return ::send(mFd, buf, len, 0);
   }
   MOCK_VIRTUAL ssize_t read(void *buf, size_t len) {
      return ::read(mFd, buf, len);
   }

   MOCK_VIRTUAL ssize_t sendto(const void *buf, size_t len, int flags, const struct sockaddr *dest_addr, socklen_t addrlen) {
      return ::sendto(mFd, buf, len, flags, dest_addr, addrlen);
   }

   MOCK_VIRTUAL ssize_t recvfrom(void *buf, size_t len, int flags, struct sockaddr *src_addr, socklen_t *addrlen) {
      return ::recvfrom(mFd, buf, len, flags, src_addr, addrlen);
   }

   MOCK_VIRTUAL void setFd(int fd) {
      mFd=fd;
   }

   MOCK_VIRTUAL int getFd() {
      return mFd;
   }

   MOCK_VIRTUAL int setsockopt(int level, int optname, const void *optval, socklen_t optlen) {
      return ::setsockopt(mFd, level, optname, optval, optlen);
   }

   MOCK_VIRTUAL int getsockopt(int level, int optname, void *optval, socklen_t *optlen) {
      return ::getsockopt(mFd, level, optname, optval, optlen);
   }

   MOCK_VIRTUAL int shutdown(int how) {
      return ::shutdown(mFd, how);
   }

   MOCK_VIRTUAL int close() {
      int res =::close(mFd);
      mFd=-1;
      return res;
   }


private:
   int mFd;
};

#endif
