/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     DoIP_ServerCfg.h
 *\brief    static configurations of DoIP protocol library for a server
 *
 *\author   CM-CI1/ENP1 - Losch
 *
 *\par Copyright:
 *(c) 2018 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/

#ifndef DOIP_SERVER_CFG_H
#define DOIP_SERVER_CFG_H

#include "doipcommon/DoIP_Types.h"


/*Configure GID and EID numbers */
#define DOIP_EID_BYTE0  0x00
#define DOIP_EID_BYTE1  0x00
#define DOIP_EID_BYTE2  0x00
#define DOIP_EID_BYTE3  0x00
#define DOIP_EID_BYTE4  0x00
#define DOIP_EID_BYTE5  0x0F

#define DOIP_GID_BYTE0  0x00
#define DOIP_GID_BYTE1  0x00
#define DOIP_GID_BYTE2  0x00
#define DOIP_GID_BYTE3  0x00
#define DOIP_GID_BYTE4  0x00
#define DOIP_GID_BYTE5  0x90

//DoIP general times
#define DOIP_CFG_AliveCheckResponseTimeout              500u   //ms
#define DOIP_CFG_GeneralInactivityTime                  5000u  //ms - ISO_13400-2_2012 definition = 5mins
#define DOIP_CFG_InitialInactivityTime                  500u   //ms - ISO_13400-2_2012 definition = 2secs
#define DOIP_CFG_InitialVehicleAnnouncementTime         100u   //ms - ISO_13400-2_2012 definition = 0..500msecs
#define DOIP_CFG_VehicleAnnouncementInterval            500u   //ms

//DoIP general switches
#define DOIP_CFG_EntityStatusMaxByteFieldUse            TRUE

#if ( DOIP_CFG_EntityStatusMaxByteFieldUse != FALSE )
#define DOIP_PAYLOAD_LENGTH_ENTITY_STATUS_RESP          0x00000007u
#else
#define DOIP_PAYLOAD_LENGTH_ENTITY_STATUS_RESP          0x00000003u
#endif



#define DOIP_CFG_GenericHeaderIgnoreInvalidUDP          TRUE // required to avoid endless message pingpong in case of multi-DoIP node systems

//DoIP general values
#define DOIP_CFG_GIDInvalidityPattern                   85u
#define DOIP_CFG_MaxUDPRequestPerMessage                3u
/*Extra one location is provided for storing NACK when the queue is full*/
#define DOIP_CFG_MaxUDPQueueSize    (DOIP_CFG_MaxUDPRequestPerMessage + 1u)

#define DOIP_CFG_NodeType                               DOIP_GATEWAY
#define DOIP_CFG_VehicleAnnouncementRepetition          3u
#define DOIP_CFG_VinInvalidityPattern                   170u



#define DOIP_CFG_cu32UDPBufferSize             128U
#define DOIP_CFG_cu32TCPMaxRequestSize         65535
#define DOIP_CFG_cu32TCPBufferSize             (16*1024)



#endif
