/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     DoIP_Server.h
 *\brief    this is the proxy of an internal DoIP node instance to which a
 *          route may be activated.
 *
 *\author   CM-CI1/ENP1 - Losch
 *
 *\par Copyright:
 *(c) 2018 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/
#ifndef DOIP_SERVER_H
#define DOIP_SERVER_H


#include "DoIP_ServerCfg.h"
#include "ethernetbus.h"


class DoIP_Channel;


class DoIP_Server
{
   /* a DoIP_Server is a specific channel that routes to API applications instead of other internal protocols and networks */
public:
   DoIP_Server(tclEthernetBus* poBus, tU16 u16LocalAddr, char const acVIN[], tU8 u8VINlen);
   virtual ~DoIP_Server();

   virtual tU8 u8GetBusNumber();

   static const tU32 cu32MaxDataLen = 65535;

   virtual void vAddDoIPChannel(DoIP_Channel* poChan) = 0;
   virtual void vRemoveDoIPChannel(DoIP_Channel* poChan) = 0;

   virtual void vPowerModeRequest(void) = 0;
   virtual void vRoutingActivationAuthenticationReq(tU16 sourceAddr, tU8 activationType, tU8* AuthenticationReqData) = 0;
   #if 0
   virtual void vRoutingActivationConfirmationReq(tU16 sourceAddr, tU8 activationType, tU8* ConfirmedReqData) = 0;
   #endif

   MOCK_VIRTUAL void vPowerModeResponse(tU8 powerState);
   MOCK_VIRTUAL void vRoutingActivationAuthenticationResp(bool Authentified, tU8* AuthenticationResData);
   #if 0
   void vRoutingActivationConfirmationResp(bool Confirmed, tU8* ConfirmedResData);
   #endif

   const tU16 cu16LocalAddr;

private:
   tclEthernetBus* poEthBus;
};

#endif
