/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     DoIP_Channel.h
 *\brief    definition of a DoIP channel
 *          a channel is a communication pipe between a DoIP tester entity
 *          and one node in the sub-network behind the DoIP server where
 *          this stack serves as gateway.
 *          (this may also be internal pipe to another local process)
 *
 *\author   CM-CI1/ENP1 - Losch
 *
 *\par Copyright:
 *(c) 2018 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/
#ifndef DOIP_CHANNEL_H
#define DOIP_CHANNEL_H

#include "DoIP_ServerCfg.h"

class DoIP_Connection;
class DoIP_Protocoll;


class DoIP_Channel
{
public:
   DoIP_Channel(DoIP_Connection* poConn, tU16 u16TargetAddress);
   virtual ~DoIP_Channel();

   virtual void vTraceStackDump() = 0;

   const tU16 cu16TargetAddress;

   /** this method is not part of the doip_lib and must also be implemented by the user process in case 
    DOIP_USE_FACTORY is not set*/
   static DoIP_Channel* poCreate(DoIP_Connection* poConn, DoIP_ChannelType type, tU8 busNumber, tU16 testerSA, tU16 targetSA, tU32 baseaddr, tU8 addrext);

   virtual tU32 u32RxStartOfReception(tU32 u32Len) = 0;
   virtual void vRxIndication(tU8 au8Data[], tU32 u32Len) = 0;
   virtual void vTxConfirmation(tBool bOk) = 0;
   virtual void vRxError(tU32 u32Error) = 0;

protected:
   DoIP_Connection* poConn;
};


#endif /*DOIP_CHANNEL_H*/
