/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2017
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
***************************************************************************/

/*!
*\file     DoIP_Channel.cpp
*\brief
*
*\author   CM-CI3/ESW-Losch
*
*\par Copyright:
*(c) 2017 Robert Bosch Car Multimedia GmbH
*
*\par History:
* See history of revision control system
***************************************************************************/

/****************************************************************************
| includes
|--------------------------------------------------------------------------*/
#include "DoIP_Connection.h"
#include "DoIP_Server.h"
#include "DoIP_Channel.h"
#include "ethernetbus.h"


DoIP_Channel::DoIP_Channel(DoIP_Connection* poConn, tU16 u16TargetAddress)
 : cu16TargetAddress(u16TargetAddress),
   poConn(poConn)
{
}

DoIP_Channel::~DoIP_Channel()
{
#ifndef UNIT_TEST
   poConn->bRemove(this);
#endif
}

/**
 * This method must be implemented outside the lib by the user process.
 *
DoIP_Channel* DoIP_Channel::poCreate(DoIP_Connection* poConn, DoIP_ChannelType type, tU8 busNumber, tU16 testerSA, tU16 targetSA, tU32 baseaddr, tU8 addrext)
{
   return NULL;
}
*/


