#include <string.h> // memcpy

#include "DoIP_ClientCfg.h"
#include "DoIP_Utils.h"


void DoIP_Utils::vMemCopyWithEndianessConversion(void* destination, const void* source, tU32 length)
{
   uint16_t      tmp16;
   uint32_t      tmp32;
   const uint8_t *src=(const uint8_t *)source;

   if (1 == length)
   {
      *(uint8_t *)destination=src[0];
   }
   else if (2 == length)
   {
      tmp16 = (uint16_t)(src[0] << 8);
      tmp16 = (uint16_t)(tmp16 | src[1]);
      memcpy(destination, &tmp16, 2);
   }
   else if (4 == length)
   {
      tmp32=(uint32_t)src[0]<<24;
      tmp32|=(uint32_t)src[1]<<16;
      tmp32|=(uint32_t)src[2]<<8;
      tmp32|=(uint32_t)src[3];
      memcpy(destination, &tmp32, 4);
   }
}


bool DoIP_Utils::bCheckHeader(tU8* buffer, tU8* respCode, bool isTP)
{
    tU16 payloadType;
    tU32 payloadLength;
    bool retVal = FALSE;
    tU8 protVer;
    tU8 invProtVer;

    vMemCopyWithEndianessConversion(&payloadType, &buffer[DOIP_MSG_POS_PAYLOAD_TYPE], DOIP_MSG_SIZE_PAYLOAD_TYPE);
    vMemCopyWithEndianessConversion(&payloadLength, &buffer[DOIP_MSG_POS_PAYLOAD_LENGTH], DOIP_MSG_SIZE_PAYLOAD_LENGTH);
    memcpy(&protVer, &buffer[DOIP_MSG_POS_PROTOCOL_VERSION], DOIP_MSG_SIZE_PROTOCOL_VERSION);
    memcpy(&invProtVer, &buffer[DOIP_MSG_POS_INV_PROTOCOL_VERSION], DOIP_MSG_SIZE_INV_PROTOCOL_VERSION);


    DOIP_TRACE_NOTICE("DoIP_Utils::bCheckHeader: payloadType=0x%04x payloadLength=%u protVer=%u",
                              payloadType, payloadLength, protVer);


    if (!bCheckVersionInfo(protVer, invProtVer))
    {
        *respCode = DOIP_GA_RESPCODE_INVALID_PROTOCOL;
    }
    //check: payload type is not supported: nack 0x01, discard
    //only check allowed incoming payloads
    else if (!bCheckPayloadType(payloadType, isTP))
    {
        *respCode = DOIP_GA_RESPCODE_PAYLOAD_TYPE_UNSUPPORTED;
    }
    //check: payload exceeds DoIPMaxRequestBytes: nack 0x02, discard
    else if (payloadLength > (isTP ? (DOIP_CFG_cu32TCPMaxRequestSize+4) : DOIP_CFG_cu32UDPBufferSize))
    {
        *respCode = DOIP_GA_RESPCODE_EXCEEDS_MAX_REQ_BYTES;
    }
    else if (!bCheckPayloadLength(payloadType, payloadLength))
    {
        *respCode = DOIP_GA_RESPCODE_INVALID_PAYLOAD_LENGTH_TYPE;
    }
    else
    {
        retVal = TRUE;
    }
    //check: start of reception buffer size exceeds doip buffer: nack 0x03, discard
    //uncheckable because we don't have a buffer

    return retVal;
}

tU8 DoIP_Utils::u8CheckHeader()
{
 //  tU16 sourceAddr = 0;
 //  tU16 targetAddr = 0;
   tU8 retVal = DOIP_DM_ACKCODE_SUCCESS;
#if 0
   memcpy(&sourceAddr, &buffer[DOIP_MSG_POS_CONTENT + 0u], 2u);
   memcpy(&targetAddr, &buffer[DOIP_MSG_POS_CONTENT + 2u], 2u);

   //check tester SA is registered to established connection -> nack code 0x02, close socket
   if (!bRoutingActivationIsValid(sourceAddr))
   {
      retVal = DOIP_DM_NACKCODE_INVALID_SA;
   }
   //check TA & SA are connected with current activation -> nack 0x03, discard msg
   else if (!bCheckTaConfiguration(targetAddr))
   {
      retVal = DOIP_DM_NACKCODE_UNKNOWN_TA;
   }
   //check payload length is bigger than doIPMaxrequestBytes -> nack 0x04, discard msg
   else if (RX.payloadLength > (DOIP_CFG_cu32TCPMaxRequestSize - 4u))
   {
      retVal = DOIP_DM_NACKCODE_MSG_TOO_LARGE;
   }
   //check buffer size is not big enough -> nack 0x05, discard msg
   /*
     else if( doip buffer < pPduInfoType->SduLength )
     {
     retVal = DOIP_DM_NACKCODE_OUT_OF_MEM;
     }
     */
   //check TA is activated -> nack 0x06, discard msg
   else if (!bCheckTaAtConfiguration(targetAddr))
   {
      retVal = DOIP_DM_NACKCODE_TA_UNREACHABLE;
   }
   else
   {
      retVal = DOIP_DM_ACKCODE_SUCCESS;
   }
#endif

   return retVal;
}

bool DoIP_Utils::bCheckVersionInfo(tU8 protVer, tU8 invProtVer)
{
    bool retVal = TRUE;

    /* Check: Protocol information is correct */
    if (protVer != (tU8) (~invProtVer))
    {
        retVal = FALSE;
    }
    else
    {
        /* vehicle identification request messages are not to be received by tester,
         * so DOIP_PROTOCOL_VERSION_DEFAULT is not to be supported but DOIP_PROTOCOL_VERSION*/
        if (protVer != DOIP_PROTOCOL_VERSION)
        {
            retVal = FALSE;
        }
    }
    return retVal;
}

bool DoIP_Utils::bCheckPayloadType(tU16 payloadType, bool isTP)
{
    DOIP_TRACE_NOTICE("DoIP_Utils::bCheckPayloadType: payloadType=%u isTP=%u",
            payloadType, isTP);

    bool retVal = TRUE;
    if (isTP)
    {
        if (!(    (payloadType == DOIP_PAYLOAD_TYPE_ROUTING_ACTIVATION_RESP)
               || (payloadType == DOIP_PAYLOAD_TYPE_ALIVE_CHECK_REQ)
               || (payloadType == DOIP_PAYLOAD_TYPE_DIAG_MSG)
               || (payloadType == DOIP_PAYLOAD_TYPE_DIAG_MSG_ACK)
               || (payloadType == DOIP_PAYLOAD_TYPE_DIAG_MSG_NACK)
             )
        )
        {
            retVal = FALSE;
        }
    }
    else
    {
        /* Allowed messages for UDP */
        if (!(    (payloadType == DOIP_PAYLOAD_TYPE_VEHICLE_ID_RESP)
               || (payloadType == DOIP_PAYLOAD_TYPE_ENTITY_STATUS_RESP)
               || (payloadType == DOIP_PAYLOAD_TYPE_DIAG_POWERMODE_RESP)
             )
        )
        {
           retVal = FALSE;
        }
    }
    return retVal;
}

bool DoIP_Utils::bCheckPayloadLength(tU16 payloadType, tU32 payloadLength)
{
    bool retVal = TRUE;
    /* check: payload length is not valid for payloadType: nack 0x04, close socket */
    if (       ((payloadType == DOIP_PAYLOAD_TYPE_VEHICLE_ID_RESP)
                    && (payloadLength != DOIP_PAYLOAD_LENGTH_VEHICLE_ID_RESP))
            || ((payloadType == DOIP_PAYLOAD_TYPE_ROUTING_ACTIVATION_RESP)
                    && ((payloadLength != DOIP_PAYLOAD_LENGTH_ROUTING_ACTIVATION_RESP_9)
                   && (payloadLength != DOIP_PAYLOAD_LENGTH_ROUTING_ACTIVATION_RESP_13)))
            || ((payloadType == DOIP_PAYLOAD_TYPE_ALIVE_CHECK_RESP)
                    && (payloadLength != DOIP_PAYLOAD_LENGTH_ALIVE_CHECK_RESP))
            || ((payloadType == DOIP_PAYLOAD_TYPE_DIAG_MSG)
                    && (payloadLength < DOIP_PAYLOAD_LENGTH_DIAG_MSG_MIN))
            || ((payloadType == DOIP_PAYLOAD_TYPE_VEHICLE_ID_RESP)
                    && (payloadLength != DOIP_PAYLOAD_LENGTH_VEHICLE_ID_RESP))
            || ((payloadType == DOIP_PAYLOAD_TYPE_ENTITY_STATUS_RESP)
                    && (payloadLength != mDoipCfg.payloadLengthEntityStatusResp))
            || ((payloadType == DOIP_PAYLOAD_TYPE_DIAG_POWERMODE_RESP)
                    && (payloadLength != DOIP_PAYLOAD_LENGTH_DIAG_POWERMODE_RESP)))
    {
        retVal = FALSE;
    }
    return retVal;
}


void DoIP_Utils::logHex( const char *text, const uint8_t * data, uint32_t len,  uint32_t maxLen)
{
   uint32_t numLogBytes=(uint32_t)std::min(len, maxLen);

     //if (true || mDoipCfg.mTracer.isTraceActive(mDoipCfg.mTracer.mLevelInfo)) 
     {
        
        char buf[numLogBytes * 3 +1];
        for (uint32_t i=0; i<numLogBytes;++i) {
           snprintf(buf + i*3, 4, "%02x ", data[i]);
      }
        buf[numLogBytes * 3]=0;
        DOIP_TRACE_NOTICE("%s (%u bytes): %s\n", text, len, buf);
  }

}


