#include "DoIP_Tracer.h"
#include <cstdarg>

   void DoIP_Tracer::traceFormat(uint8_t level, const char *format, ...) {
      if (!mTraceFn) {
         return;
      }
      static const uint32_t C_TRACE_MAX=255;
      char pBuffer[C_TRACE_MAX + 1];
      ::va_list argList;
      ::va_start(argList, format);
      ::vsnprintf(pBuffer, C_TRACE_MAX, format, argList);
      ::va_end(argList);
      pBuffer[C_TRACE_MAX] = 0;
      mTraceFn(level, pBuffer);
}

