/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     DoIP_Tester.h
 *\brief    this is an internal DoIP Tester used to connect to DoIP nodes
 *
 *\author   CM-CI1/ENP1 - Seidler
 *
 *\par Copyright:
 *(c) 2018 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/
#ifndef DOIP_TESTER_H
#define DOIP_TESTER_H

#include "DoIP_ClientCfg.h"
#include "DoIP_Utils.h"

#include "DoIP_Node.h"

#include <pthread.h>// c++11 required for #include <mutex>
#include <stdlib.h>


class DoIP_Tester
{
	DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(DoIP_Tester);
   /* a DoIP_Tester is a specific DoIO entity that connects to DoIP nodes applications */
public:
   DoIP_Tester(const char* pszDevice, tU16 u16Port, tU16 testerAddress, DoIP_Cfg &doipCfg);
   virtual ~DoIP_Tester();

   void vTraceStackDump(void);
   tDoIPResult Start(void);
   tDoIPResult Stop(void);
   void vCommonTimerTick(void);
   void vdiscoverEntities(const char* in_adr = "255.255.255.255");
   DoIP_Node* pdiscoverEntityInd(sockaddr_in& IP, tU16 logAddr, const tU8* EID, const tU8* GID, tU8 actrequ, tU8 VINGIDstatus, const tU8* VIN);
   virtual DoIP_Node* vAddNode(DoIP_Node* node) = 0;
   virtual DoIP_Node* vAddNode(tU16 testerAddress, sockaddr_in IP, tU16 logAddr, tU32 maxDataSize) = 0;
   virtual DoIP_Node* vAddNode(tU16 testerAddress, sockaddr_in IP, tU16 logAddr, const tU8* EID, const tU8* GID, const tU8* VIN, DoIP_NodeType nodeType, tU32 maxDataSize) = 0;
   DoIP_Node* vGetNodeByAddr(tU16 logicalAddr);
   DoIP_Node* vGetNodeByIP(tU32 ipAddress);

   tDoIPResult doesNodeExist(tU32 ipAddress);
   
   int getUDPClientSocket( void ) { return iSocket_UDP_Client; }

   std::list<DoIP_Node*> getDoIPNodes(void);
   void powermodeReqestAll(void);
   void entityStatusReqAll(void);

   tU8  busNumber;
   tU16 testerAddr;
   static const tU32 cu32CommonTimerStep  = 10; // ms

protected:
   void vRxIndication(tU8 au8UdpBuffer[], tU32 u32RecvBytes, sockaddr_in& remoteaddr);
   bool vConnectionCloseAll(void);
   tDoIPResult vStartUDPClient();
   tDoIPResult vStartUDPBroadcastClient();
   void vStartUDPClient2();
   void vStartUDPBroadcastClient2();

   char* pszDeviceName;
   tU8   au8MacAddress[6];
   struct sockaddr_in   IPv4;
   tU16 cu16Port;
   bool bValidMacAddress;
   bool bIPv4allocated;
   DoIP_Cfg &mDoipCfg;
   int iSocket_UDP_Client;
   int iSocket_UDP_Client_bcast;
   int iSocket_UDP_Client2;
   int iSocket_UDP_Client2_bcast;

   std::list<DoIP_Node*>  oDoIP_Nodes; // list of possible DoIP_Nodes and their instances
   pthread_mutex_t mutDoIP_Nodes;
   DoIP_Node * node;
private:


   // UDP
   //discovery UDP socket from tester
   tU8 udpState;

   pthread_t rUDPClientThread; /* Thread to handle the Ethernet read,write,Rx and Tx states*/
   pthread_t rUDPBroadcastClientThread; /* Thread to handle the Ethernet read,write,Rx and Tx states*/
   pthread_t rUDPBroadcastClient2Thread; /* Thread to handle the Ethernet read,write,Rx and Tx states*/
   pthread_t rUDPClient2Thread; /* Thread to handle the Ethernet read,write,Rx and Tx states*/

   typedef struct
   {
      tU8 buffer[DOIP_CFG_cu32UDPBufferSize];
      tU8 udpQueueState;
      sockaddr_in remoteAddr;
   } tUDPQueue;
   tUDPQueue arUDPQueue[DOIP_CFG_MaxUDPQueueSize];
   tU8 queueIdx;

   DoIP_Utils mUtils;


   void pUpdateLocalIPAddress();
   static void* pvUDPClientThread(void* pvParent);
   static void* pvUDPBroadcastClientThread(void* pvParent);
   static void* pvUDPClient2Thread(void* pvParent);
   static void* pvUDPBroadcastClient2Thread(void* pvParent);
   bool bReadNextFrameUDP(int socket);
   void vHandleMessages();
   void vSendMessage(tU8 queueIdx);
};

#endif
