/*
 * DoIP_Node.h
 *
 *  Created on: Aug 14, 2018
 *      Author: sdn2hi
 */

#ifndef DOIP_NODE_H_
#define DOIP_NODE_H_

#include "DoIP_ClientCfg.h"
#include "DoIP_Utils.h"
#include "doipcommon/DoIP_RoutingActivation.h"


#include <list>
#include <map>

#include <vector>
#include <string>
#include <stdio.h>
#include <sys/socket.h>
#include <unistd.h>
#include <sys/types.h>
#include <netdb.h>
#include <pthread.h>


struct DoIP_ClientRXConnectionStatemachine: public DoIP_TCPConnectionStatemachine
{
   DoIP_ClientRXConnectionStatemachine():
      nextReadLen(0),
      payloadCounter(0),
      recvBufferUsed(0),
      diagMsgTargetAddress(0),
      diagMsgSourceAddress(0),
      cnt(0)
  {}

   tU8     ackBuffer[DOIP_CFG_cu32TCPBufferSize]; // for receiving TCP frames
   tU8     curDoipHeader[DOIP_HEADER_SIZE]; // for receiving TCP frames
   uint32_t nextReadLen;

   tU32 payloadCounter; /* number of payload bytes in payloadBuffer */
   tU8  payloadBuffer[DOIP_CFG_cu32TCPMaxRequestSize + DOIP_PAYLOAD_LENGTH_DIAG_MSG_MIN]; // for completely assembled payload (out of multiple TCP frames)

   uint8_t recvBuffer[DOIP_CFG_cu32TCPBufferSize];
   uint32_t recvBufferUsed; // number of bytes in recvBuffer

   tU16 diagMsgTargetAddress;
   tU16 diagMsgSourceAddress;

   tU32 cnt;

   void reset() {
      state=DOIP_TCP_IDLE;
      payloadLength=0;
      payloadType=0;
      nextReadLen=0;
      payloadCounter=0;
      recvBufferUsed=0;
      diagMsgTargetAddress=0;
      diagMsgSourceAddress=0;
   }

};


class DoIP_Node 
{
	DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(DoIP_Node);
 
public:
   DoIP_Node(tU16 testerAddress, sockaddr_in IP, tU16 logAddr, tU32 maxDataSize, DoIP_Cfg &doipCfg);
   DoIP_Node(tU16 testerAddress, sockaddr_in IP, tU16 logAddr, const tU8* EID, const tU8* GID, const tU8* VIN, DoIP_NodeType nodeType, tU32 maxDataSize, DoIP_Cfg &doipCfg);
   virtual ~DoIP_Node();

   void powermodeRequest(int sockfd);
   
   void entityStatusReq(int sockfd);
   void entityStatusResp (const tU8 au8UdpBuffer[], sockaddr_in& remoteaddr);
   bool routingActivationReq(tU8 actNum, tU8 oem[4]);
   bool diagnosticReq(std::vector<uint8_t> const  &data) {
      return diagnosticReq(&data[0], (uint32_t)data.size());
   }
   bool diagnosticReq(uint8_t const* au8Data, uint32_t u32Len);
   bool diagnosticReq(uint16_t tgtAddr, uint8_t const * au8Data, uint32_t u32Len);
   
   virtual void powermodeResp(const tU8 pwrMode, sockaddr_in& remoteaddr);
   virtual void activationResp(tU8 respCode);
   virtual void diagnosticResp(tU8 const * data, tU32 U32len);
   virtual void diagnosticACK(tU8 ackCode, tU8* data = NULL, tU32 U32len = 0);
   virtual void diagnosticNACK(tU8 nackCode, tU8* data = NULL, tU32 U32len = 0);
   
   bool aliveCheckResp(tU16 SrcAddr = 0);

   const tU8* getEID();
   const tU8* getGID();
   
   bool createTCPSocket();
   bool connectTCP(void);
   bool closeTCPSocket();

   void vTraceStackDump(void);

   
   const tU32 getIPAddr() { return IPv4.sin_addr.s_addr; }
   
   const sockaddr_in getIP() { return IPv4; }

   const int getTCPClientSocket() { return iSocket_TCP_Client; }
   
   tU8 getPowerMode() { return powerMode; }

   tU16 testerAddr;
   tU16 logicalAddr;


   DoIP_NodeType nodeType;
   tU32 mds;
   
   //! set up callback to the parent
	struct IDoIPCallback
	{
		public:
			//! on routing activation response
			virtual void onRoutingActivationResponse(tU8 respCode) = 0;
			//! on power mode response
			virtual void onPowerModeRequestResponse(tU8 pwrMode) = 0;
         //
         virtual void onNodeDiagnosticResponse(tU8 const * data, tU32 U32len) = 0;
		
		protected:
			//! destructor
			virtual ~IDoIPCallback() {}
	};
	
	virtual void setDoIPCallback(IDoIPCallback* cbk) { mpDoIPCallback = cbk; }
	
protected:
	//! callback handle
	IDoIPCallback* mpDoIPCallback;

protected:
   bool bReadNextFrameTCP(void);
   void vHandleRxDoipHeader();
   void vHandleRxPayload();
   bool bHandleRxMsgComplete();
   bool bCheckPayloadLength();

   bool bHandleRoutingActivationResponse();
   bool bHandleRxAliveCheckRequest();
   bool bHandleRxDiagMsg();
   bool bHandleRxDiagMsgAck();
   bool bHandleRxDiagMsgNack();


   int iSocket_TCP_Client;
   struct sockaddr_in   IPv4;
   tU8 acVIN[17];
   tU8 acEID[6];
   tU8 acGID[6];
   tU8 powerMode;
   tU8 actType;
   tU8 mcts;
   tU8 ncts;

   // TCP
   tU8 state;

   tU32 timerInactivity;
 //  DoIP_AliveCheck aliveCheck;
   DoIP_RoutingActivation routingActivation;
   DoIP_ClientRXConnectionStatemachine RX;

   tU8 buffer[DOIP_CFG_cu32TCPBufferSize];
private:
   static void* pvTCPClientThread(void* poPar);
   ssize_t readNBytes(int fd, uint8_t *buffer, uint32_t numBytesRequested);
   bool sendTcp(uint8_t *buffer, uint32_t numBytes);

   pthread_t rTCPClientThread; /* Thread to handle the Ethernet server*/
   DoIP_Cfg &mDoipCfg;
   DoIP_Utils mUtils;
};

#endif /* DOIP_NODE_H_ */
