//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_notification_plugin.cpp
// PROJECT:      RN A-IVI
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog ReportMemory creator class
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 11.10.12  | BSOT Plischke                 | Initial version
//////////////////////////////////////////////////////////////////////////

// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_notification_plugin
   #include "vd_diaglog_notification_plugin.h"
#endif 

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main
   #include <common/framework/vd_diaglog_main.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_service
   #include <project/interfaces/vd_diaglog_service.h>
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_notification_plugin.cpp.trc.h"
#endif


vdl_tclNotificationPlugin::vdl_tclNotificationPlugin()
{
}

//------------------------------------------------------------------------------

vdl_tclNotificationPlugin::~vdl_tclNotificationPlugin()
{
}

//------------------------------------------------------------------------------

void vdl_tclNotificationPlugin::vClearByMask(vdl_tsDiaglogPlugInReport reportRecord)
{
   ETG_TRACE_COMP_THR(("--- vdl_tclNotificationPlugin::vClearByMask"));

   // update CCA
   if(  ((vdDiagLog_tclApp::m_poInstance) != NULL)
      &&((vdDiagLog_tclApp::m_poInstance)->m_poService != NULL))
   {
      (vdDiagLog_tclApp::m_poInstance)->m_poService->vSendDtcStatusChanged(reportRecord.u8MemoryId, reportRecord.u32DTC);
   }
   else
   {
      ETG_TRACE_ERR_THR(( "!!! vdl_tclMemoryMaster::vClearByMask => Can't send to CCA components"));
   }
}

//------------------------------------------------------------------------------

void vdl_tclNotificationPlugin::vFailQualified(vdl_tsDiaglogPlugInReport reportRecord)
{
   ETG_TRACE_COMP_THR(("--- vdl_tclNotificationPlugin::vFailQualified"));

   // update CCA
   if(  ((vdDiagLog_tclApp::m_poInstance) != NULL)
      &&((vdDiagLog_tclApp::m_poInstance)->m_poService != NULL))
   {
      (vdDiagLog_tclApp::m_poInstance)->m_poService->vSendDtcStatusChanged(reportRecord.u8MemoryId, reportRecord.u32DTC);
   }
   else
   {
      ETG_TRACE_ERR_THR(( "!!! vdl_tclMemoryMaster::vFailQualified => Can't send to CCA components"));
   }
}

//------------------------------------------------------------------------------
void vdl_tclNotificationPlugin::vPassQualified(vdl_tsDiaglogPlugInReport reportRecord)
{
   ETG_TRACE_COMP_THR(("--- vdl_tclNotificationPlugin::vPassQualified"));

   // update CCA
   if(  ((vdDiagLog_tclApp::m_poInstance) != NULL)
      &&((vdDiagLog_tclApp::m_poInstance)->m_poService != NULL))
   {
      (vdDiagLog_tclApp::m_poInstance)->m_poService->vSendDtcStatusChanged(reportRecord.u8MemoryId, reportRecord.u32DTC);
   }
   else
   {
      ETG_TRACE_ERR_THR(( "!!! vdl_tclMemoryMaster::vPassQualified => Can't send to CCA components"));
   }
}

//------------------------------------------------------------------------------
