#ifndef VD_DIAGLOG_CMCDM1MANAGER_H
#define VD_DIAGLOG_CMCDM1MANAGER_H

#define SYSTEM_S_IMPORT_INTERFACE_LIST
#define SYSTEM_S_IMPORT_INTERFACE_MAP
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define SYSTEM_S_IMPORT_INTERFACE_COMPLETE


#include "stl_pif.h"
#include "osal_if.h"
#include "system_pif.h"



#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_plugin_if
#include <common/plugin/vd_diaglog_plugin_if.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_object
#include <common/framework/vd_diaglog_object.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_storage_interface
#include <common/framework/vd_diaglog_storage_interface.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main
#include "common/framework/vd_diaglog_main.h"
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_can_if
#include "vd_diaglog_can_if.h"
#endif

#include <unistd.h>
#include <pthread.h>

#include <string>
#define VD_DIAGLOG_CMC_DM1_MANAGER_PERIODMTX_NAME   ((std::string)"mtxPeriodState")
#define VD_DIAGLOG_CMC_DM1_MANAGER_DM1CONFIGMTX_NAME   ((std::string)"mtxDm1ConfigState")

/*  #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_CMCDm1Manager.h.trc.h"
#endif  */

class vdl_tclReportRecord;
class vdDiagLog_tclApp;
class vd_diaglog_CMCDm1Manager
: public vdl_tclPluginBaseClass

  {

public:
	vd_diaglog_CMCDm1Manager();
	~vd_diaglog_CMCDm1Manager();

	void vHandleDtcActive(const tU8 u8DtcHighByte,
			const tU8 u8DtcMiddleByte,
			const tU8 u8DtcLowByte,
			const tU8 u8Severity,
			const tU8 u8OccCnt);

	void vHandleDtcInactive(const tU8 u8DtcHighByte,
			const tU8 u8DtcMiddleByte,
			const tU8 u8DtcLowByte);

	void vOnDm1TimerExpired();
	static void SetDm1Configuration(tU8 u8Dm1Config);
	virtual tVoid vOnInit();
	virtual bool bLoad(tStream& roData);// base class overload
	virtual tVoid vFailQualified(vdl_tclReportRecord* const pReportRecord); // base class overload
	virtual tVoid vPassQualified(vdl_tclReportRecord* const pReportRecord); //base class overload
	void startDm1MsgTimer();
	void stopDm1MsgTimer();
private:
	bool bDM1_Update;

	enum{
		DM1_PERIOD_LEN_MS = 1000,
		DM1_MSG_LEN = 8,
		DM1_BYTE1_DEFAULT = 0x00,
		DM1_BYTE2_DEFAULT = 0xFF,
		DM1_BYTE3_DEFAULT = 0x00,
		DM1_BYTE4_DEFAULT = 0x00,
		DM1_BYTE5_DEFAULT = 0x00,
		DM1_BYTE6_DEFAULT = 0x00,
		DM1_BYTE7_DEFAULT = 0xFF,
		DM1_BYTE8_DEFAULT = 0xFF,
		DM1_CONFIG_TX_DEFAULT = 0x01,
		DM1_CONFIG_TX_ALWAYS = 0x00,
	};

	struct tstDtc{
		tU8 u8HighByte;
		tU8 u8MiddleByte;
		tU8 u8LowByte;
	};

	struct tstDtcData{
		struct tstDtc stDtc;
		tU8 u8Severity;
		tU8 u8OccCnt;
	};

	class Dm1DtcCmp
	{
	public:
		inline bool operator()(struct tstDtc const & lhs,
				struct tstDtc const & rhs) const {
			return ( (!(lhs.u8HighByte > rhs.u8HighByte)) &&
					(!((lhs.u8HighByte == rhs.u8HighByte) &&
							(lhs.u8MiddleByte >
			rhs.u8MiddleByte))) &&
			(!((lhs.u8HighByte == rhs.u8HighByte) &&
					(lhs.u8MiddleByte ==
							rhs.u8MiddleByte) &&
							(lhs.u8LowByte >= rhs.u8LowByte))) );
		};
	};

	std::list<struct tstDtcData> tDtcDataList;

	template<class T>
	class Dm1DtcEventContainer{
	public:
		tBool bContains(struct tstDtc const & cstDtc) const
		{
			return ( this->oDtcMap.find(cstDtc) !=
					this->oDtcMap.end() );
		}

		tBool bIsEmpty() const
		{
			return (this->oDtcMap.empty());
		}


		void vAdd(struct tstDtc const & cstDtc, T const & croElem){
			this->oDtcMap.insert(std::make_pair(cstDtc, croElem));
		}

		tBool bTstAndRemove(struct tstDtc const & cstDtc,
				T & roVal)
		{
			typename tDtcMap::iterator itDtcMapPos;
			tBool bRetVal;

			bRetVal = FALSE;
			itDtcMapPos = this->oDtcMap.find(cstDtc);
			if ( itDtcMapPos != this->oDtcMap.end() ){
				/* element found, assign value to reference argument */
				roVal = (*itDtcMapPos).second;
				this->oDtcMap.erase(itDtcMapPos);
				bRetVal = TRUE;
			}
			return bRetVal;
		}

		tBool bGet(struct tstDtc const & cstDtc,
				T & roVal) const
		{
			typename tDtcMap::const_iterator itDtcMapPos;
			tBool bRetVal;

			bRetVal = FALSE;
			itDtcMapPos = this->oDtcMap.find(cstDtc);
			if ( itDtcMapPos != this->oDtcMap.end() ){
				/* element found, assign value to reference */
				roVal = (*itDtcMapPos).second;
				bRetVal = TRUE;
			}
			return bRetVal;
		}

	protected:
		typedef std::map<struct tstDtc, T, Dm1DtcCmp> tDtcMap;

		tDtcMap oDtcMap;
	};


	class Dm1DtcActiveHandler
	{
	public:
		tBool bIsEmpty() const
		{
			return this->oEvCont.bIsEmpty();
		}


		tBool bContains(struct tstDtc const & cstDtc) const
		{
			return this->oEvCont.bContains(cstDtc);
		}

		tBool bIsAtTop(struct tstDtc const & cstDtc) const
		{
			tDtcSevMap::iterator itSevMap;
			tBool bRetVal;

			bRetVal = FALSE;
			if ( this->oEvCont.bGet(cstDtc, itSevMap) ){
				/* get pointer to dtc data stored in severity map
				 * element value */
				bRetVal = (itSevMap == this->oSevMap.begin());
			}
			return bRetVal;
		}

		tBool bGetTopDtcData(struct tstDtcData & stDtcData) const
		{
			tBool bRetVal;

			bRetVal = FALSE;
			if ( !this->oSevMap.empty() ){
				stDtcData = this->oSevMap.begin()->second;
				bRetVal = TRUE;
			}
			return bRetVal;
		}

		void vUpdateDtcData(struct tstDtcData const & crstDtcData)
		{

			//ETG_TRACE_COMP_THR(("--- Dm1DtcActiveHandler::vUpdateDtcData => DTC = %02x %02x %02x",crstDtcData.stDtc.u8HighByte << 16,crstDtcData.stDtc.u8MiddleByte << 8,crstDtcData.stDtc.u8LowByte));
			tDtcSevMap::iterator itSevMap;
			if ( this->oEvCont.bGet(crstDtcData.stDtc, itSevMap) ){
				/* get pointer to dtc data stored in severity map
				 * element value */
				(*itSevMap).second = crstDtcData;
			}
		}

		void vSetActive(struct tstDtcData const & crstDtcData)
		{

			//ETG_TRACE_COMP_THR(("--- Dm1DtcActiveHandler::vSetActive => DTC = %02x %02x %02x",crstDtcData.stDtc.u8HighByte << 16,crstDtcData.stDtc.u8MiddleByte << 8,crstDtcData.stDtc.u8LowByte));
			/* insert into severity map first */
			tDtcSevMap::iterator oSevIter = oSevMap.insert(
					std::make_pair(crstDtcData.u8Severity,
							crstDtcData));
			/* insert iterator in returned pair into container */
			this->oEvCont.vAdd(crstDtcData.stDtc, oSevIter);
		}

		tBool bTstAndRemoveActive(struct tstDtc const & crstDtc)
		{
			tDtcSevMap::iterator itDtcSev;
			tBool bRetVal;

			bRetVal = FALSE;
			if ( this->oEvCont.bTstAndRemove(crstDtc, itDtcSev) ){

				//ETG_TRACE_COMP_THR(("--- Dm1DtcActiveHandler::bTstAndRemoveActive => DTC = %02x %02x %02x",crstDtc.u8HighByte << 16,crstDtc.u8MiddleByte << 8,crstDtc.u8LowByte));
				/* get pointer to dtc data stored in severity map
				 * element value */
				oSevMap.erase(itDtcSev);
				bRetVal = TRUE;
			}
			return bRetVal;
		}

	private:
		class Dm1SeverityCmp
		{
		public:
			inline bool operator()(tU8 const & lhs,
					tU8 const & rhs) const {
				return ( lhs > rhs );
			}
		};

		typedef std::multimap<tU8, struct tstDtcData, Dm1SeverityCmp>
		tDtcSevMap;

		Dm1DtcEventContainer<tDtcSevMap::iterator> oEvCont;
		tDtcSevMap oSevMap;
	};


	class Dm1PeriodHandler
	{
	public:
		void vClear()
		{
			this->oDtcTimeMap.clear();
		}

		tBool bHasDtcRecentlySendDm1(struct tstDtc const & stDtc)
		{
			tBool bRetVal;

			bRetVal = FALSE;
			if ( !this->oDtcTimeMap.empty() ){
				bRetVal = (this->oDtcTimeMap.find(stDtc) !=
						this->oDtcTimeMap.end() );
			}
			return bRetVal;

		}

		void vMarkDtcRecentlySendDm1(struct tstDtc const & crstDtc,
				OSAL_tMSecond const & croTimerCurrTimeMs)
		{

			//ETG_TRACE_COMP_THR(("--- Dm1PeriodHandler::vMarkDtcRecentlySendDm1 => DTC = %02x %02x %02x",crstDtc.u8HighByte << 16,crstDtc.u8MiddleByte << 8,crstDtc.u8LowByte));
			this->oDtcTimeMap.insert(std::make_pair(crstDtc,
					croTimerCurrTimeMs));
		}

		void vUpdateRecentlySent(
				OSAL_tMSecond const & croTimerCurrTimeMs)
		{
			if ( !this->oDtcTimeMap.empty() ){
				/* remove all entries which are older than
				 * DM1_PERIOD_LEN_MS. linear search only, but it is
				 * expected there are only a few entries send a DM1
				 * in a period */
				tDtcTimeMap::iterator itElemPos =
						this->oDtcTimeMap.begin();
				while ( itElemPos != this->oDtcTimeMap.end() ){
					if ( ((*itElemPos).second + DM1_PERIOD_LEN_MS) <=
							croTimerCurrTimeMs ){

						//ETG_TRACE_COMP_THR(("--- Dm1PeriodHandler::vUpdateRecentlySent => DTC = %02x %02x %02x",(*itElemPos).first.u8HighByte << 16,(*itElemPos).first.u8MiddleByte << 8,(*itElemPos).first.u8LowByte));
						this->oDtcTimeMap.erase(itElemPos++);
					}
					else{
						itElemPos++;
					}
				}
			}
		}

		void vSetCurrentPeriodEnd(
				OSAL_tMSecond const & croDm1PeriodEndMs){

			//ETG_TRACE_COMP_THR(("--- Dm1PeriodHandler::vSetCurrentPeriodEnd => Time Period = %d",croDm1PeriodEndMs));
			this->oDm1CurrentPeriodEndMs = croDm1PeriodEndMs;
		}

		OSAL_tMSecond oGetCurrentPeriodEnd(){
			return this->oDm1CurrentPeriodEndMs;
		}

	private:
		typedef std::map<struct tstDtc, OSAL_tMSecond, Dm1DtcCmp>
		tDtcTimeMap;

		tDtcTimeMap oDtcTimeMap;
		OSAL_tMSecond oDm1CurrentPeriodEndMs = 0;
	};

	class Dm1LastInactiveHandler
	{
	public:
		Dm1LastInactiveHandler() : bEmpty(TRUE)
		{};

		tBool bContainsLastInactiveDtc() const
		{
			return (!this->bEmpty);
		}

		struct tstDtc const cstGetLastInactiveDtc() const
		{
			NORMAL_M_ASSERT(!this->bEmpty);
			return this->stLastInactiveDtc;
		}

		void vSetLastInactiveDtc(
				struct tstDtc const & crstLastInactiveDtc){

			//ETG_TRACE_COMP_THR(("--- Dm1LastInactiveHandler::vSetLastInactiveDtc => DTC = %02x %02x %02x",crstLastInactiveDtc.u8HighByte << 16,crstLastInactiveDtc.u8MiddleByte << 8,crstLastInactiveDtc.u8LowByte));
			this->stLastInactiveDtc = crstLastInactiveDtc;
			this->bEmpty = FALSE;
		}

		void vClearLastInactiveDtc(){

			//ETG_TRACE_COMP_THR(("--- Dm1LastInactiveHandler::vClearLastInactiveDtc"));
			this->bEmpty = TRUE;
		}

	private:
		tBool bEmpty;
		struct tstDtc stLastInactiveDtc = {0};
	};

	//static tU8 u8GetDm1ConfigurationKds();
	//static tU8 u8GetDm1Configuration();
	void vSendDm1(struct tstDtcData const & stDtcData,
			OSAL_tMSecond const & croTimerCurrTimeMs);
	void vSendLastDm1(OSAL_tMSecond const & croTimerCurrTimeMs);
	void vSendBeaconDm1(OSAL_tMSecond const & croTimerCurrTimeMs);
	void vSendDm1(struct tstDtc const & stDtc,
			tU8 const u8LampState,
			tU8 const u8LampStateIm,
			tU8 const u8OccCnt);
public:
	OSAL_tMSecond oGetCurrentTimerTotalMs()
	{
		/*
		 * There seems to be an error in the 'OSAL Reference Manual'. It
		 * describes the usage of parameters in the method
		 * 'OSAL_s32TimerGetTime' as follows:
		 *
		 * "If in the second and third parameter OSAL_NULL is transferred,
		 * then the remaining time and the repetition interval is not
		 * returned."
		 *
		 * After several iterations of looking for the error, it seems that
		 * if only the third parameter is OSAL_NULL, the second parameter is
		 * not returned as well.
		 */
		/*
		 * There seems to be an additional error. In Debug build, this call
		 * returns ok, but remaining seconds of an already expired timer is
		 * returned with 1 .
		 */
		OSAL_tMSecond oTimerCurrTimeMs = 0;
		OSAL_tMSecond oTimerIntervMsec = 0;

		/* get current time of timer */
		NORMAL_M_ASSERT(OSAL_s32TimerGetTime(this->hDm1Timer, &oTimerCurrTimeMs,
				&oTimerIntervMsec)== OSAL_OK);

		/* update time timer ran total */
		return (this->oDm1TimerTotalMs +
				(this->oDm1TimerPeriodMs - oTimerCurrTimeMs));
	}

public:
	OSAL_tMSecond oDm1TimerTotalMs;

private:
	OSAL_tMSecond oDm1TimerPeriodMs;
	OSAL_tTimerHandle hDm1Timer = OSAL_C_INVALID_HANDLE;

	Dm1DtcActiveHandler oDtcActvHandler;
	Dm1PeriodHandler oPeriodHandler;
	Dm1LastInactiveHandler oLastInactvHandler;
	


protected:

	pthread_mutexattr_t  mAttr;
	pthread_mutex_t      mMutex;
  };
#endif // VD_DIAGLOG_CMCDM1MANAGER_H
