#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define SYSTEM_S_IMPORT_INTERFACE_COMPLETE

// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

//#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_asf_vehicleClient
    #include "project/framework/asf/vd_asf_VehicleClient.h"
//#endif

#ifndef VD_DIAGLOG_CMCDM1MANAGER_H
#include "vd_diaglog_CMCDm1Manager.h"
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_memory
#include "common/framework/vd_diaglog_report_memory.h"
#endif

#include <pthread.h>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_CMCDm1Manager.cpp.trc.h"
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_VD_DIAGLOG_CANSIGNALDM1
#include "../can_if/vd_diaglog_CanSignalDM1.h"
#endif

#include "osal_if.h"
#include "system_pif.h"

#define DM1_MSG_SIZE 8

vd_diaglog_CMCDm1Manager* poCmcDm1ManagerInstance;

/*OSAL_tMtxHandle vd_diaglog_CMCDm1Manager::mtxDm1Config = 0;
tU8 vd_diaglog_CMCDm1Manager::u8Dm1Configuration = vd_diaglog_CMCDm1Manager::DM1_CONFIG_TX_DEFAULT;*/


/*tU8 vd_diaglog_CMCDm1Manager::u8GetDm1ConfigurationKds(){
	tU8 u8Dm1Config = DM1_CONFIG_TX_DEFAULT;
	OSAL_tIODescriptor kds_handle;
	kds_handle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS, OSAL_EN_READWRITE);
	if (kds_handle != OSAL_ERROR){
		tsKDSEntry rEntryInfo;
		//DM1 configuration KDS entry is stored at 0x0D04
		rEntryInfo.u16Entry = 0x0D04;
		rEntryInfo.u16EntryLength = sizeof(u8Dm1Config);

		if (OSAL_s32IORead(kds_handle, (tS8 *)&rEntryInfo, (tS32)sizeof(rEntryInfo)) != OSAL_ERROR){
			only one byte has been read from kds
			u8Dm1Config = rEntryInfo.au8EntryData[0];

					ETG_TRACE_COMP_THR(("vd_diaglog_CMCDm1Manager::u8GetDm1Configuration, read dm1 config from kds: %d",u8Dm1Config));	

		}
		else{

					ETG_TRACE_COMP_THR(("d_diaglog_TCCDm1Manager::u8GetDm1Configuration, read dm1 config from kds failed"));	
		}
	}
	OSAL_s32IOClose(kds_handle);
	return u8Dm1Config;
}*/

/*tU8 vd_diaglog_CMCDm1Manager::u8GetDm1Configuration(){
	tU8 retVal;
	if(poCmcDm1ManagerInstance){

		//NORMAL_M_ASSERT(OSAL_s32MutexLock(vd_diaglog_CMCDm1Manager::mtxDm1Config, OSAL_C_TIMEOUT_FOREVER) == OSAL_OK);
		retVal = vd_diaglog_CMCDm1Manager::u8Dm1Configuration;
		//NORMAL_M_ASSERT(OSAL_s32MutexUnLock(vd_diaglog_CMCDm1Manager::mtxDm1Config) == OSAL_OK);
	}
	else{

		ETG_TRACE_COMP_THR(("vd_diaglog_CMCDm1Manager::u8GetDm1Configuration, DM1 manager not yet ready. Returning default"));		
		retVal = DM1_CONFIG_TX_DEFAULT;
	}

	return retVal;
}*/

/*void vd_diaglog_CMCDm1Manager::SetDm1Configuration(tU8 u8Dm1Config){
	if(poCmcDm1ManagerInstance){

		dia::LockScope lock(mSyncObjmtxDm1Config);
		//NORMAL_M_ASSERT(OSAL_s32MutexLock(vd_diaglog_CMCDm1Manager::mtxDm1Config, OSAL_C_TIMEOUT_FOREVER) == OSAL_OK);

		ETG_TRACE_COMP_THR(("vd_diaglog_CMCDm1Manager::SetDm1Configuration, setting DM1 configuration: %d",u8Dm1Config));			
		vd_diaglog_CMCDm1Manager::u8Dm1Configuration = u8Dm1Config;
		//NORMAL_M_ASSERT(OSAL_s32MutexUnLock(vd_diaglog_CMCDm1Manager::mtxDm1Config) == OSAL_OK);
	}
	else{

		ETG_TRACE_COMP_THR(("vd_diaglog_CMCDm1Manager::SetDm1Configuration, DM1 manager not yet ready"));
	}
}*/

void vd_diaglog_CMCDm1ManagerTimerWrapper(){
	poCmcDm1ManagerInstance->vOnDm1TimerExpired();
}

tVoid vd_diaglog_CMCDm1Manager::vOnInit()
{
	ETG_TRACE_COMP_THR(( "--> vd_diaglog_CMCDm1Manager::vOnInit"));



	ETG_TRACE_COMP_THR(( "<-- vd_diaglog_CMCDm1Manager::vOnInit"));
}
bool vd_diaglog_CMCDm1Manager::bLoad(tStream& roData)
{
	ETG_TRACE_COMP_THR(( "--> vd_diaglog_CMCDm1Manager::bLoad"));
	bool bReturn = true;


	ETG_TRACE_COMP_THR(( "<-- vd_diaglog_CMCDm1Manager::bLoad"));
	return bReturn;
}
tVoid vd_diaglog_CMCDm1Manager::vPassQualified(vdl_tclReportRecord* const pReportRecord)
{
	ETG_TRACE_COMP_THR(( "--> vd_diaglog_CMCDm1Manager::vPassQualified"));
	if(pReportRecord != NULL)
	{
		tU32 u32DTC = pReportRecord->u32DTC();
		tU8  u8MemoryId = pReportRecord->u8GetMemoryId();
		ETG_TRACE_COMP_THR(( "--- vd_diaglog_CMCDm1Manager::vPassQualified => DTC:%06x",u32DTC));
		if((u8MemoryId == DIAGLOG_MEMORY_CUSTOMER))
		{
			poCmcDm1ManagerInstance->vHandleDtcInactive((u32DTC >> 16) & 0xFF,(u32DTC >> 8) & 0xFF,u32DTC & 0xFF);
		}
	}
	ETG_TRACE_COMP_THR(( "<-- vd_diaglog_CMCDm1Manager::vPassQualified"));
}

tVoid vd_diaglog_CMCDm1Manager::vFailQualified(vdl_tclReportRecord* const pReportRecord)
{
	ETG_TRACE_COMP_THR(( "--> vd_diaglog_CMCDm1Manager::vFailQualified"));
	if(pReportRecord != NULL)
	{
		tU32 u32DTC = pReportRecord->u32DTC();
		tU8  u8MemoryId = pReportRecord->u8GetMemoryId();
		ETG_TRACE_COMP_THR(( "--- vd_diaglog_CMCDm1Manager::vFailQualified => DTC:%06x",u32DTC));
		if((u8MemoryId == DIAGLOG_MEMORY_CUSTOMER))
		{
			poCmcDm1ManagerInstance->vHandleDtcActive((u32DTC >> 16) & 0xFF,
					(u32DTC >> 8) & 0xFF,
					u32DTC & 0xFF,
					pReportRecord->u8GetSeverity(),
					pReportRecord->u8GetFailOccurenceCounter());
		}
	}

	ETG_TRACE_COMP_THR(( "<-- vd_diaglog_CMCDm1Manager::vFailQualified"));
}
vd_diaglog_CMCDm1Manager::vd_diaglog_CMCDm1Manager() :
						oDm1TimerTotalMs(0), oDm1TimerPeriodMs(DM1_PERIOD_LEN_MS),
						bDM1_Update(0)
{
	ETG_TRACE_USR1_THR(( "--> vd_diaglog_CMCDm1Manager::vd_diaglog_CMCDm1Manager"));
	tPVoid pvArg = OSAL_NULL;
	::poCmcDm1ManagerInstance = this;
	/* create mutex for mutual exclusion between DTC activation/deactivation
	 * threads and local timer thread */

	int ret = pthread_mutexattr_init(&mAttr);
	if (0 != ret) ETG_TRACE_COMP_THR(("dia::Lock::Lock ERROR pthread_mutexattr_init returned %d.", ret));
	NORMAL_M_ASSERT(0 == ret);
	ret = pthread_mutexattr_settype(&mAttr, PTHREAD_MUTEX_RECURSIVE);
	if (0 != ret) ETG_TRACE_COMP_THR(("dia::Lock::Lock ERROR pthread_mutexattr_settype returned %d.", ret));
	NORMAL_M_ASSERT(0 == ret);
	ret = pthread_mutex_init(&mMutex, &mAttr);
	if (0 != ret) ETG_TRACE_COMP_THR(("dia::Lock::Lock ERROR pthread_mutex_init returned %d.", ret));
	NORMAL_M_ASSERT(0 == ret);

	/* remember designated first period end */
	oPeriodHandler.vSetCurrentPeriodEnd(this->oDm1TimerTotalMs
			+ this->oDm1TimerPeriodMs);
	//vd_diaglog_TCCDm1Manager::SetDm1Configuration(vd_diaglog_TCCDm1Manager::u8GetDm1ConfigurationKds());
	/* create timer */
	NORMAL_M_ASSERT(OSAL_s32TimerCreate( (OSAL_tpfCallback)&vd_diaglog_CMCDm1ManagerTimerWrapper, pvArg, &this->hDm1Timer) == OSAL_OK);
	//NORMAL_M_ASSERT(OSAL_s32TimerSetTime(this->hDm1Timer, this->oDm1TimerPeriodMs, 0) == OSAL_OK);
	ETG_TRACE_USR1_THR(( "<-- vd_diaglog_TCCDm1Manager::vd_diaglog_TCCDm1Manager"));

}

vd_diaglog_CMCDm1Manager::~vd_diaglog_CMCDm1Manager()
{
	/* release timer resources */
	//OSAL_s32TimerDelete(this->hDm1Timer);
	/* release mutex ressources */

	NORMAL_M_ASSERT(0 == pthread_mutex_destroy(&mMutex));
	NORMAL_M_ASSERT(0 == pthread_mutexattr_destroy(&mAttr));
}

void vd_diaglog_CMCDm1Manager::vHandleDtcActive(const tU8 u8DtcHighByte,
		const tU8 u8DtcMiddleByte,
		const tU8 u8DtcLowByte,
		const tU8 u8Severity,
		const tU8 u8OccCnt)
{
	ETG_TRACE_COMP_THR(( "--> vd_diaglog_CMCDm1Manager::vHandleDtcActive"));
	struct tstDtcData stDtcData = { { u8DtcHighByte, u8DtcMiddleByte,
			u8DtcLowByte }, u8Severity, u8OccCnt };
	/* lock access to local data */
	//NORMAL_M_ASSERT(OSAL_s32MutexLock(this->mtxPeriodState, OSAL_C_TIMEOUT_FOREVER) == OSAL_OK);
//	NORMAL_M_ASSERT(0 == pthread_mutex_trylock(&mMutex));
	if ( this->oDtcActvHandler.bContains(stDtcData.stDtc) ){
		/* update data */

		ETG_TRACE_COMP_THR(("vd_diaglog_CMCDm1Manager::vHandleDtcActive => Updating active Active DTC= %02x %02x %02x",(stDtcData.stDtc.u8HighByte << 16),(stDtcData.stDtc.u8MiddleByte << 8),(stDtcData.stDtc.u8LowByte)));
		this->oDtcActvHandler.vUpdateDtcData(stDtcData);
	}
	else{
		/* new dtc */
		//if ( u8Severity > 0 ){

			ETG_TRACE_COMP_THR(("vd_diaglog_CMCDm1Manager::vHandleDtcActive => new active Active DTC= %02x %02x %02x",(stDtcData.stDtc.u8HighByte << 16),(stDtcData.stDtc.u8MiddleByte << 8),(stDtcData.stDtc.u8LowByte)));
			this->oDtcActvHandler.vSetActive(stDtcData);
			if ( this->oDtcActvHandler.bIsAtTop(stDtcData.stDtc) ){
				/* dtc is at current top. check, whether allowed to send dm1 message
				 * or not */
				/* update recently send dtc's to current time */
				this->oPeriodHandler.vUpdateRecentlySent(this->oGetCurrentTimerTotalMs());
				/* ask updated list for current dtc sent in last period */
				if ( !this->oPeriodHandler.bHasDtcRecentlySendDm1(stDtcData.stDtc) ){
					this->vSendDm1(stDtcData, this->oGetCurrentTimerTotalMs());
				}
			}
		//}
	}
	/* release access to local data */
//	int retVal = pthread_mutex_unlock(&mMutex); //lint !e455: Warning: A thread mutex that had not been locked is being unlocked
//	if (0 != retVal)
//	{
//		ETG_TRACE_ERR_THR(("### Lock::unlock pthread_mutex_unlock returned %d", retVal));
//	}
	ETG_TRACE_COMP_THR(( "<-- vd_diaglog_CMCDm1Manager::vHandleDtcActive"));
}

void vd_diaglog_CMCDm1Manager::vHandleDtcInactive(const tU8 u8DtcHighByte,
		const tU8 u8DtcMiddleByte,
		const tU8 u8DtcLowByte)
{
	ETG_TRACE_COMP_THR(( "--> vd_diaglog_CMCDm1Manager::vHandleDtcInactive"));
	struct tstDtc stDtc = { u8DtcHighByte, u8DtcMiddleByte, u8DtcLowByte };
	/* lock access to local data */
	/*NORMAL_M_ASSERT(OSAL_s32MutexLock(this->mtxPeriodState, OSAL_C_TIMEOUT_FOREVER) == OSAL_OK);*/
//	NORMAL_M_ASSERT(0 == pthread_mutex_trylock(&mMutex));
	/* test and check, whether this DTC is of any interest */
	if ( this->oDtcActvHandler.bTstAndRemoveActive(stDtc) ){

		ETG_TRACE_COMP_THR(("vd_diaglog_CMCDm1Manager::vHandleDtcActive => new inactive Active DTC= %02x %02x %02x",(stDtc.u8HighByte << 16),(stDtc.u8MiddleByte << 8),(stDtc.u8LowByte)));
		/* check, if last dm1 has to be send */
		if ( this->oDtcActvHandler.bIsEmpty() ){
			/* remember last dtc became inactive from inactive */
			this->oLastInactvHandler.vSetLastInactiveDtc(stDtc);
			/* update recently send dtc's to current time */
			this->oPeriodHandler.vUpdateRecentlySent(this->oGetCurrentTimerTotalMs());
			/* ask updated list for current dtc sent in last period */
			if ( !this->oPeriodHandler.bHasDtcRecentlySendDm1(stDtc) ){
				/* send last dm1.
				 * Timer callback will decide according to the DM1
				 * configuration if DM1 should be further sent or not */
				this->vSendLastDm1(this->oGetCurrentTimerTotalMs());
				/* last active dtc was handled, clear */
				this->oLastInactvHandler.vClearLastInactiveDtc();
			}
		}
	}
	/* else nothing to do */

	/* release access to local data */
//	int retVal = pthread_mutex_unlock(&mMutex); //lint !e455: Warning: A thread mutex that had not been locked is being unlocked
//	if (0 != retVal)
//	{
//		ETG_TRACE_ERR_THR(("### Lock::unlock pthread_mutex_unlock returned %d", retVal));
//	}
	ETG_TRACE_COMP_THR(( "<-- vd_diaglog_CMCDm1Manager::vHandleDtcInactive"));
}

void vd_diaglog_CMCDm1Manager::vOnDm1TimerExpired()
{
	/* lock access to local data */
	/*NORMAL_M_ASSERT(OSAL_s32MutexLock(this->mtxPeriodState, OSAL_C_TIMEOUT_FOREVER) == OSAL_OK);*/
	ETG_TRACE_COMP_THR(( "--> vd_diaglog_CMCDm1Manager::vOnDm1TimerExpired"));
	//NORMAL_M_ASSERT(0 == pthread_mutex_trylock(&mMutex)); // removed, its already seamaphore lock is used in vProcessReadDTCPriority
	// //Read Active DTCs
	if( bDM1_Update == FALSE ){
		tReadReportListDM1 DM1List;

		tS8 ret = -1;
		if(  ((vdDiagLog_tclApp::m_poInstance) != NULL) )
		{
			tS8 ret = vdDiagLog_tclApp::m_poInstance->m_oMemoryMaster.vProcessReadDTCPriority( DM1List );
		}
		else
		{
			ETG_TRACE_COMP_THR (("vd_diaglog_CMCDm1Manager::vOnDm1TimerExpired()->vdDiagLog_tclApp::m_poInstance = NULL"));
		}
		if( ret == 0x00 ){
			ETG_TRACE_COMP_THR(("List size %X ret %X",DM1List.size(),ret));
			for (tReadReportListDM1itr itr = DM1List.begin();
					itr != DM1List.end(); itr++ ){
				if(itr->u16Priority > 0){
					struct tstDtcData stDtcData = { { (itr->u32DTC >> 16 )& 0xFF, (itr->u32DTC >> 8 )& 0xFF,
							(itr->u32DTC  )& 0xFF }, itr->u16Priority, itr->u32OccuranceCount };
					this->oDtcActvHandler.vSetActive(stDtcData);
				}
			}
			bDM1_Update = TRUE;
		}
		else{
			//topas_api::Trace(TR_CLASS_VDDIAGLOG, TOPAS_LOG_ERR,"Err:Reading DTC");
			ETG_TRACE_COMP_THR(("vd_diaglog_CMCDm1Manager::vOnDm1TimerExpired=>Err:Reading DTC"));
		}
	}

	/* update time timer ran total */
	this->oDm1TimerTotalMs += this->oDm1TimerPeriodMs;

	/* Important note: the work is only done if at least one period is
	 * completed */
	if ( (this->oDm1TimerTotalMs - this->oPeriodHandler.oGetCurrentPeriodEnd())
			== 0 ){
		/* timer expired without any new triggers in between */
		/* cleanup all -now out-dated- entries */
		this->oPeriodHandler.vClear();
		/* check for active entry */
		if ( !this->oDtcActvHandler.bIsEmpty() ){
			struct tstDtcData stTopData;
			NORMAL_M_ASSERT(this->oDtcActvHandler.bGetTopDtcData(stTopData) == TRUE);
			/* send dm1 message */
			this->vSendDm1(stTopData, this->oDm1TimerTotalMs);
		}
		else{
			/* check whether last inactive already sent or not */
			if ( this->oLastInactvHandler.bContainsLastInactiveDtc() ){
				/* send last DM1 */
				this->vSendLastDm1(this->oDm1TimerTotalMs);
				/* clear last inactive dtc */
				this->oLastInactvHandler.vClearLastInactiveDtc();
			}
			else{
				/* configuration parameter for DM1
				 * 0x00 - Always send DM1 even when no DTC is active
				 * 0x01 - Default behaviour: send DM1 only once after the last active DTC
				 * 		  is now inactive
				 * Note: the name "vSendLastDm1" is misleading if the DM1 configuration
				 * is 0x00. code from gen1, so using here.*/
#if 0
				if(vd_diaglog_TCCDm1Manager::u8GetDm1Configuration() ==
						DM1_CONFIG_TX_ALWAYS){
					this->vSendBeaconDm1(this->oDm1TimerTotalMs);

					ETG_TRACE_COMP_THR(("Beacon DM1 is sent due to the configuration"));
				}
				else{
					//for all other cases use default behavior
					ETG_TRACE_COMP_THR(("Default DM1 Tx behavior. DM1 will not be sent"));
				}
#endif
			}

		}
		/* prepare timer for new run at full period time */
		this->oDm1TimerPeriodMs = DM1_PERIOD_LEN_MS;
		/* remember proposed period end */
		this->oPeriodHandler.vSetCurrentPeriodEnd(this->oDm1TimerTotalMs
				+ this->oDm1TimerPeriodMs);
	}
	else{
		/* current period end not reached. prepare timer for trigger at period
		 * end */
		this->oDm1TimerPeriodMs = this->oPeriodHandler.oGetCurrentPeriodEnd()
												- this->oDm1TimerTotalMs;
	}
	/* reset timer for new run */
	OSAL_s32TimerSetTime(this->hDm1Timer, this->oDm1TimerPeriodMs, 0);

	/* release access to local data */
	/* release access to local data */
//	int retVal = pthread_mutex_unlock(&mMutex); //lint !e455: Warning: A thread mutex that had not been locked is being unlocked
//	if (0 != retVal)
//	{
//		ETG_TRACE_ERR_THR(("### Lock::unlock pthread_mutex_unlock returned %d", retVal));
//	}
	ETG_TRACE_COMP_THR(( "<-- vd_diaglog_CMCDm1Manager::vOnDm1TimerExpired"));
}

void vd_diaglog_CMCDm1Manager::vSendDm1(struct tstDtcData const & stDtcData,
		OSAL_tMSecond const & croTimerCurrTimeMs)
{
	/* add dtc to current period container with time argument */
	this->oPeriodHandler.vMarkDtcRecentlySendDm1(stDtcData.stDtc,
			croTimerCurrTimeMs);
	/* send dm1 message */
	this->vSendDm1(stDtcData.stDtc,
			DM1_BYTE1_DEFAULT,
			DM1_BYTE2_DEFAULT,
			stDtcData.u8OccCnt);
	this->oPeriodHandler.vSetCurrentPeriodEnd(croTimerCurrTimeMs
			+ DM1_PERIOD_LEN_MS);
}

void vd_diaglog_CMCDm1Manager::vSendLastDm1(OSAL_tMSecond const & croTimerCurrTimeMs)
{
	ETG_TRACE_COMP_THR(( "--> vd_diaglog_CMCDm1Manager::vSendLastDm1()"));
	struct tstDtc stDtcDef = { DM1_BYTE3_DEFAULT, DM1_BYTE4_DEFAULT,
			DM1_BYTE5_DEFAULT, };
	/* add dtc to current period container with time argument */
	this->oPeriodHandler.vMarkDtcRecentlySendDm1(this->oLastInactvHandler.cstGetLastInactiveDtc(),
			croTimerCurrTimeMs);
	/* send dm1 message */
	this->vSendDm1(stDtcDef,
			DM1_BYTE1_DEFAULT,
			DM1_BYTE2_DEFAULT,
			DM1_BYTE6_DEFAULT);
	this->oPeriodHandler.vSetCurrentPeriodEnd(croTimerCurrTimeMs
			+ DM1_PERIOD_LEN_MS);
	ETG_TRACE_COMP_THR(( "<-- vd_diaglog_CMCDm1Manager::vSendLastDm1()"));
}

void vd_diaglog_CMCDm1Manager::vSendBeaconDm1(OSAL_tMSecond const & croTimerCurrTimeMs)
{
	ETG_TRACE_COMP_THR(( "--> vd_diaglog_CMCDm1Manager::vSendBeaconDm1()"));
	struct tstDtc stDtcDef = { DM1_BYTE3_DEFAULT, DM1_BYTE4_DEFAULT,
			DM1_BYTE5_DEFAULT, };
	// no remember of this DM1, 'cause there's no DTC available at the beginning
	// and only an out-dated one after at least one DTC was sent an DM1 for

	/* send dm1 message */
	this->vSendDm1(stDtcDef,
			DM1_BYTE1_DEFAULT,
			DM1_BYTE2_DEFAULT,
			DM1_BYTE6_DEFAULT);
	this->oPeriodHandler.vSetCurrentPeriodEnd(croTimerCurrTimeMs
			+ DM1_PERIOD_LEN_MS);
	ETG_TRACE_COMP_THR(( "<-- vd_diaglog_CMCDm1Manager::vSendBeaconDm1()"));
}

void vd_diaglog_CMCDm1Manager::vSendDm1(struct tstDtc const & stDtc,
		tU8 u8LampState,
		tU8 u8LampStateIm,
		tU8 u8OccCnt)
{
	ETG_TRACE_COMP_THR(( "--> vd_diaglog_CMCDm1Manager::vSendDm1()"));
	CanSignalDM1 dm1signal;
	struct VDD::tstDm1LampState stLampState;
	struct VDD::tstDm1LampState stLampStateIm;

	stLampState.bitMalfunctionIndicatorState = ((u8LampState >> 6) & 0x03);
	stLampState.bitRedStopState = ((u8LampState >> 4) & 0x03);
	stLampState.bitAmberWarningState = ((u8LampState >> 2) & 0x03);
	stLampState.bitProtectState = ((u8LampState >> 0) & 0x03);

	stLampStateIm.bitMalfunctionIndicatorState = ((u8LampStateIm >> 6) &
			0x03);
	stLampStateIm.bitRedStopState = ((u8LampStateIm >> 4) & 0x03);
	stLampStateIm.bitAmberWarningState = ((u8LampStateIm >> 2) & 0x03);
	stLampStateIm.bitProtectState = ((u8LampStateIm >> 0) & 0x03);

	VDD::dtc_can_dm1_frame DM1FrameBytes = dm1signal.populateDM1Content((stDtc.u8HighByte  & 0xFF),
			(stDtc.u8MiddleByte & 0xFF),
			(stDtc.u8LowByte & 0xFF),
			stLampState,stLampStateIm,u8OccCnt);
	tU8 DM1Frame[DM1_MSG_SIZE] = {0};
	(void) ::memset(DM1Frame,0,DM1_MSG_SIZE);
    dm1signal.vFrameDM1Message(DM1FrameBytes,DM1Frame);

	//if(vdl_tclCanIf::getInstanceOfCanIf()!= NULL)
    if(vd_asf_VehicleClientHandler::getInstance()!= NULL)
	{

		{
			//if(vdl_tclCanIf::getInstanceOfCanIf()->bTransmitDM1TriggerMsg(DM1Frame))

			if(vd_asf_VehicleClientHandler::getInstance()->vSendDM1DataMessage(DM1Frame))
			{
				ETG_TRACE_COMP_THR(("vd_diaglog_CMCDm1Manager::vSendDm1 => DM1 Message sent successfully"));
			}
			else
			{
				ETG_TRACE_COMP_THR(("vd_diaglog_CMCDm1Manager::vSendDm1 => DM1 Message send failed"));
			}
		}
	}

	ETG_TRACE_COMP_THR(( "<-- vd_diaglog_CMCDm1Manager::vSendDm1()"));
}

void 
vd_diaglog_CMCDm1Manager::startDm1MsgTimer()
{
	ETG_TRACE_COMP_THR(( "--> vd_diaglog_CMCDm1Manager::startDm1MsgTimer()"));
	NORMAL_M_ASSERT(OSAL_s32TimerSetTime(this->hDm1Timer, this->oDm1TimerPeriodMs, 0) == OSAL_OK);
	ETG_TRACE_COMP_THR(( "<-- vd_diaglog_CMCDm1Manager::startDm1MsgTimer()"));
}

void 
vd_diaglog_CMCDm1Manager::stopDm1MsgTimer()
{
	ETG_TRACE_COMP_THR(( "--> vd_diaglog_CMCDm1Manager::stopDm1MsgTimer()"));
	OSAL_s32TimerDelete(this->hDm1Timer);
	ETG_TRACE_COMP_THR(( "<-- vd_diaglog_CMCDm1Manager::stopDm1MsgTimer()"));
}
