//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_can_if.h
// PROJECT:      NISSAN
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog CAN Interface
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 18.05.15  | BSOT Plischke                | Initial version
// 28.12.18  | mky6kor						| Extended data configuration(RTC-434184)
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_can_if
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_can_if


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_plugin_if
   #include <common/plugin/vd_diaglog_plugin_if.h>
#endif

// forward declaration
class csm_tclCsmAccessUser; //lint !e763

class vdl_tclCanIf : public vdl_tclPluginBaseClass
{
public:
// operations
   vdl_tclCanIf();
   // Just make compiler happy to identify copy constructor.
   vdl_tclCanIf(vdl_tclCanIf const&);//coverity:52768:Dummy copy constructor
   // Just make compiler happy to identify assignment operator.
   vdl_tclCanIf const& operator=(vdl_tclCanIf const&);//coverity:52600:Dummy assignment operator
   virtual ~vdl_tclCanIf();

   virtual tVoid vOnInit();                                          // base class overload
   virtual tVoid vTimer(tS32 s32TimerId);                            // base class overload
   static vdl_tclCanIf* getInstanceOfCanIf() {return pCanIfTrigger;}
   bool bTransmitDM1TriggerMsg(tU8* dm1frame) const;
   tU32 getMileage();
   tU16 getOdometerValue();

private:
// attributes
   csm_tclCsmAccessUser*   m_pCsmAccessUser;        //lint -sem(vdl_tclCanIf::vClose,cleanup)
   tU32                    m_mileage;               // current mileage
   tS32                    m_mileageTimerID;        // fix Timer ID
   bool                    m_mileageUpdateAllowed;  // block mode intervall
   static vdl_tclCanIf* pCanIfTrigger;
   tU16                    m_OdometerValue;

// operations
   //lint -sem(vdl_tclCanIF::vClose,cleanup)
   tVoid vClose(); 
};

#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_can_if
