

#ifndef VD_DIAGLOG_INCLUDEGUARD_VD_DIAGLOG_CANSIGNALDM1
#include "vd_diaglog_CanSignalDM1.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_CanSignalDM1.cpp.trc.h"
#endif

#define DM1_MSG_SIZE 8

using namespace VDD;

CanSignalDM1::CanSignalDM1()
{
	ETG_TRACE_USR2_THR(( "--> CanSignalDM1::CanSignalDM1()"));

	ETG_TRACE_USR2_THR(( "<-- CanSignalDM1::CanSignalDM1()"));
}

CanSignalDM1::~CanSignalDM1()
{

}

dtc_can_dm1_frame CanSignalDM1::populateDM1Content(tU8 const & cru32DtcHigh,tU8 const & cru32DtcMid,tU8 const & cru32DtcLow,
		struct VDD::tstDm1LampState const& cru8LampState,
		struct VDD::tstDm1LampState const& cru8LampIntermittentState,
		tU8 cu8OccCnt)
{
	ETG_TRACE_USR2_THR(( "--> CanSignalDM1::populateDM1Content()"));
	dtc_can_dm1_frame DM1;
	tU8 tmpVal=0;
	tmpVal |= (cru8LampState.bitProtectState) << 0;
	tmpVal |= (cru8LampState.bitAmberWarningState) << 2;
	tmpVal |= (cru8LampState.bitRedStopState) << 4;
	tmpVal |= (cru8LampState.bitMalfunctionIndicatorState) << 6;
	DM1.LampState=tmpVal;

	tmpVal=0;
	tmpVal |= (cru8LampIntermittentState.bitProtectState) << 0;
	tmpVal |= (cru8LampIntermittentState.bitAmberWarningState) << 2;
	tmpVal |= (cru8LampIntermittentState.bitRedStopState) << 4;
	tmpVal |= (cru8LampIntermittentState.bitMalfunctionIndicatorState) << 6;
	DM1.LampStateIntermittent = tmpVal;

	DM1.DTCHighByte = cru32DtcHigh;
	DM1.DTCMiddleByte = cru32DtcMid;
	DM1.DTCLowByte = cru32DtcLow;

	tmpVal=0;
	tmpVal |= (cu8OccCnt & 0x7F);
	tmpVal &= ~(1 << 7);	// TODO: check whether 0 or 1 */
	DM1.OccurrenceCtr = tmpVal;


	DM1.ReservedByte1 = 0xFF;
	DM1.ReservedByte2 = 0xFF;
	return DM1;

	ETG_TRACE_USR2_THR(( "<-- CanSignalDM1::populateDM1Content()"));

}

void CanSignalDM1::vFrameDM1Message(VDD::dtc_can_dm1_frame const& DM1,tU8* DM1Frame)
{
	ETG_TRACE_USR2_THR(( "--> CanSignalDM1::frameDM1Message()"));
   DM1Frame[0] = DM1.LampState;
   DM1Frame[1] = DM1.LampStateIntermittent ;
   DM1Frame[2] = DM1.DTCHighByte;
   DM1Frame[3] = DM1.DTCMiddleByte ;
   DM1Frame[4] = DM1.DTCLowByte;
   DM1Frame[5] = DM1.OccurrenceCtr;
   DM1Frame[6] = DM1.ReservedByte1;
   DM1Frame[7] = DM1.ReservedByte2;
   ETG_TRACE_USR2_THR(( "<-- CanSignalDM1::frameDM1Message()"));

}
