//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_asf_plugin.cpp
// PROJECT:      RN A-IVI
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog ReportMemory creator class
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 11.10.12  | BSOT Plischke                 | Initial version
//////////////////////////////////////////////////////////////////////////

// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_asf_plugin
   #include "vd_diaglog_asf_plugin.h"
#endif 

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_asf_plugin.cpp.trc.h"
#endif


vdl_tclASFPlugin::vdl_tclASFPlugin(DiaglogStub* poDiaglogStub)
   : m_poDiaglogStub(poDiaglogStub)
{
   ETG_TRACE_COMP_THR(("--- vdl_tclASFPlugin::vdl_tclASFPlugin => m_poDiaglogStub = 0x%08x", m_poDiaglogStub));
}

//------------------------------------------------------------------------------

vdl_tclASFPlugin::~vdl_tclASFPlugin()
{
}

//------------------------------------------------------------------------------

void vdl_tclASFPlugin::vClear()
{
   ETG_TRACE_COMP_THR(("--- vdl_tclASFPlugin::vClear"));

   if (m_poDiaglogStub)
   {
      SendNextTestResultSignalNextTestResultStructStruct oData;

      oData.setElem1(true);
      oData.setElem2(1); //CLEAR_CODE

      m_poDiaglogStub->sendSendNextTestResultSignal(oData);
   }
}

//------------------------------------------------------------------------------

void vdl_tclASFPlugin::vUpdateAfterBlockingMode()
{
   ETG_TRACE_COMP_THR(("--- vdl_tclASFPlugin::vUpdateAfterBlockingMode"));

   if (m_poDiaglogStub)
   {
      SendNextTestResultSignalNextTestResultStructStruct oData;

      oData.setElem1(true);
      oData.setElem2(2); //BLOCKING_MODE_RESET

      m_poDiaglogStub->sendSendNextTestResultSignal(oData);
   }
}

//------------------------------------------------------------------------------
