/************************************************************************
* FILE:         vd_diaglog_service.h
* PROJECT:      DIAG Core
* SW-COMPONENT: VD_DiagLog
*----------------------------------------------------------------------
*
* DESCRIPTION: DiagLog Write Service handler
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 17.10.05  | CM-DI/ESA2 Barber  | initial version
* 15.10.12  | BSOT Plischke      | new Diaglog
*
*************************************************************************/

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_service
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_service

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
//lint -e451  //Warning 451: prio3: Header file repeatedly included but does not have a standard include guard

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"
//lint +e451

//lint -e451  // Warning 451: prio3: Header file repeatedly included but does not have a standard include guard
#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#define VD_DIAGLOG_S_IMPORT_INTERFACE_GENERIC
#include <vd_diaglog_if.h>
//lint +e451


class fi_tclTypeBase;  //lint !e763

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
class vdDiagLog_tclService : public ahl_tclBaseWork                            
{
private: // variables
   vdDiagLog_tclApp*          m_poGWMain;

   // private ctor to avoid inadvertant use
   //lint -esym(1704, vdDiagLog_tclService::vdDiagLog_tclService) "PQM_authorized_23"
   vdDiagLog_tclService(); // constructor, not used

   midw_fi_tcl_TestResultList       m_oReportCache;

 // Functions
   tVoid vOnSendNextTestResult(amt_tclServiceData* poMessage);
   tVoid vOnDtcTrigger(amt_tclServiceData* poMessage);
   bool bProcessTestReport(midw_fi_tcl_TestResultList&  roTestReport, bool isDynamicalDTC=false);
   bool bCheckLoadStatus(midw_fi_tcl_TestResultList& roTestReport);

   tVoid vOnGetDtcByStatusMask(amt_tclServiceData* poMessage);
   tVoid vOnGetSupportedDTC(amt_tclServiceData* poMessage);
   tVoid vOnGetLastConfirmedDTC(amt_tclServiceData* poMessage);
   tVoid vOnGetNumberOfDTCByStatusMask(amt_tclServiceData* poMessage);
   tVoid vOnGetStatusByDTC(amt_tclServiceData* poMessage);
   tVoid vOnGetStatusByITC(amt_tclServiceData* poMessage);
   tVoid vOnGetExtendedDataByDTC(amt_tclServiceData* poMessage);
   tVoid vOnClearDTC(amt_tclServiceData* poMessage);
   tVoid vUpdateAllClients(fi_tclTypeBase const&, tU16);
   tVoid vOnControl(amt_tclServiceData* poMessage);
   tVoid vOnControlDtcSetting(amt_tclServiceData* poMessage);
   tVoid vOnSetToDefaultRequest(amt_tclServiceData* poMessage);
   bool  bRelUpreg(amt_tclServiceData const*) const;
   tVoid vSendMsg(amt_tclServiceData const*, fi_tclTypeBase const&, tU8);
   tVoid vSendError(amt_tclServiceData const*  poMessage,tU16  u16ErrorCode);
   tVoid vSendNextTestResultStatus(midw_diaglogfi_tclMsgSendNextTestResultStatus const&);
   tVoid vSendNextTestResultStatus(amt_tclServiceData const*);
   bool  bUpreg(amt_tclServiceData const*) const;
   tVoid vOnGetSnapShotIdentification(amt_tclServiceData* poMessage);
   tVoid vOnGetSnapShotDataByDTC(amt_tclServiceData* poMessage);
   tVoid vOnProductionClear(amt_tclServiceData* poMessage);
   tVoid vOnGetItcInformation(amt_tclServiceData* poMessage);
   tVoid vOnSendActiveDTCList(amt_tclServiceData* poMessage);
   tVoid vSendActiveDTCListStatus(amt_tclServiceData const*);
   tVoid vOnDtcStatusChanged(amt_tclServiceData* poMessage);
   tVoid vSendDtcStatusChanged(amt_tclServiceData*);

public: // Functions
   vdDiagLog_tclService(vdDiagLog_tclApp* poVdDiagLog_MainApp);
   // framework
   tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState) const;
   // message handlers
   tVoid vOnNewTestResult(amt_tclServiceData* poMessage);
   tVoid vOnNewTestResultDynamialDTC(amt_tclServiceData* poMessage);
   tVoid vSendUpdateStatus(tITCVector& ITCs);
   tVoid vUpdateAfterBlockingMode(tServiceUpdateMap updateMap);
   tVoid vSendActiveDTCListStatus(std::vector<tU32> dtcList);
   tVoid vSendDtcStatusChanged(tU8 MemoryId, tU32 u32DTC);
protected:
   virtual tVoid vOnUnknownMessage(amt_tclBaseMessage*);


public:  
   DECLARE_MSG_MAP(vdDiagLog_tclService)

};

#endif //VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_service
