/************************************************************************
* FILE:         vdDiaglog_tclclienthandlerspm.cpp
* PROJECT:      common
* SW-COMPONENT: VD_DIAGLOG
*----------------------------------------------------------------------
*
* DESCRIPTION: DIAGLOG to SPM Interface
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 31.10.12  | BSOT Plischke      | initial version
* 07.11.12	| GPU2KOR			 | changed vOnHandleSystemPowerModeEvent for new spm_fi
*************************************************************************/

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"


#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#define VD_DIAGLOG_S_IMPORT_INTERFACE_GENERIC
#include <vd_diaglog_if.h>


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_memory
   #include <common/framework/vd_diaglog_report_memory.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_service
   #include <project/interfaces/vd_diaglog_service.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main
   #include <common/framework/vd_diaglog_main.h>
#endif

#include "vd_diaglog_clienthandlerspm.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_clienthandlerspm.cpp.trc.h"
#endif


/* +++
MESSAGE MAP:
The function will be called when a message with the corresponding FID arrives
+++ */

BEGIN_MSG_MAP( vdDiaglog_tclclienthandlerspm, ahl_tclBaseWork )
ON_MESSAGE(SPM_COREFI_C_U16_CVMEVENT, vOnSpmCvmEvent)
//ON_MESSAGE(CFC_SPMFI_C_U16_SUBSTATES,  vOnHandleSpmSubstateHandlingEvent)
//ON_MESSAGE(CFC_SPMFI_C_U16_SYSSTATE,  vOnHandleSysStateEvent)
ON_MESSAGE(SPM_COREFI_C_U16_SYSPWRMODE,  vOnHandleSystemPowerModeEvent)
END_MSG_MAP( )


//class fi_tclTypeBase;
/*************************************************************************
*
* FUNCTION: vdDiaglog_tclclienthandlerspm::vdDiaglog_tclclienthandlerspm(vdDiagLog_tclApp* poGWMainApp)
* 
* DESCRIPTION: constructor, creates object vdDiaglog_tclclienthandlerspm - object
*
* PARAMETER: vdDiagLog_tclApp* poGWMainApp: main - object of this application 
*
* RETURNVALUE: none
*
*************************************************************************/
vdDiaglog_tclclienthandlerspm::vdDiaglog_tclclienthandlerspm(vdDiagLog_tclApp* poVdDiagLog_MainApp):
   m_poGWMain(NULL),
   _bFidReg(FALSE),
   _bRegistrationInProgress(FALSE),
   //m_u32InternalSubstateOld(SPM_U32_INTERNAL_SUBSTATE_MOST_RING_ACTIVE|SPM_U32_INTERNAL_SUBSTATE_NETWORK_ACTIVITY),//We assume at Startup that the CAN and MOST Blcoking Modes are deactivated  until we receive CAN and MOST State Report from SPM        
   m_u32InternalSubstateOld(0),//We assume at Startup that nothing is ok => LPE
   
   
   bFirstIgnitionCycleEventRecvd(FALSE),//SPM did not yet report any ignition Cycle event
   _enLastPowerMode(spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_OFF)
{
   ETG_TRACE_USR3_THR(( "--> vdDiaglog_tclclienthandlerspm::vdDiaglog_tclclienthandlerspm"));
   /* ---
   this constructor calls ( impicit ) the constructor of the upper class ( framework )
   so it registers the combinations of FID and message handler with the framework
   --- */
   m_poGWMain = poVdDiagLog_MainApp;

   _u16RegID = AMT_C_U16_REGID_INVALID;
   ETG_TRACE_USR3_THR(( "<-- vdDiaglog_tclclienthandlerspm::vdDiaglog_tclclienthandlerspm"));
}

/*************************************************************************
*
* FUNCTION:tVoid vdDiaglog_tclclienthandlerspm::vOnUnknownMessage(amt_tclBaseMessage* poMessage)
* 
* DESCRIPTION: handle unkown message
*
* PARAMETER:  unkown message
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid vdDiaglog_tclclienthandlerspm::vOnUnknownMessage(amt_tclBaseMessage* poMessage)
{
   ETG_TRACE_USR3_THR(( "--> vdDiaglog_tclclienthandlerspm::vOnUnknownMessage"));
   /* +++
    the frame work calls this function when it receives a message with a unknown 
    FID. You can use it for error handling.
   +++ */
   (tVoid) poMessage->bDelete();
   ETG_TRACE_USR3_THR(( "<-- vdDiaglog_tclclienthandlerspm::vOnUnknownMessage"));
}

/*************************************************************************
*
* FUNCTION: tVoid vdDiaglog_tclclienthandlerspm::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState)
* 
* DESCRIPTION: handles state - change messages form the spm
*
* PARAMETER: old state, new state
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid vdDiaglog_tclclienthandlerspm::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState)
{
   ETG_TRACE_USR3_THR(( "--> vdDiaglog_tclclienthandlerspm::vOnNewAppState"));
   switch(u32AppState)
   {
      case AMT_C_U32_STATE_NORMAL:
      {
         if(u32OldAppState == AMT_C_U32_STATE_NORMAL) 
         { 
            break; //switching to the same state
         } 
         if ( u32OldAppState != AMT_C_U32_STATE_DIAGNOSIS ) 
         {                
             // register for service, if not already registered ( check internally )
             tBool bRetVal = bRegisterForService();

             // check the returned value to see if we have a registration problem  
             if ( bRetVal == FALSE )
             {
               NORMAL_M_ASSERT_ALWAYS();
             }
         }
         else
         {
             // DO NOTHING JUST RELAX
         }
         
         break;
      }

      case AMT_C_U32_STATE_DIAGNOSIS:
      {
         if(u32OldAppState == AMT_C_U32_STATE_DIAGNOSIS) 
         { 
            break; //switching to the same state
         } 

         if ( u32OldAppState != AMT_C_U32_STATE_NORMAL ) 
         {


             // register for service, if not already registered ( check internally )
             tBool bRetVal = bRegisterForService();

             // check the returned value to see if we have a registration problem  
             if ( bRetVal == FALSE )
             {
               NORMAL_M_ASSERT_ALWAYS();
             }
         }
         else
         {
              // DO NOTHING JUST RELAX
      }
         
         break;
      }

      case AMT_C_U32_STATE_PAUSE:
      {
         if(u32OldAppState == AMT_C_U32_STATE_PAUSE) 
         { 
            break; //switching to the same state
         } 
         if (  (u32OldAppState == AMT_C_U32_STATE_DIAGNOSIS)
             ||(u32OldAppState == AMT_C_U32_STATE_NORMAL))
         {
            tBool bRetVal = bUnregisterForService();
            // check the returned value to see if we have a registration problem  
            if ( bRetVal == FALSE )
            {
               NORMAL_M_ASSERT_ALWAYS();
            }
         }
         
         break;
      }

      case AMT_C_U32_STATE_OFF:
      {
         if(u32OldAppState == AMT_C_U32_STATE_OFF) 
         { 
            break; //switching to the same state
         } 

         if (  (u32OldAppState == AMT_C_U32_STATE_DIAGNOSIS)
             ||(u32OldAppState == AMT_C_U32_STATE_NORMAL))
         {
            tBool bRetVal = bUnregisterForService();
            // check the returned value to see if we have a registration problem  
            if ( bRetVal == FALSE )
            {
               NORMAL_M_ASSERT_ALWAYS();
            }
         }  
         break;
      }

      default:
      {
         /* +++
         unknown power state:
         enter error handling here ( trace or assert )
         +++ */
         break;
      }
   }
   ETG_TRACE_USR3_THR(( "<-- vdDiaglog_tclclienthandlerspm::vOnNewAppState"));
}


//-----------------------------------------------------------------------------
// helper functions
//-----------------------------------------------------------------------------

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    vdDiaglog_tclclienthandlerspm::bRegisterForServiceSpm
//
//  DESCRIPTION: to register the SPM service
//
//  PARAMETER:   NONE
//
//  RETURNVALUE: true if succesfull
///////////////////////////////////////////////////////////////////////////
tBool vdDiaglog_tclclienthandlerspm::bRegisterForService()
{ 
   ETG_TRACE_USR3_THR(( "--> vdDiaglog_tclclienthandlerspm::bRegisterForService"));
   tBool bRetVal = TRUE;

   if(NULL != m_poGWMain)
   {
        // Check that the registartion is valid
      if((_u16RegID == AMT_C_U16_REGID_INVALID) && (_bRegistrationInProgress == FALSE))
      {
          _bRegistrationInProgress = TRUE;
          _u16RegID = m_poGWMain->u16RegisterService( CCA_C_U16_SRV_SPM,
                                                      1,
                                                      0,
                                                      0, 
                                                      CCA_C_U16_APP_SPM );
      }
      else
      {
      }

   }
   else
   {
      ET_TRACE_ERROR(DIAGLOG_TRACE_CLASS_INFO,"!!!! EXCEPTION in dia_tclSpmClientHandler::vRegisterForService poGWMain = NULL !!!!");
      NORMAL_M_ASSERT_ALWAYS();
      bRetVal = FALSE;
   }


   ETG_TRACE_USR3_THR(( "<-- vdDiaglog_tclclienthandlerspm::bRegisterForService"));
    return bRetVal;

}    // End of vdDiaglog_tclclienthandlerspm::bRegisterForServiceSpm


/*************************************************************************
*
*   FUNCTION:    tBool dia_tclSpmClientHandler::bUnregisterForService();
*
*
*   DESCRIPTION: unregister from the SPM services
*
*
*   PARAMETER:   void
*
*
*   RETURNVALUE: void
*
*
*
*************************************************************************/
tBool vdDiaglog_tclclienthandlerspm::bUnregisterForService()
{
   ETG_TRACE_USR3_THR(( "--> vdDiaglog_tclclienthandlerspm::bUnregisterForService"));
   tBool bRetVal = TRUE;

   if(NULL != m_poGWMain)
   {
      // registration valid?
      if (_u16RegID != AMT_C_U16_REGID_INVALID)
      {
         if ( _bFidReg == TRUE)
         {
         (tVoid ) bUnregisterForFID(SPM_COREFI_C_U16_CVMEVENT);
      // (tVoid ) bUnregisterForFID(FID_SPM_SUBSTATE);
         (tVoid ) bUnregisterForFID(CFC_SPMFI_C_U16_SUBSTATES);
         //(tVoid ) bUnregisterForFID(CFC_SPMFI_C_U16_SYSSTATE);
         (tVoid ) bUnregisterForFID(SPM_COREFI_C_U16_SYSPWRMODE);
         }

         // unregister for Service
         m_poGWMain->vUnregisterService(static_cast<tU16>(CCA_C_U16_SRV_SPM));
 

         // Set that the function ID's are unregistered
          _bFidReg = FALSE;

         // Destoy local copy of registration Id
         _u16RegID = AMT_C_U16_REGID_INVALID;
 
      }
      else 
      {     
           // Oopse an error may be we are already unregistered
           //bRetVal = FALSE;     /*Do nothing*/
      }
   }
   else
   {
      ET_TRACE_ERROR(DIAGLOG_TRACE_CLASS_INFO,"!!!! EXCEPTION in dia_tclSpmClientHandler::bUnregisterForService poGWMain = NULL !!!!");
      NORMAL_M_ASSERT_ALWAYS();
      bRetVal = FALSE;
   }

   ETG_TRACE_USR3_THR(( "<-- vdDiaglog_tclclienthandlerspm::bUnregisterForService"));
  return bRetVal;

}   // End of dia_tclSpmClientHandler::bUnregisterForService

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    vdDiaglog_tclclienthandlerspm::bRegisterForFID
//
//  DESCRIPTION: to register the SPM Function Id's
//
//  PARAMETER:   NONE
//
//  RETURNVALUE: true if succesfull
///////////////////////////////////////////////////////////////////////////
tBool vdDiaglog_tclclienthandlerspm::bRegisterForFID(tU16 u16FID)
{
   ETG_TRACE_USR3_THR(( "--> vdDiaglog_tclclienthandlerspm::bRegisterForFID"));
   tBool bRetVal = FALSE;

   if(NULL != m_poGWMain)
   {
     // Check that the registration Id is valid  
     if (_u16RegID != AMT_C_U16_REGID_INVALID)
     {
         /* create message with upreg - request */
         gm_tclEmptyMessage oUpRegMessage( CCA_C_U16_APP_DIAGLOG,  // AppID of this application 
                                           CCA_C_U16_APP_SPM,        // AppID of the Server 
                                           _u16RegID,                // RegId for the service (see bRegisterForService ) 
                                           0,                        // always 0 
                                           CCA_C_U16_SRV_SPM,        // SID of the service 
                                           u16FID,                   // FID to register for 
                                           AMT_C_U8_CCAMSG_OPCODE_UPREG);

         ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "......................................................................................................"));
         switch (u16FID)
         {
            case SPM_COREFI_C_U16_CVMEVENT:
               ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "*********Trying to send CCA Msg _ SPM_COREFI_C_U16_CVMEVENT _ OPCODE-UPREG**********"));
               break;

            case CFC_SPMFI_C_U16_SUBSTATES:
               ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "*********Trying to send CCA Msg _ CFC_SPMFI_C_U16_SUBSTATES _ OPCODE-UPREG**********"));
               break;

            /*case CFC_SPMFI_C_U16_SYSSTATE:
               ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "*********Trying to send CCA Msg _ CFC_SPMFI_C_U16_SYSSTATE _ OPCODE-UPREG**********"));
               break;
*/
            case SPM_COREFI_C_U16_SYSPWRMODE:
               ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "*********Trying to send CCA Msg _ SPM_COREFI_C_U16_SYSPWRMODE _ OPCODE-UPREG**********"));
               break;

            case CFC_SPMFI_C_U16_IGNITIONCYCLES:
               ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "*********Trying to send CCA Msg _ CFC_SPMFI_C_U16_IGNITIONCYCLES _ OPCODE-UPREG**********"));
               break;

            default:
               break;
         }
      
         if (m_poGWMain->enPostMessage(&oUpRegMessage, TRUE) == AIL_EN_N_NO_ERROR)
         {
            // message send success - set the return value to TRUE
            bRetVal = TRUE;
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "***CCA_MSG Sent: FI = %d", u16FID));
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sent: u16SourceAppID = %x", CCA_C_U16_APP_DIAGLOG));
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sent: u16TargetAppID = %x", CCA_C_U16_APP_SPM));
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sent: Opcode = AMT_C_U8_CCAMSG_OPCODE_UPREG"));
         }
         else
         {
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "***CCA_MSG Sending failed: FI = %d", u16FID));
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sending: u16SourceAppID = %x", CCA_C_U16_APP_DIAGLOG));
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sending: u16TargetAppID = %x", CCA_C_U16_APP_SPM));
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sending: Opcode = AMT_C_U8_CCAMSG_OPCODE_UPREG"));
         }
      }
   }
   else
   {
      ET_TRACE_ERROR(DIAGLOG_TRACE_CLASS_INFO,"!!!! EXCEPTION in dia_tclSpmClientHandler::bRegisterForFID poGWMain = NULL !!!!");
      NORMAL_M_ASSERT_ALWAYS();
   }

   ETG_TRACE_USR3_THR(( "<-- vdDiaglog_tclclienthandlerspm::bRegisterForFID"));
   return bRetVal;

}    // End of dia_tclSpmClientHandler::bRegisterForFID

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    vdDiaglog_tclclienthandlerspm::bRegisterForFIDSpm
//
//  DESCRIPTION: to register the SPM Function Id's
//
//  PARAMETER:   NONE
//
//  RETURNVALUE: true if succesfull
///////////////////////////////////////////////////////////////////////////
tBool vdDiaglog_tclclienthandlerspm::bUnregisterForFID(tU16 u16FID)
{
   ETG_TRACE_USR3_THR(( "--> vdDiaglog_tclclienthandlerspm::bUnregisterForFID"));
   tBool bRetVal = FALSE;

   if(NULL != m_poGWMain)
   {
     // Check that the registration Id is valid  
     if (_u16RegID != AMT_C_U16_REGID_INVALID)
     {
         /* create message with upreg - request */
         gm_tclEmptyMessage oRelupRegMessage( CCA_C_U16_APP_DIAGLOG,  // AppID of this application 
                                           CCA_C_U16_APP_SPM,        // AppID of the Server 
                                           _u16RegID,                // RegId for the service (see bRegisterForService ) 
                                           0,                        // always 0 
                                           CCA_C_U16_SRV_SPM,        // SID of the service 
                                           u16FID,                   // FID to register for 
                                           AMT_C_U8_CCAMSG_OPCODE_RELUPREG);

         ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "......................................................................................................"));
         switch (u16FID)
         {
            case SPM_COREFI_C_U16_CVMEVENT:
               ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "*********Trying to send CCA Msg _ SPM_COREFI_C_U16_CVMEVENT _ OPCODE-UPREG**********"));
               break;

            case CFC_SPMFI_C_U16_SUBSTATES:
               ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "*********Trying to send CCA Msg _ CFC_SPMFI_C_U16_SUBSTATES _ OPCODE-UPREG**********"));
               break;

            /*case CFC_SPMFI_C_U16_SYSSTATE:
               ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "*********Trying to send CCA Msg _ CFC_SPMFI_C_U16_SYSSTATE _ OPCODE-UPREG**********"));
               break;
*/
            case SPM_COREFI_C_U16_SYSPWRMODE:
               ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "*********Trying to send CCA Msg _ SPM_COREFI_C_U16_SYSPWRMODE _ OPCODE-UPREG**********"));
               break;

            case CFC_SPMFI_C_U16_IGNITIONCYCLES:
               ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "*********Trying to send CCA Msg _ CFC_SPMFI_C_U16_IGNITIONCYCLES _ OPCODE-UPREG**********"));
               break;

            default:
               break;
         }
        
         if (m_poGWMain->enPostMessage(&oRelupRegMessage, TRUE) == AIL_EN_N_NO_ERROR)
         {
            // message send success - set the return value to TRUE
            bRetVal = TRUE;
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "***CCA_MSG Sent: FI = %d", u16FID));
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sent: u16SourceAppID = %x", CCA_C_U16_APP_DIAGLOG));
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sent: u16TargetAppID = %x", CCA_C_U16_APP_SPM));
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sent: Opcode = AMT_C_U8_CCAMSG_OPCODE_RELUPREG (Confiramtion of Ungregister)"));
         }
         else
         {
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "***CCA_MSG Sending failed: FI = %d", u16FID));
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sending failed: u16SourceAppID = %x", CCA_C_U16_APP_DIAGLOG));
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sending failed: u16TargetAppID = %x", CCA_C_U16_APP_SPM));
            ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sending failed: Opcode = AMT_C_U8_CCAMSG_OPCODE_RELUPREG (Confiramtion of Ungregister)"));
         }
      }
   }
   else
   {
      ET_TRACE_ERROR(DIAGLOG_TRACE_CLASS_INFO,"!!!! EXCEPTION in dia_tclSpmClientHandler::bRegisterForFID poGWMain = NULL !!!!");
      NORMAL_M_ASSERT_ALWAYS();
   }

   ETG_TRACE_USR3_THR(( "<-- vdDiaglog_tclclienthandlerspm::bUnregisterForFID"));
   return bRetVal;

}    // End of dia_tclSpmClientHandler::bRegisterForFID

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    vdDiaglog_tclclienthandlerspm::vOnServiceState
//
//  DESCRIPTION: to check the current SPM Service State
//
//  PARAMETER:   NONE
//
//  RETURNVALUE: true if succesfull
///////////////////////////////////////////////////////////////////////////
tVoid vdDiaglog_tclclienthandlerspm::vOnServiceState(tU16 u16ServiceId,
                                                     tU16 /*u16ServerId*/,
                                                     tU16 u16RegisterId,
                                                     tU8  u8ServiceState,
                                                     tU16 /*u16SubId*/)
{
   ETG_TRACE_USR3_THR(( "--> vdDiaglog_tclclienthandlerspm::vOnServiceState"));
   if( (u16ServiceId != CCA_C_U16_SRV_SPM) && (u16RegisterId == _u16RegID) )
   {
      // Opse ! looks like the service state is not from SPM 
   }
   else
   {  
      // analyze the state of the server
      switch (u8ServiceState)
      {
         case AMT_C_U8_SVCSTATE_AVAILABLE:
         {
            // the service is now available, register only once, for each FID
            if ( _bFidReg == FALSE)
            {
               (tVoid) bRegisterForFID(SPM_COREFI_C_U16_CVMEVENT);
               (tVoid) bRegisterForFID(CFC_SPMFI_C_U16_SUBSTATES);
               //(tVoid) bRegisterForFID(CFC_SPMFI_C_U16_SYSSTATE);
               (tVoid) bRegisterForFID(SPM_COREFI_C_U16_SYSPWRMODE);
                                
               _bFidReg = TRUE;
               _bRegistrationInProgress = FALSE;
            }
            break;
         }//case AMT_C_U8_SVCSTATE_AVAILABLE:

         case AMT_C_U8_SVCSTATE_NOT_AVAILABLE:
         {
            // the service is not available anymore
            break;
         }// case AMT_C_U8_SVCSTATE_NOT_AVAILABLE

         case AMT_C_U8_SVCSTATE_REG_INVALID:
         {
            // the server has lost our registration
            // register again.
             tBool bRetVal = bRegisterForService();

             // check the returned value to see if we have a registration problem  
             if ( bRetVal == FALSE )
             {
               NORMAL_M_ASSERT_ALWAYS();
             }
            _bFidReg = FALSE;
            break;
         }// case AMT_C_U8_SVCSTATE_REG_INVALID:

         default:
         {
            break;
         }
      }
   }
   ETG_TRACE_USR3_THR(( "<-- vdDiaglog_tclclienthandlerspm::vOnServiceState"));
}    /// End of dia_tclSpmClientHandler::vOnServiceState

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    vdDiaglog_tclclienthandlerspm::vSendMsg
//
//  DESCRIPTION: sends a CCA message
//
//  PARAMETER:   poMessage - incoming request
//                oFIData - property data
//                u8OpCode - CCA op code
//
//  RETURNVALUE: NONE
///////////////////////////////////////////////////////////////////////////
//
tVoid vdDiaglog_tclclienthandlerspm::vSendMsg(amt_tclServiceData const*  poMessage, 
                                              fi_tclTypeBase const&      oFIData,
                                              tU8                        u8OpCode)
{
   ETG_TRACE_USR3_THR(( "--> vdDiaglog_tclclienthandlerspm::vSendMsg"));
   // Check the validity of incoming data
   if (NULL == poMessage)
   {
      // Message received from framework is NULL!!!
      NORMAL_M_ASSERT (NULL != poMessage);
      return;
   }
   // construct result message
   fi_tclVisitorMessage oResultMsg(oFIData); 
   // initialise result message
   oResultMsg.vInitServiceData(
                              CCA_C_U16_APP_DIAGLOG,            // source
                              poMessage->u16GetSourceAppID(),     // Target
                              AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,  // StreamType
                              0,                                  // StreamCounter
                              poMessage->u16GetRegisterID(),      // RegisterID
                              poMessage->u16GetCmdCounter(),      // nCmdCounter, 
                              CCA_C_U16_SRV_DIAGLOG,              // nServiceID, 
                              poMessage->u16GetFunctionID(),      // function ID
                              u8OpCode,                                      
                              AMT_C_U16_DEFAULT_NULL,
                              poMessage->u16GetSourceSubID()
                              );
   NORMAL_M_ASSERT(NULL != m_poGWMain);
   // send it
   if(NULL != m_poGWMain)
   {
      ail_tenCommunicationError enResult = m_poGWMain->enPostMessage(&oResultMsg, TRUE);
      //NORMAL_M_ASSERT(enResult == AIL_EN_N_NO_ERROR);
      if(enResult == AIL_EN_N_NO_ERROR)
      {     
         ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "***CCA_MSG Sent: FI = %d", poMessage->u16GetFunctionID()));
         ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sent: u16SourceAppID = %x", CCA_C_U16_APP_DIAGLOG));
         ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sent: u16TargetAppID = %x", poMessage->u16GetSourceAppID()));
         ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sent: Opcode = %d", u8OpCode));
     }
     else
     {
         ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "***CCA_MSG Sending failed: FI = %d", poMessage->u16GetFunctionID()));
         ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sending failed: u16SourceAppID = %x", CCA_C_U16_APP_DIAGLOG));
         ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sending failed: u16TargetAppID = %x", poMessage->u16GetSourceAppID()));
         ETG_TRACE_USR4_CLS((TR_CLASS_DIAGLOG_CCA_MSG, "\t CCA_MSG Sending failed: Opcode = %d", u8OpCode));
     }
   }
   ETG_TRACE_USR3_THR(( "<-- vdDiaglog_tclclienthandlerspm::vSendMsg"));
}



/*************************************************************************
*
*  FUNCTION:    dia_tclSpmClientHandler::vHandleCvmEvent
*  DESCRIPTION: CVM Event: Over/Under/Normal Voltage Informations
*
*                       |--------------------------|-----------------------|-----------------------|-----------------------|------------------------|
*  SPM Voltage Modes:         |  SPM Critical Low Volt. |  SPM Low Volt.         |  SPM Normal Volt.   |  SPM High Voltage    | SPM Critical High Volt.| 
*                       |--------------------------|-----------------------|-----------------------|-----------------------|------------------------|
*  GM Voltage Modes (GIS 307):   |  GM Low Volt.         |  GM Critical Low Volt.|  GM Normal Volt.    |  GM Super Voltage    | None               |
*                       |--------------------------|-----------------------|-----------------------|-----------------------|------------------------|
*  PARAMETER: 
*  RETURNVALUE: NONE
*
*************************************************************************/
tVoid vdDiaglog_tclclienthandlerspm::vOnSpmCvmEvent(amt_tclServiceData* poMessage) const
{
   ETG_TRACE_USR3_THR(( "--> vdDiaglog_tclclienthandlerspm::vOnSpmCvmEvent"));
   if(poMessage == nullptr)
   {
      NORMAL_M_ASSERT_ALWAYS ();
      return;
   }
      // Msg must come from a server
      NORMAL_M_ASSERT(poMessage->bIsServerMessage() == TRUE);  //Coverity Fix:(CID 17150)

      if(m_poGWMain != NULL)
      {
         switch (poMessage->u8GetOpCode())
         {
            case AMT_C_U8_CCAMSG_OPCODE_STATUS:
            {         
               #ifdef DIAGLOG_BLOCKING_MODE_VOLTAGE_OUT_OF_RANGE
                  fi_tclVisitorMessage oResultMsg(poMessage);

                  spm_corefi_tclMsgCvmEventStatus oCompResp;

                  if (oResultMsg.s32GetData(oCompResp, MIDW_DIAGLOGFI_C_U16_SERVICE_MAJORVERSION) == OSAL_ERROR)
                  {
                     NORMAL_M_ASSERT_ALWAYS ();
                  }

                  spm_fi_tcl_SPM_e32_CVM_EVENT::tenType enVoltageState = oCompResp.CvmEvent.enType;

                 //There are no Jumps in the Voltage States (e.g. low -> normal is impossible but low ->critical->normal)
                  switch(enVoltageState)
                  {
#if 0
                     case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START:
                     {
                        ETG_TRACE_USR4(( "Getting down from GM critical to GM low voltage zone (GIS 307)"));
                        if(NULL != vdDiagLog_tclApp::m_poInstance)
                        {
                           (vdDiagLog_tclApp::m_poInstance)->vSetBlockingMode(DIAGLOG_BLOCKING_MODE_VOLTAGE_OUT_OF_RANGE);
                        }
                     }
                     break;
                     
                     case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_END:
                     {
                        ETG_TRACE_USR4(( "Getting up from GM low to GM critical voltage zone (GIS 307)"));
                        if(NULL != vdDiagLog_tclApp::m_poInstance)
                        {
                           (vdDiagLog_tclApp::m_poInstance)->vResetBlockingMode(DIAGLOG_BLOCKING_MODE_VOLTAGE_OUT_OF_RANGE);
                        }
                     }
                     break;
#endif

                     case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_START:
                     {
                        ETG_TRACE_USR1(("--- vdDiaglog_tclclienthandlerspm::vOnSpmCvmEvent => LOW_VOLTAGE_START"));
                        if(NULL != vdDiagLog_tclApp::m_poInstance)
                        {
                           (vdDiagLog_tclApp::m_poInstance)->vSetBlockingMode(DIAGLOG_BLOCKING_MODE_VOLTAGE_OUT_OF_RANGE);
                        }
                     }
                     break;

                     case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_END:
                     {
                        ETG_TRACE_USR1(("--- vdDiaglog_tclclienthandlerspm::vOnSpmCvmEvent => LOW_VOLTAGE_END"));
                        (vdDiagLog_tclApp::m_poInstance)->vSetBlockingMode(DIAGLOG_BLOCKING_MODE_VOLTAGE_TIMER);
                        if(NULL != vdDiagLog_tclApp::m_poInstance)
                        {
                           (vdDiagLog_tclApp::m_poInstance)->vResetBlockingMode(DIAGLOG_BLOCKING_MODE_VOLTAGE_OUT_OF_RANGE);
                        }
                     }
                     break;
                     
                     case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_START:
                     {
                        ETG_TRACE_USR1(("--- vdDiaglog_tclclienthandlerspm::vOnSpmCvmEvent => HIGH_VOLTAGE_START"));
                        if(NULL != vdDiagLog_tclApp::m_poInstance)
                        {
                           (vdDiagLog_tclApp::m_poInstance)->vSetBlockingMode(DIAGLOG_BLOCKING_MODE_VOLTAGE_OUT_OF_RANGE);
                        }
                     }
                     break;

                     case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_END:
                     {
                        ETG_TRACE_USR1(("--- vdDiaglog_tclclienthandlerspm::vOnSpmCvmEvent => HIGH_VOLTAGE_END"));
                        (vdDiagLog_tclApp::m_poInstance)->vSetBlockingMode(DIAGLOG_BLOCKING_MODE_VOLTAGE_TIMER);
                        if(NULL != vdDiagLog_tclApp::m_poInstance)
                        {
                           (vdDiagLog_tclApp::m_poInstance)->vResetBlockingMode(DIAGLOG_BLOCKING_MODE_VOLTAGE_OUT_OF_RANGE);
                        }
                     }
                     break;

#if 0
                     case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_START:
                     {  
                        ETG_TRACE_USR4(( "Getting up from GM super to Bosch critical High Voltage zone"));
                        if(NULL != vdDiagLog_tclApp::m_poInstance)
                        {
                           (vdDiagLog_tclApp::m_poInstance)->vSetBlockingMode(DIAGLOG_BLOCKING_MODE_VOLTAGE_OUT_OF_RANGE);
                        }
                     }
                     break;
                     
                     case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_END:
                     {
                        ETG_TRACE_USR4(( "Getting down from Bosch critical High Voltage to GM super zone"));
                        if(NULL != vdDiagLog_tclApp::m_poInstance)
                        {
                           (vdDiagLog_tclApp::m_poInstance)->vSetBlockingMode(DIAGLOG_BLOCKING_MODE_VOLTAGE_OUT_OF_RANGE);
                        }
                     }
                     break;
#endif

                     
                     default:
                     {
                        ETG_TRACE_USR1(("--- vdDiaglog_tclclienthandlerspm::vOnSpmCvmEvent => enVoltageState = %d", enVoltageState));
                        break;
                     }
                  }
                  break;
               #endif // DIAGLOG_BLOCKING_MODE_VOLTAGE_OUT_OF_RANGE
            }

            default:
            {
               /* FID SystemState knows only the status OpCode */
               break;
            }
         } // switch (poMessage->u8GetOpCode())
         (tVoid) poMessage->bDelete();
   }//if(m_poGWMain != NULL)
   ETG_TRACE_USR3_THR(( "<-- vdDiaglog_tclclienthandlerspm::vOnSpmCvmEvent"));
}


/*************************************************************************
*
*  FUNCTION:    dia_tclSpmClientHandler::vOnHandleSpmSubstateHandlingEvent
*
*
*   DESCRIPTION: react on messages with FID = FID_SPM_SUBSTATE_AHNDLING: MOST and CAN Bus States
*
*
*   PARAMETER:   amt_tclServiceData* poMessage
*
*   RETURNVALUE: NONE
*
*
*
*
*************************************************************************/
#if 0
tVoid vdDiaglog_tclclienthandlerspm::vOnHandleSpmSubstateHandlingEvent(amt_tclServiceData* /*poMessage*/)
{
   ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSpmSubstateHandlingEvent"));

   // Msg must come from a server
   NORMAL_M_ASSERT(poMessage->bIsServerMessage() == TRUE);

   tU32 u32BlockingMode;
   if(poMessage != NULL)
   {
      if(m_poGWMain != NULL)
      {
         switch (poMessage->u8GetOpCode())
         {
            case AMT_C_U8_CCAMSG_OPCODE_STATUS:
            {                 
               fi_tclVisitorMessage oResultMsg(poMessage);

               cfc_spmfi_tclMsgSubStatesStatus oCompResp;

               if (oResultMsg.s32GetData(oCompResp, MIDW_DIAGLOGFI_C_U16_SERVICE_MAJORVERSION) == OSAL_ERROR)
               {
                  NORMAL_M_ASSERT_ALWAYS ();
               }

               tU32 u32InternalSubState = oCompResp.InternSubState;

               ETG_TRACE_USR4_THR(( "--- vdDiagLog_tclService::vOnHandleSpmSubstateHandlingEvent => SPM Message SubState: %x",u32InternalSubState));

               /*** SPM_U32_INTERNAL_SUBSTATE_MOST_RING_ACTIVE ***/
               if ((u32InternalSubState & SPM_U32_INTERNAL_SUBSTATE_MOST_RING_ACTIVE) ==  SPM_U32_INTERNAL_SUBSTATE_MOST_RING_ACTIVE) //MOST Ring is active
               {
                  if ((m_u32InternalSubstateOld & SPM_U32_INTERNAL_SUBSTATE_MOST_RING_ACTIVE) !=  SPM_U32_INTERNAL_SUBSTATE_MOST_RING_ACTIVE) //MOST Ring was not active
                  {
                     // ETG_TRACE_USR4(( "Resetting Blocking Mode Most Bus not active "));    
                     if(NULL != vdDiagLog_tclApp::m_poInstance)
                     {
                        (vdDiagLog_tclApp::m_poInstance)->vResetBlockingMode(DIAGLOG_BLOCKING_MODE_MOST_BUS_NOT_ACTIVE);
                     }
                  }
               }
               else//MOST Ring is not Active
               {    
                  if ((m_u32InternalSubstateOld & SPM_U32_INTERNAL_SUBSTATE_MOST_RING_ACTIVE) ==  SPM_U32_INTERNAL_SUBSTATE_MOST_RING_ACTIVE) //MOST Ring was Active
                  {
                     //  ETG_TRACE_USR4(( "Setting Blocking Mode Most Bus not active "));
                     if(NULL != vdDiagLog_tclApp::m_poInstance)
                     {
                        (vdDiagLog_tclApp::m_poInstance)->vSetBlockingMode(DIAGLOG_BLOCKING_MODE_MOST_BUS_NOT_ACTIVE);
                     }
                  }
               }

               /*** SPM_U32_INTERNAL_SUBSTATE_NETWORK_ACTIVITY ***/
               if ((u32InternalSubState & SPM_U32_INTERNAL_SUBSTATE_NETWORK_ACTIVITY) ==  SPM_U32_INTERNAL_SUBSTATE_NETWORK_ACTIVITY) //CAN Bus is active
               {
                  if ((m_u32InternalSubstateOld & SPM_U32_INTERNAL_SUBSTATE_NETWORK_ACTIVITY) !=  SPM_U32_INTERNAL_SUBSTATE_NETWORK_ACTIVITY) //CAN Bus was not active
                  {
                     if(NULL != vdDiagLog_tclApp::m_poInstance)
                     {
                        (vdDiagLog_tclApp::m_poInstance)->vResetBlockingMode(DIAGLOG_BLOCKING_MODE_HS_COMM_ENABLE_NOT_ACTIVE);
                        u32BlockingMode = (vdDiagLog_tclApp::m_poInstance)->u32GetSystemBlockingMode();
                        if (  (!(u32BlockingMode & DIAGLOG_BLOCKING_MODE_POWER_OFF))
                            &&(!(u32BlockingMode & DIAGLOG_BLOCKING_MODE_POWER_NONE)))
                        {
                           (vdDiagLog_tclApp::m_poInstance)->vSetBlockingMode(DIAGLOG_BLOCKING_MODE_MOST_TIMER);
                        }
                     }
                  }
               }
               else //CAN Bus is not active
               {    
                  if ((m_u32InternalSubstateOld & SPM_U32_INTERNAL_SUBSTATE_NETWORK_ACTIVITY) ==  SPM_U32_INTERNAL_SUBSTATE_NETWORK_ACTIVITY) //CAN Bus was Active
                  {
                     if(NULL != vdDiagLog_tclApp::m_poInstance)
                     {
                        (vdDiagLog_tclApp::m_poInstance)->vSetBlockingMode(DIAGLOG_BLOCKING_MODE_HS_COMM_ENABLE_NOT_ACTIVE|DIAGLOG_BLOCKING_MODE_MOST_TIMER);
                        (tVoid) (vdDiagLog_tclApp::m_poInstance)->bStopBlockTimer(DIAGLOG_BLOCKING_MODE_MOST_TIMER);
                     }
                  }
               }// else //CAN Bus is not active

               m_u32InternalSubstateOld = u32InternalSubState;
               break;
            }// case AMT_C_U8_CCAMSG_OPCODE_STATUS:

            default:
            {
               // FID SystemState knows only the status OpCode 
               break;
            }
         } // switch (poMessage->u8GetOpCode())
         (tVoid) poMessage->bDelete();
      }//if(m_poGWMain != NULL)
   }// if(poMessage != NULL)

   ETG_TRACE_USR3_THR(( "<-- vdDiagLog_tclService::vOnHandleSpmSubstateHandlingEvent"));
}
#endif



/*************************************************************************
*
*  FUNCTION:    dia_tclSpmClientHandler::vOnHandleSysStateEvent
*
*
*   DESCRIPTION: react on messages with FID = CFC_SPMFI_C_U16_SYSSTATE
*
*
*   PARAMETER:   amt_tclServiceData* poMessage
*
*   RETURNVALUE: NONE
*
*
*
*
*************************************************************************/
tVoid vdDiaglog_tclclienthandlerspm::vOnHandleSysStateEvent(amt_tclServiceData* /*poMessage*/) const
{
   ETG_TRACE_USR3_THR(( "<-- vdDiagLog_tclService::vOnHandleSysStateEvent"));
#if 0
   // Msg must come from a server
   NORMAL_M_ASSERT(poMessage->bIsServerMessage() == TRUE);

   if(poMessage != NULL)
   {
      if(m_poGWMain != NULL)
      {
         switch (poMessage->u8GetOpCode())
         {
            case AMT_C_U8_CCAMSG_OPCODE_STATUS:
            {    
               #ifdef DIAGLOG_BLOCKING_MODE_NGI_SYS_STATE_SLEEP 
                  fi_tclVisitorMessage oResultMsg(poMessage);
                
                  cfc_spmfi_tclMsgSysStateStatus oCompResp;

                  if (oResultMsg.s32GetData(oCompResp, MIDW_DIAGLOGFI_C_U16_SERVICE_MAJORVERSION) == OSAL_ERROR)
                  {
                     NORMAL_M_ASSERT_ALWAYS ();
                  }

                  cfc_fi_tcl_SPM_e32_SYS_STATE::tenType enSysState = oCompResp.SysState.enType;

                  //Check wether NGI Sytsem State = sleep = true
                  if (enSysState  ==  cfc_fi_tcl_SPM_e32_SYS_STATE::FI_EN_SPM_U32_SYSSTATE_SLEEP) 
                    //!= cfc_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_MOST_RING_ACTIVE 
                  {
                     //  ETG_TRACE_USR4(( "Setting Blocking Mode NGI System State Sleep"));
                     if(NULL != vdDiagLog_tclApp::m_poInstance)
                     {
                        (vdDiagLog_tclApp::m_poInstance)->vSetBlockingMode(DIAGLOG_BLOCKING_MODE_NGI_SYS_STATE_SLEEP);
                     }
                  }
                  else
                  {    
                     //  ETG_TRACE_USR4(( "Resetting Blocking Mode NGI System State Sleep"));
                     if(NULL != vdDiagLog_tclApp::m_poInstance)
                     {
                        (vdDiagLog_tclApp::m_poInstance)->vResetBlockingMode(DIAGLOG_BLOCKING_MODE_NGI_SYS_STATE_SLEEP);  
                     }
                  }
               #endif
               break;
            }// case AMT_C_U8_CCAMSG_OPCODE_STATUS:

            default:
            {
               // FID SystemState knows only the status OpCode 
               break;
            }
         } // switch (poMessage->u8GetOpCode())
         (tVoid) poMessage->bDelete();
      }//if(m_poGWMain != NULL)
   }// if(poMessage != NULL)
#endif
   ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSysStateEvent"));
}

/*************************************************************************
*
*  FUNCTION:    dia_tclSpmClientHandler::vOnHandleSystemPowerMode
*
*
*   DESCRIPTION: react on messages with FID = FID_SPM_SYSTEM_POWER_MODE
*
*
*   PARAMETER:   amt_tclServiceData* poMessage
*
*   RETURNVALUE: NONE
*
*
*
*
*************************************************************************/
tVoid vdDiaglog_tclclienthandlerspm::vOnHandleSystemPowerModeEvent(amt_tclServiceData* poMessage)
{

   ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode"));
   if(poMessage == nullptr)
   {
      NORMAL_M_ASSERT_ALWAYS ();
      return;
   }
	  // Msg must come from a server
	  NORMAL_M_ASSERT(poMessage->bIsServerMessage() == TRUE); //Coverity Fix:(CID 17149)

      if(vdDiagLog_tclApp::m_poInstance != NULL)
      {
         switch (poMessage->u8GetOpCode())
         {
            case AMT_C_U8_CCAMSG_OPCODE_STATUS:
            {                 
               fi_tclVisitorMessage oResultMsg(poMessage);            
               spm_corefi_tclMsgSysPwrModeStatus oCompResp;
               if (oResultMsg.s32GetData(oCompResp, MIDW_DIAGLOGFI_C_U16_SERVICE_MAJORVERSION) == OSAL_ERROR)
               {
                  NORMAL_M_ASSERT_ALWAYS ();
               }

               spm_fi_tcl_SPM_e32_SYSPWRMODE::tenType enSystemPowerMode = oCompResp.SysPwrMode.enType;

               ETG_TRACE_USR4(( "\t\t\t\t\t\t\t\t u8SystemPowerMode: %x, %x ", enSystemPowerMode, _enLastPowerMode ));
               switch (enSystemPowerMode)
               {
                  case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_OFF: //IgnitionInOff
                  {
                     // #############
                     // ### ENTER ###
                     // #############

                     // #############
                     // ### LEFT  ###
                     // #############
                	  ETG_TRACE_COMP_THR(("--- vdDiagLog_tclService::vOnHandleSystemPowerMode ==> IGNITION OFF"));
                	  if(NULL != vdDiagLog_tclApp::m_poInstance)
                	  {
                		  (vdDiagLog_tclApp::m_poInstance)->vSetBlockingMode(DIAGLOG_BLOCKING_MODE_IGNITION_OFF);
                	  }
					  ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 1"));
                     if(  (_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_RUN)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_ACCESSORY)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_CRANK)
                       )
                     {
                        // we left ACC now
						  ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 2"));
                        (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(DIAGLOG_EVENT_ACC_CYCLE_END);
                     }

                     if(  (_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_RUN)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_CRANK)
                       )
                     {
                        // we left ignition now
						  ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 3"));
                        (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(DIAGLOG_EVENT_IGNITION_CYCLE_END);
                     }
                     if(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_CRANK)
                     {
                        // we left crank now
                        (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(DIAGLOG_EVENT_CRANK_CYCLE_END);
                     }
                     // store last Powermode
                     _enLastPowerMode = enSystemPowerMode;
                     break;
                  }

                  case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_ACCESSORY: //IgnitionInAccessory
                  {
                     // #############
                     // ### ENTER ###
                     // #############
					  ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 4.0"));

                     if(  (_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_UNDEFINED)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_OFF)
                       )
                     {
                        // we enter ACC now
						  ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 4"));
                        (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(DIAGLOG_EVENT_ACC_CYCLE_START);
                     }
                     // #############
                     // ### LEFT  ###
                     // #############
                     if(  (_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_RUN)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_CRANK)
                       )
                     {
                        // we left ignition now
						  ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 5"));
                        (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(DIAGLOG_EVENT_IGNITION_CYCLE_END);
                     }
                     if(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_CRANK)
                     {
                        // we left ignition now
                        (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(DIAGLOG_EVENT_CRANK_CYCLE_END);
                     }
                     // store last Powermode 
                     _enLastPowerMode = enSystemPowerMode;
                     break;
                  }

                  case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_RUN: //IgnitionInRun
                  {
                     // #############
                     // ### ENTER ###
                     // #############
                	  ETG_TRACE_COMP_THR(("--- vdDiagLog_tclService::vOnHandleSystemPowerMode ==> IGNITION ON"));
                	  if(NULL != vdDiagLog_tclApp::m_poInstance)
                	  {
                		  (vdDiagLog_tclApp::m_poInstance)->vResetBlockingMode(DIAGLOG_BLOCKING_MODE_IGNITION_OFF);
                	  }
					  ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 6"));
                     if(  (_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_UNDEFINED)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_OFF)
                       )
                     {
                        // we reach ACC now
						 ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 7"));
                        (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(DIAGLOG_EVENT_ACC_CYCLE_START);
                     }

                     if(  (_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_UNDEFINED)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_OFF)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_ACCESSORY)
                       )
                     {
                        // we reach RUN now
						 ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 8"));
                        (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(DIAGLOG_EVENT_IGNITION_CYCLE_START);
                     }
                     if(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_CRANK)
                     {
                        // we reach ACC now
                        (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(DIAGLOG_EVENT_CRANK_CYCLE_END);
                     }
                     // store last Powermode 
                     _enLastPowerMode = enSystemPowerMode;
                     break;
                  }

                  case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_CRANK: //IgnitionInCrank
                  {
                     // #############
                     // ### ENTER ###
                     // #############
					  ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 9"));
                     if(  (_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_UNDEFINED)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_OFF)
                       )
                     {
                        // we reach ACC now
						 ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 10"));
                        (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(DIAGLOG_EVENT_ACC_CYCLE_START);
                     }

                     if(  (_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_UNDEFINED)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_OFF)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_ACCESSORY)
                       )
                     {
                        // we reach RUN now
						 ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 11"));
                        (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(DIAGLOG_EVENT_IGNITION_CYCLE_START);
                     }

                     if(  (_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_UNDEFINED)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_OFF)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_ACCESSORY)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_RUN)
                       )
                     {
                        // we reach CRANK now
						 ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 12"));
                        (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(DIAGLOG_EVENT_CRANK_CYCLE_START);
                     }
                     // store last Powermode 
                     _enLastPowerMode = enSystemPowerMode;
                     break;
                  }

                  case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_UNDEFINED:
                  default:
                  {
                     // this state is for none info or no valid Info of PowerState, which should be handled equal

                     // #############
                     // ### ENTER ###
                     // #############

                     // #############
                     // ### LEFT  ###
                     // #############
					  ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 13"));
                     if(  (_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_CRANK)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_RUN)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_ACCESSORY)
                       )
                     {
                        // we left ACC now
						 ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 14"));
                        (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(DIAGLOG_EVENT_ACC_CYCLE_END);
                     }

                     if(  (_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_CRANK)
                        ||(_enLastPowerMode == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_RUN)
                       )
                     {
                        // we left RUN now
						 ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclService::vOnHandleSystemPowerMode -- 15"));
                        (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(DIAGLOG_EVENT_IGNITION_CYCLE_END);
                     }
                     // so it is not possible to set the _enLastPowerMode after the switch end
                     _enLastPowerMode = spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_UNDEFINED;
                     break;
                  }
               }// switch (u8SystemPowerMode)

               break;
            }// case AMT_C_U8_CCAMSG_OPCODE_STATUS:

            default:
            {
               // FID SystemState knows only the status OpCode 
               break;
            }
      } // switch (poMessage->u8GetOpCode())
      (tVoid) poMessage->bDelete();
   }//if(m_poGWMain != NULL)

   ETG_TRACE_USR3_THR(( "<-- vdDiagLog_tclService::vOnHandleSystemPowerMode"));
}





