//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_main_prj.h
// PROJECT:      GEN2(Next GEN,MY13)
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog MainPrj class - Project Depending settings
//              Protocol, Plugins ...
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 08.08.12  | BSOT Plischke                | Initial version
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main_prj
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main_prj

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_plugin_includes
   /* --Includes. */
   #include <project/plugin/vd_diaglog_plugin_includes.h>
#endif

#include "org/bosch/cm/diagnosis/dbus/DiaglogStub.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_VD_DIAGLOG_DTC_CONFIGURATION_CHECK__
#include "project/framework/dtcConfiguration/vd_diaglog_dtcConfigurationChk.h"
#endif

// forward declaration
class vdDiagLog_tclApp; //lint !e763 Info 763 , eliminating lint warnings Redundant declaration for symbol
class vd_diaglog_CMCDm1Manager;
using namespace ::org::bosch::cm::diagnosis::dbus::Diaglog;
class vdDiagLog_tclAppPrj
{
public:
   static vdDiagLog_tclApp* theServerPrj(DiaglogStub*);
protected:
   vdDiagLog_tclAppPrj();
   virtual ~vdDiagLog_tclAppPrj();

   // member variables
public:
	//vdl_tclDTCTriggerBase*     m_poReportDtcTriggerPlugIn;
	//vdl_tclEolUpdate*          m_poReportEolUpdatePlugIn;
    vdl_tclCanIf*          m_poCanIF;
   vd_diaglog_CMCDm1Manager* m_poReportDtcDM1TriggerPlugIn;
	
	dtcConfigurationChk*  m_poDtcCfgChk;

  // member functions
protected:
   bool bCreatePrjSpecificConfiguration(vdDiagLog_tclApp* poMain);
   tVoid vDestroyPrjSpecificConfiguration();

protected:
   static DiaglogStub* m_poDiaglogStub;
//   vdl_tclASFPlugin*    m_poASFPlugin; //coverity fix:127085:unused non static data member.
   vdl_tclNotificationPlugin* m_poNotificationPlugin;
};

#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main_prj
