/* project dependend ITC defines */
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_itc_definition_project
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_itc_definition_project
// MCAN
#define ITC_AIVI_MCAN_START                                 0x8000
#define ITC_AIVI_MCAN_METER_AUD_COM_ERR                              0x8000
#define ITC_AIVI_MCAN_METER_SWC_COM_ERR                              0x8001
#define ITC_AIVI_MCAN_METER_NAV_COM_ERR                              0x8002
#define ITC_AIVI_MCAN_INITIALISATION_ERROR                           0x8003
#define ITC_AIVI_MCAN_BUS_OFF                                        0x8004
#define ITC_AIVI_MCAN_METER_AUD_CMF_MUTE_ERR                         0x8005
#define ITC_AIVI_MCAN_METER_SWC_CMF_MUTE_ERR                         0x8006
#define ITC_AIVI_MCAN_METER_NAV_CMF_MUTE_ERR                         0x8007
#define ITC_AIVI_MCAN_METER_AUD_MPDT_MUTE_ERR                        0x8008
#define ITC_AIVI_MCAN_METER_SWC_MPDT_MUTE_ERR                        0x8009
#define ITC_AIVI_MCAN_METER_NAV_MPDT_MUTE_ERR                        0x800A
#define ITC_AIVI_MCAN_TCU_COM_ERR                                    0x800B
#define ITC_AIVI_MCAN_BOSE_COM_ERR                                   0x800C
#define ITC_AIVI_MCAN_RSE_COM_ERR                                    0x800D
#define ITC_AIVI_MCAN_TCU_CMF_MUTE_ERR                               0x800E
#define ITC_AIVI_MCAN_BOSE_CMF_MUTE_ERR                              0x800F
#define ITC_AIVI_MCAN_RSE_CMF_MUTE_ERR                               0x8010
#define ITC_AIVI_MCAN_TCU_MPDT_MUTE_ERR                              0x8011
#define ITC_AIVI_MCAN_BOSE_MPDT_MUTE_ERR                             0x8012
#define ITC_AIVI_MCAN_RSE_MPDT_MUTE_ERR                              0x8013
#define ITC_AIVI_MCAN_AVM_COM_ERR                                    0x8014
#define ITC_AIVI_MCAN_AVM_CMF_MUTE_ERR                               0x8015
#define ITC_AIVI_MCAN_AVM_MPDT_MUTE_ERR                              0x8016
#define ITC_AIVI_MCAN_AMP_COM_ERR                                    0x8017
#define ITC_AIVI_MCAN_AMP_CMF_MUTE_ERR                               0x8018
#define ITC_AIVI_MCAN_AMP_MPDT_MUTE_ERR                              0x8019
#define ITC_AIVI_MCAN_SWITCH_COM_ERR                                 0x801A
#define ITC_AIVI_MCAN_SWITCH_CMF_MUTE_ERR                            0x801B
#define ITC_AIVI_MCAN_SWITCH_MPDT_MUTE_ERR                           0x801C
#define ITC_AIVI_MCAN_REAR_SW_COM_ERR                                0x801D
#define ITC_AIVI_MCAN_REAR_SW_CMF_MUTE_ERR                           0x801E
#define ITC_AIVI_MCAN_REAR_SW_MPDT_MUTE_ERR                          0x801F
#define ITC_AIVI_MCAN_ISP_CMF_MUTE_ERR                               0x8020
#define ITC_AIVI_MCAN_ISP_MPDT_MUTE_ERR                              0x8021
#define ITC_AIVI_MCAN_RCS_CMF_MUTE_ERR                               0x8022
#define ITC_AIVI_MCAN_RCS_MPDT_MUTE_ERR                              0x8023
#define ITC_AIVI_MCAN_IT_COMM_COM_ERR                                0x8024
#define ITC_AIVI_MCAN_IT_COMM_CMF_MUTE_ERR                           0x8025
#define ITC_AIVI_MCAN_IT_COMM_MPDT_MUTE_ERR                          0x8026
#define ITC_AIVI_MCAN_METER_AUD_ERROR                                0x8080
#define ITC_AIVI_MCAN_METER_SWC_ERROR                                0x8081
#define ITC_AIVI_MCAN_METER_NAV_ERROR                                0x8082
#define ITC_AIVI_MCAN_METER_NAV_GEN2_COM_ERR                         0x8083
#define ITC_AIVI_MCAN_METER_NAV_GEN2_CMF_MUTE_ERR                    0x8084
#define ITC_AIVI_MCAN_METER_NAV_GEN2_MPDT_MUTE_ERR                   0x8085
#define ITC_AIVI_MCAN_METER_NAV_GEN2_ERROR                           0x8086
#define ITC_CMC_MCAN_BUS_OFF 										 0x8087 // (Center CMC-19 CAN2)
#define ITC_CMC_MCAN_TIME_OUT										 0x8088 // Center CMC-19 MCAN Bus off
#define ITC_AIVI_MCAN_END                                0x80FF

// VCAN
#define ITC_AIVI_VCAN_START                              0x8100
#define ITC_AIVI_VCAN_BUS_OFF                                        0x8102   /* 2  */
#define ITC_AIVI_VCAN_MUTE_ERROR                                     0x8103   /* 3  */
#define ITC_AIVI_VCAN_ABSENT_ECM                                     0x8104   /* 4- */
#define ITC_AIVI_VCAN_ABSENT_CLUSTER                                 0x8106   /* 6  */
#define ITC_AIVI_VCAN_ABSENT_BCM                                     0x8107   /* 7  */
#define ITC_AIVI_VCAN_ABSENT_ITM                                     0x810D   /* 13 */
#define ITC_AIVI_VCAN_ABSENT_STRG                                    0x8111   /* 17 */
#define ITC_AIVI_VCAN_ABSENT_USM                                     0x8117   /* 23 */
#define ITC_AIVI_VCAN_ABSENT_SBW_GEN3                                0x812B   /* 43 */
#define ITC_AIVI_VCAN_ABSENT_SONAR                                   0x812C   /* 44 */
#define ITC_AIVI_VCAN_ABSENT_HCM                                     0x8133   /* 51 */
#define ITC_AIVI_VCAN_ABSENT_AVM                                     0x8156   /* 86 */
#define ITC_AIVI_VCAN_AVM_COM_ERR                                    0x8156   /* 86 */
#define ITC_AIVI_VCAN_ABSENT_SBW                                     0x8158   /* 88 */
#define ITC_AIVI_VCAN_ABSENT_SBW_GEN5                                0x8158   /* 88 */
#if 0 //TODO
#else
#define ITC_AIVI_VCAN_ABSENT_COP                                     0x813E   /* 62- */
#endif
#define ITC_CMC_VCAN_BUS_OFF                                         0x8159 //(Center CMC-19 CAN1)
#define ITC_CMC_VCAN_TIME_OUT										 0x8160 //Center CMC-19 VCAN Bus off
#define ITC_AIVI_VCAN_INITIALISATION_ERROR                           0x81FE
#define ITC_AIVI_VCAN_END                                 0x81FF

#define ITC_AIVI_RSE_START                                0x8200
#define ITC_AIVI_RSE_CONN_ERROR                                       0x8200
#define ITC_AIVI_RSE_RR_DISP_UNIT_ERROR                               0x8201
#define ITC_AIVI_RSE_RL_DISP_UNIT_ERROR                               0x8202
#define ITC_AIVI_RSE_RR_DISP_HIGH_TEMP                                0x8203
#define ITC_AIVI_RSE_RL_DISP_HIGH_TEMP                                0x8204
#define ITC_AIVI_RSE_UNIT_ERROR                                       0x8205
#define ITC_AIVI_RSE_HIGH_TEMP                                        0x8206
#define ITC_AIVI_RSE_AUDIO                                            0x8207
#define ITC_AIVI_RSE_END                                  0x82FF

// keyboard
#define ITC_AIVI_KEY_START                                0x8300
#define ITC_AIVI_KEY_FAC_SETUP                                        0x8300
#define ITC_AIVI_KEY_FAC_SOUND                                        0x8301
#define ITC_AIVI_KEY_FAC_LEFT_ENC                                     0x8302
#define ITC_AIVI_KEY_FAC_RADIO                                        0x8303
#define ITC_AIVI_KEY_FAC_MEDIA                                        0x8304
#define ITC_AIVI_KEY_FAC_MENU                                         0x8305
#define ITC_AIVI_KEY_FAC_CAR                                          0x8306
#define ITC_AIVI_KEY_FAC_MUTE                                         0x8307
#define ITC_AIVI_KEY_FAC_PHONE                                        0x8308
#define ITC_AIVI_KEY_FAC_EJECT                                        0x8309
#define ITC_AIVI_KEY_FAC_AM_FM                                        0x830A
#define ITC_AIVI_KEY_FAC_TP                                           0x830B
#define ITC_AIVI_KEY_DEV_FACEPLATE                                    0x830C
#define ITC_AIVI_KEY_DEV_SWC                                          0x830D
#define ITC_AIVI_KEY_DEV_POWER                                        0x830E
#define ITC_AIVI_KEY_DEV_EJECT                                        0x830F
#define ITC_AIVI_KEY_END                                 0x83FF

// Calibration (Programming failure/Not programmed)
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_START           0x8400
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_00                        0x8400
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_01                        0x8401
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_02                        0x8402
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_03                        0x8403
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_04                        0x8404
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_05                        0x8405
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_06                        0x8406
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_07                        0x8407
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_08                        0x8408
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_09                        0x8409
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_0A                        0x840A
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_0B                        0x840B
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_0C                        0x840C
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_0D                        0x840D
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_0E                        0x840E
#define ITC_AIVI_CAL_PROGRAMMING_FAILURE_END             0x84FF

// Calibration (system int. failures/General mem.failure)
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_START            0x8500
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_00                         0x8500
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_01                         0x8501
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_02                         0x8502
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_03                         0x8503
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_04                         0x8504
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_05                         0x8505
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_06                         0x8506
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_07                         0x8507
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_08                         0x8508
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_09                         0x8509
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0A                         0x850A
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0B                         0x850B
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0C                         0x850C
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0D                         0x850D
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0E                         0x850E
#define ITC_AIVI_CAL_SYSTEM_INT_FAILURE_END              0x85FF

// Calibration (algorithm based failures)
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_START       0x8600
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_00                    0x8600
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_01                    0x8601
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_02                    0x8602
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_03                    0x8603
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_04                    0x8604
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_05                    0x8605
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_06                    0x8606
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_07                    0x8607
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_08                    0x8608
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_09                    0x8609
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0A                    0x860A
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0B                    0x860B
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0C                    0x860C
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0D                    0x860D
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0E                    0x860E
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_END         0x86FF

// keyboard VCAN/MCAN � DiagMuxDTC

#define ITC_AIVI_DIAGMUX_START                           0x8700
#define ITC_AIVI_DIAGMUX_VCAN_BUS_OFF                                 0x8700
#define ITC_AIVI_DIAGMUX_VCAN_AUT_TRAN_LOST_COM                       0x8701
#define ITC_AIVI_DIAGMUX_VCAN_CLUSTER_LOST_COM                        0x8702
#define ITC_AIVI_DIAGMUX_VCAN_BCM_LOST_COM                            0x8703
#define ITC_AIVI_DIAGMUX_VCAN_E_POW_STEER_LOST_COM                    0x8704
#define ITC_AIVI_DIAGMUX_VCAN_E_STAB_CON_LOST_COM                     0x8705
#define ITC_AIVI_DIAGMUX_VCAN_UN_SWITCH_MOD_LOST_COM                  0x8706
#define ITC_AIVI_DIAGMUX_VCAN_FR_CAMERA_LOST_COM                      0x8707
#define ITC_AIVI_DIAGMUX_VCAN_INT_DYN_CON_LOST_COM                    0x8708
#define ITC_AIVI_DIAGMUX_VCAN_ULT_SON_ADAS_LOST_COM                   0x8709
#define ITC_AIVI_DIAGMUX_VCAN_FOUR_WHEEL_ST_LOST_COM                  0x870A
#define ITC_AIVI_DIAGMUX_VCAN_AVM_LOST_COM                            0x870B
#define ITC_AIVI_DIAGMUX_VCAN_HAND_FREE_MOD_LOST_COM                  0x870C
#define ITC_AIVI_DIAGMUX_VCAN_CLIM_CONTROL_LOST_COM                   0x870D
#define ITC_AIVI_DIAGMUX_VCAN_HUD_LOST_COM                            0x870E
#define ITC_AIVI_DIAGMUX_VCAN_TCU_LOST_COM                            0x870F
#define ITC_AIVI_DIAGMUX_VCAN_AIRBAG_CONT_LOST_COM                    0x8710
#define ITC_AIVI_DIAGMUX_VCAN_ADV_DRIV_ASSIST_LOST_COM                0x8711
#define ITC_AIVI_DIAGMUX_VCAN_BL_SPOT_WARN_LOST_COM                   0x8712
#define ITC_AIVI_DIAGMUX_VCAN_ENG_CONT_MOD_LOST_COM                   0x8713
#define ITC_AIVI_DIAGMUX_VCAN_HYBR_ELEC_VEH_LOST_COM                  0x8714
#define ITC_AIVI_DIAGMUX_VCAN_SCENE_REC_LOST_COM                      0x8715
#define ITC_AIVI_DIAGMUX_VCAN_AUT_DRI_SEAT_LOST_COM                   0x8716
#define ITC_AIVI_DIAGMUX_MCAN_CENT_PAN_LOST_COM                       0x8717
#define ITC_AIVI_DIAGMUX_PASSENGER_SEAT_LOST_COM                      0x8718
#define ITC_AIVI_DIAGMUX_CLUSTER_LOST_COM                             0x8719
#define ITC_AIVI_DIAGMUX_AMP_LOST_COM                                 0x871A
#define ITC_AIVI_DIAGMUX_AMP_V1_CAN_LOST_COM                          0x871B
#define ITC_AIVI_DIAGMUX_V_DIST_LOST_COM                              0x871C
#define ITC_AIVI_DIAGMUX_TELEMATICS_CONTROL_LOST_COM                  0x871D
#define ITC_AIVI_DIAGMUX_GATEWAY_LOST_COM                             0x871E
#define ITC_AIVI_DIAGMUX_GATEWAY_ERROR_COM                            0x871F
#define ITC_AIVI_DIAGMUX_END                            0x87FF

#define ITC_AIVI_PART_AUTH_START                        0x8800
#define ITC_AIVI_PART_AUTH_VNEXT_MASTER_AUTH_NOK                      0x8800
#define ITC_AIVI_PART_AUTH_VNEXT_REGIONAL_AUTH_NOK                    0x8801
#define ITC_AIVI_PART_AUTH_VNEXT_MASTER_TIMEOUT                       0x8802
#define ITC_AIVI_PART_AUTH_VNEXT_REGIONAL_TIMEOUT                     0x8803
#define ITC_AIVI_PART_AUTH_UNKNOWN_PART_ID                            0x8804
#define ITC_AIVI_PART_AUTH_BAD_PAIRING_AIVI_VIN                       0x8805
#define ITC_AIVI_PART_AUTH_NO_CERTIFICATE_AVAILABLE                   0x8806
#define ITC_AIVI_PART_AUTH_CERTIFICATE_VERIFICATION_FAILS             0x8807
#define ITC_AIVI_PART_AUTH_CERTIFICATE_STORAGE_ERROR                  0x8808
#define ITC_AIVI_PART_AUTH_AIVI_AUTHENTICATION_FAILS                  0x8809
#define ITC_AIVI_PART_AUTH_AIVI_NO_REGION_SETTING                     0x880A
#define ITC_AIVI_PART_AUTH_AIVI_INVALID_REGION_SETTING                0x880B
#define ITC_AIVI_PART_AUTH_REGION_SETTING_STORAGE_ERROR               0x880C
#define ITC_AIVI_PART_AUTH_AIVI_NO_PARTITION_SETTING                  0x880D
#define ITC_AIVI_PART_AUTH_AIVI_INVALID_PARTITION_SETTING             0x880E
#define ITC_AIVI_PART_AUTH_PARTITION_SETTING_STORAGE_ERROR            0x880F
#define ITC_AIVI_PART_AUTH_SERVICE_CHECK_NOT_COMPLETE                 0x8810
#define ITC_AIVI_CELLULAR_TLS_SESSION_ERROR                           0x8811
#define ITC_AIVI_CELLULAR_VNEXT_CONFIGURATION_DISCARDED               0x8812
#define ITC_AIVI_CELLULAR_INVALID_AIVI_CERTIFICATE                    0x8813
#define ITC_AIVI_PART_AUTH_END                         0x88FF



// diverse
#define ITC_AIVI_DIVERSE_START                              0x9000
#define ITC_AIVI_BCAS_COMM_FAILURE                                   0x9000
#define ITC_AIVI_BOSE_AMP_TEMP_ERROR                                 0x9001
#define ITC_AIVI_ANGLE_SENSOR_CALIBRATION                            0x9002
#define ITC_AIVI_BEACON_UNIT_COMM_FAILURE                            0x9003
#define ITC_AIVI_DSRC_UNIT_COMM_FAILURE                              0x9004
#define ITC_AIVI_AMP_UNIT_COMM_FAILURE                               0x9005
#define ITC_AIVI_USB_TCU_COM_ERR                                     0x9006
#define ITC_AIVI_USB_TCU_OPEN                                        0x9007
#define ITC_AIVI_FACTORY_MODE                                        0x9008
#define ITC_AIVI_INT_DTV_HIGH_TEMP                                   0x9009
#define ITC_AIVI_EXT_DTV_HIGH_TEMP                                   0x900A
#define ITC_AIVI_EXT_DTV_UART_COM_ERR                                0x900B
#define ITC_AIVI_EXT_UART_OVERLOAD                                   0x900C
#define ITC_AIVI_EXT_DTV_OPERATION_FAILURE                           0x900D
#define ITC_AIVI_EXT_DTV_LVDS_SERIALIZER_COM_FAILURE                 0x900E
#define ITC_AIVI_ETC_SELF_DIAGNOSIS_FAILURE                          0x900F
#define ITC_AIVI_DTV_BOX_OVERCURRENT                   				 0x9010
#define ITC_AIVI_2ND_DISPLAY_CONN_ERROR                              0x9011
#define ITC_AIVI_REAR_SWITCH_CONN_ERROR                              0x9012
#define ITC_AIVI_INTEGRATED_SWITCH_CONN_ERROR                        0x9013
#define ITC_AIVI_AMP_UNIT_CH1_COMM_FAILURE                           0x9015
#define ITC_AIVI_AMP_UNIT_CH2_COMM_FAILURE                           0x9016
#define ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE                  0x9017
#define ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_BACKLIGHT        0x9018
#define ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_ROM              0x9019
#define ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_TFT              0x901A
#define ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_LVDS             0x901B
#define ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_TOUCH            0x901C
#define ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_BUTTONS          0x901D
#define ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_HVAC             0x901E
#define ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_IT_COMM          0x901F
#define ITC_AIVI_DIVERSE_END                                0x90FF

/*LVDS Failures*/
#define ITC_LVDS_START                                    0x9100
#define ITC_LVDS_IN_MEDIA_COMM_FAILURE                               0x9100
#define ITC_LVDS_IN_CAMERA_COMM_FAILURE                              0x9101
#define ITC_LVDS_OUT_CP_LINE_COMM_FAILURE                            0x9102
#define ITC_LVDS_OUT_CP_LINE_I2C_TIMEOUT                             0x9103
#define ITC_LVDS_OUT_SECOND_DISPLAY_COMM_FAILURE                     0x9104
#define ITC_LVDS_OUT_SECOND_DISPLAY_I2C_TIMEOUT                      0x9105
#define ITC_LVDS_OUT_RSE_COMM_FAILURE                                0x9106
#define ITC_LVDS_IN_DTV_BOX_COMM_FAILURE                             0x9107
#define ITC_LVDS_END                                      0x91FF

//SPEAKER A-IVI -- LAST NIBBLE OF DTC
#define SHORT_STD       0x0
#define SHORT2GND       0x1
#define SHORT2BAT       0x2
#define OPEN_LOAD       0x3
#define SHORT_CIR       0xA

//SPEAKER A-IVI -- BASE ITC
#define ITC_AIVI_SPEAKER_START                              0xA000
#define ITC_AIVI_FL_DOOR_SPEAKER                                       0xA000
#define ITC_AIVI_FL_DOOR_WOOFER                                        0xA010
#define ITC_AIVI_FL_DOOR_SQUAWKER                                      0xA020
#define ITC_AIVI_FL_DOOR_TWEETER                                       0xA030
#define ITC_AIVI_FR_DOOR_SPEAKER                                       0xA040
#define ITC_AIVI_FR_DOOR_WOOFER                                        0xA050
#define ITC_AIVI_FR_DOOR_SQUAWKER                                      0xA060
#define ITC_AIVI_FR_DOOR_TWEETER                                       0xA070
#define ITC_AIVI_F_INST_L_SPEAKER                                      0xA080
#define ITC_AIVI_F_INST_L_WOOFER                                       0xA090
#define ITC_AIVI_F_INST_L_SQUAWKER                                     0xA0A0
#define ITC_AIVI_F_INST_L_TWEETER                                      0xA0B0
#define ITC_AIVI_F_INST_C_SPEAKER                                      0xA0C0
#define ITC_AIVI_F_INST_C_WOOFER                                       0xA0D0
#define ITC_AIVI_F_INST_C_SQUAWKER                                     0xA0E0
#define ITC_AIVI_F_INST_C_TWEETER                                      0xA0F0
#define ITC_AIVI_F_INST_R_SPEAKER                                      0xA100
#define ITC_AIVI_F_INST_R_WOOFER                                       0xA110
#define ITC_AIVI_F_INST_R_SQUAWKER                                     0xA120
#define ITC_AIVI_F_INST_R_TWEETER                                      0xA130
#define ITC_AIVI_FL_SEAT_L_SPEAKER                                     0xA140
#define ITC_AIVI_FL_SEAT_L_WOOFER                                      0xA150
#define ITC_AIVI_FL_SEAT_L_SQUAWKER                                    0xA160
#define ITC_AIVI_FL_SEAT_L_TWEETER                                     0xA170
#define ITC_AIVI_FL_SEAT_C_SPEAKER                                     0xA180
#define ITC_AIVI_FL_SEAT_C_WOOFER                                      0xA190
#define ITC_AIVI_FL_SEAT_C_SQUAWKER                                    0xA1A0
#define ITC_AIVI_FL_SEAT_C_TWEETER                                     0xA1B0
#define ITC_AIVI_FL_SEAT_R_SPEAKER                                     0xA1C0
#define ITC_AIVI_FL_SEAT_R_WOOFER                                      0xA1D0
#define ITC_AIVI_FL_SEAT_R_SQUAWKER                                    0xA1E0
#define ITC_AIVI_FL_SEAT_R_TWEETER                                     0xA1F0
#define ITC_AIVI_FR_SEAT_L_SPEAKER                                     0xA200
#define ITC_AIVI_FR_SEAT_L_WOOFER                                      0xA210
#define ITC_AIVI_FR_SEAT_L_SQUAWKER                                    0xA220
#define ITC_AIVI_FR_SEAT_L_TWEETER                                     0xA230
#define ITC_AIVI_FR_SEAT_C_SPEAKER                                     0xA240
#define ITC_AIVI_FR_SEAT_C_WOOFER                                      0xA250
#define ITC_AIVI_FR_SEAT_C_SQUAWKER                                    0xA260
#define ITC_AIVI_FR_SEAT_C_TWEETER                                     0xA270
#define ITC_AIVI_FR_SEAT_R_SPEAKER                                     0xA280
#define ITC_AIVI_FR_SEAT_R_WOOFER                                      0xA290
#define ITC_AIVI_FR_SEAT_R_SQUAWKER                                    0xA2A0
#define ITC_AIVI_FR_SEAT_R_TWEETER                                     0xA2B0
#define ITC_AIVI_FL_PILLAR_SPEAKER                                     0xA2C0
#define ITC_AIVI_FL_PILLAR_WOOFER                                      0xA2D0
#define ITC_AIVI_FL_PILLAR_SQUAWKER                                    0xA2E0
#define ITC_AIVI_FL_PILLAR_TWEETER                                     0xA2F0
#define ITC_AIVI_FR_PILLAR_SPEAKER                                     0xA300
#define ITC_AIVI_FR_PILLAR_WOOFER                                      0xA310
#define ITC_AIVI_FR_PILLAR_SQUAWKER                                    0xA320
#define ITC_AIVI_FR_PILLAR_TWEETER                                     0xA330
#define ITC_AIVI_F_CONSOLE_C_SPEAKER                                   0xA340
#define ITC_AIVI_F_CONSOLE_C_WOOFER                                    0xA350
#define ITC_AIVI_F_CONSOLE_C_SQUAWKER                                  0xA360
#define ITC_AIVI_F_CONSOLE_C_TWEETER                                   0xA370
#define ITC_AIVI_2L_DOOR_SPEAKER                                       0xA380
#define ITC_AIVI_2L_DOOR_WOOFER                                        0xA390
#define ITC_AIVI_2L_DOOR_SQUAWKER                                      0xA3A0
#define ITC_AIVI_2L_DOOR_TWEETER                                       0xA3B0
#define ITC_AIVI_2R_DOOR_SPEAKER                                       0xA3C0
#define ITC_AIVI_2R_DOOR_WOOFER                                        0xA3D0
#define ITC_AIVI_2R_DOOR_SQUAWKER                                      0xA3E0
#define ITC_AIVI_2R_DOOR_TWEETER                                       0xA3F0
#define ITC_AIVI_2_ROOF_L_SPEAKER                                      0xA400
#define ITC_AIVI_2_ROOF_L_WOOFER                                       0xA410
#define ITC_AIVI_2_ROOF_L_SQUAWKER                                     0xA420
#define ITC_AIVI_2_ROOF_L_TWEETER                                      0xA430
#define ITC_AIVI_2_ROOF_C_SPEAKER                                      0xA440
#define ITC_AIVI_2_ROOF_C_WOOFER                                       0xA450
#define ITC_AIVI_2_ROOF_C_SQUAWKER                                     0xA460
#define ITC_AIVI_2_ROOF_C_TWEETER                                      0xA470
#define ITC_AIVI_2_ROOF_R_SPEAKER                                      0xA480
#define ITC_AIVI_2_ROOF_R_WOOFER                                       0xA490
#define ITC_AIVI_2_ROOF_R_SQUAWKER                                     0xA4A0
#define ITC_AIVI_2_ROOF_R_TWEETER                                      0xA4B0
#define ITC_AIVI_RL_DOOR_SPEAKER                                       0xA4C0
#define ITC_AIVI_RL_DOOR_WOOFER                                        0xA4D0
#define ITC_AIVI_RL_DOOR_SQUAWKER                                      0xA4E0
#define ITC_AIVI_RL_DOOR_TWEETER                                       0xA4F0
#define ITC_AIVI_RR_DOOR_SPEAKER                                       0xA500
#define ITC_AIVI_RR_DOOR_WOOFER                                        0xA510
#define ITC_AIVI_RR_DOOR_SQUAWKER                                      0xA520
#define ITC_AIVI_RR_DOOR_TWEETER                                       0xA530
#define ITC_AIVI_R_PSHELF_L_SPEAKER                                    0xA540
#define ITC_AIVI_R_PSHELF_L_WOOFER                                     0xA550
#define ITC_AIVI_R_PSHELF_L_SQUAWKER                                   0xA560
#define ITC_AIVI_R_PSHELF_L_TWEETER                                    0xA570
#define ITC_AIVI_R_PSHELF_C_SPEAKER                                    0xA580
#define ITC_AIVI_R_PSHELF_C_WOOFER                                     0xA590
#define ITC_AIVI_R_PSHELF_C_SQUAWKER                                   0xA5A0
#define ITC_AIVI_R_PSHELF_C_TWEETER                                    0xA5B0
#define ITC_AIVI_R_PSHELF_R_SPEAKER                                    0xA5C0
#define ITC_AIVI_R_PSHELF_R_WOOFER                                     0xA5D0
#define ITC_AIVI_R_PSHELF_R_SQUAWKER                                   0xA5E0
#define ITC_AIVI_R_PSHELF_R_TWEETER                                    0xA5F0
#define ITC_AIVI_RL_PILLAR_SPEAKER                                     0xA600
#define ITC_AIVI_RL_PILLAR_WOOFER                                      0xA610
#define ITC_AIVI_RL_PILLAR_SQUAWKER                                    0xA620
#define ITC_AIVI_RL_PILLAR_TWEETER                                     0xA630
#define ITC_AIVI_RR_PILLAR_SPEAKER                                     0xA640
#define ITC_AIVI_RR_PILLAR_WOOFER                                      0xA650
#define ITC_AIVI_RR_PILLAR_SQUAWKER                                    0xA660
#define ITC_AIVI_RR_PILLAR_TWEETER                                     0xA670
#define ITC_AIVI_R_LUGGAGE_L_SPEAKER                                   0xA680
#define ITC_AIVI_R_LUGGAGE_L_WOOFER                                    0xA690
#define ITC_AIVI_R_LUGGAGE_L_SQUAWKER                                  0xA6A0
#define ITC_AIVI_R_LUGGAGE_L_TWEETER                                   0xA6B0
#define ITC_AIVI_R_LUGGAGE_C_SPEAKER                                   0xA6C0
#define ITC_AIVI_R_LUGGAGE_C_WOOFER                                    0xA6D0
#define ITC_AIVI_R_LUGGAGE_C_SQUAWKER                                  0xA6E0
#define ITC_AIVI_R_LUGGAGE_C_TWEETER                                   0xA6F0
#define ITC_AIVI_R_LUGGAGE_R_SPEAKER                                   0xA700
#define ITC_AIVI_R_LUGGAGE_R_WOOFER                                    0xA710
#define ITC_AIVI_R_LUGGAGE_R_SQUAWKER                                  0xA720
#define ITC_AIVI_R_LUGGAGE_R_TWEETER                                   0xA730
#define ITC_AIVI_R_ROOF_L_SPEAKER                                      0xA740
#define ITC_AIVI_R_ROOF_L_WOOFER                                       0xA750
#define ITC_AIVI_R_ROOF_L_SQUAWKER                                     0xA760
#define ITC_AIVI_R_ROOF_L_TWEETER                                      0xA770
#define ITC_AIVI_R_ROOF_C_SPEAKER                                      0xA780
#define ITC_AIVI_R_ROOF_C_WOOFER                                       0xA790
#define ITC_AIVI_R_ROOF_C_SQUAWKER                                     0xA7A0
#define ITC_AIVI_R_ROOF_C_TWEETER                                      0xA7B0
#define ITC_AIVI_R_ROOF_R_SPEAKER                                      0xA7C0
#define ITC_AIVI_R_ROOF_R_WOOFER                                       0xA7D0
#define ITC_AIVI_R_ROOF_R_SQUAWKER                                     0xA7E0
#define ITC_AIVI_R_ROOF_R_TWEETER                                      0xA7F0
#define ITC_AIVI_B_DOOR_L_SPEAKER                                      0xA800
#define ITC_AIVI_B_DOOR_L_WOOFER                                       0xA810
#define ITC_AIVI_B_DOOR_L_SQUAWKER                                     0xA820
#define ITC_AIVI_B_DOOR_L_TWEETER                                      0xA830
#define ITC_AIVI_B_DOOR_C_SPEAKER                                      0xA840
#define ITC_AIVI_B_DOOR_C_WOOFER                                       0xA850
#define ITC_AIVI_B_DOOR_C_SQUAWKER                                     0xA860
#define ITC_AIVI_B_DOOR_C_TWEETER                                      0xA870
#define ITC_AIVI_B_DOOR_R_SPEAKER                                      0xA880
#define ITC_AIVI_B_DOOR_R_WOOFER                                       0xA890
#define ITC_AIVI_B_DOOR_R_SQUAWKER                                     0xA8A0
#define ITC_AIVI_B_DOOR_R_TWEETER                                      0xA8B0
#define ITC_AIVI_FRONT_LEFT_DOOR_SPEAKER                               0xA8C0
#define ITC_AIVI_FRONT_RIGHT_DOOR_SPEAKER                              0xA8D0
#define ITC_AIVI_REAR_LEFT_DOOR_WOOFER                                 0xA8E0
#define ITC_AIVI_REAR_RIGHT_DOOR_WOOFER                                0xA8F0
#define ITC_AIVI_SPEAKER_END                                0xA8FF

/* A-IVI ANC MIC FOR BOSE -- BASE ITC NUMBER */
#define ITC_AIVI_ANC_MIC_START                              0xA900
#define ITC_AIVI_ANC_MIC1_CIRC                                         0xA900
#define ITC_AIVI_ANC_MIC2_CIRC                                         0xA910
#define ITC_AIVI_ANC_MIC3_CIRC                                         0xA920
#define ITC_AIVI_ANC_MIC4_CIRC                                         0xA930
#define ITC_AIVI_ANC_MIC_END                                0xA9FF

/* A-IVI */
#define ITC_AIVI_X_START                              0xAA00
#define ITC_AIVI_ANC_MICROPHONE_INPUT_CIRCUIT                                 0xAA00
#define ITC_AIVI_ANC_MICROPHONE_INPUT_SIGNAL_1                                0xAA01
#define ITC_AIVI_ANC_MICROPHONE_INPUT_SIGNAL_2                                0xAA02
#define ITC_AIVI_ANC_MICROPHONE_INPUT_SIGNAL_3                                0xAA03
#define ITC_AIVI_ANC_MICROPHONE_INPUT_SIGNAL_4                                0xAA04
#define ITC_AIVI_SELF_DIAGNOSIS_CAN_COMMUNICATION_FAIL_ECM                    0xAA05
#define ITC_AIVI_SELF_DIAGNOSIS_CAN_COMMUNICATION_FAIL_HCM                    0xAA06
#define ITC_AIVI_SELF_DIAGNOSIS_CAN_COMMUNICATION_FAIL_BCM                    0xAA07
#define ITC_AIVI_SELF_DIAGNOSIS_ASC_VOLUME_CONTROL_ECM                        0xAA08
#define ITC_AIVI_SELF_DIAGNOSIS_ASC_VOLUME_CONTROL_HCM                        0xAA09
#define ITC_AIVI_ASC_VOL_CTRL_CAN_COMM_FAIL_ECM_ACCELP_OPEN_ENG_TOR           0xAA0A
#define ITC_AIVI_ASC_VOL_CTRL_CAN_COMM_FAIL_ADAS_ASLSETTING_SPEED             0xAA0B
#define ITC_AIVI_ASC_VOL_CTRL_CAN_COMM_FAIL_CL_VEH_SPEED_ERROR_STD_BOSE       0xAA0C
#define ITC_AIVI_ASC_VOL_CTRL_CAN_COMM_FAIL_HCM_ACCELP_OPEN_ENG_TOR           0xAA0D
#define ITC_AIVI_ASC_VOL_CTRL_CAN_COMM_FAIL_ADAS                              0xAA0E
#define ITC_AIVI_ASC_VOL_CTRL_ANC_STABILITY_CAN_SIGNAL_FAIL_METER             0xAA0F
#define ITC_AIVI_ANC_UNIT_EEPROM_ACCESS_ERROR                                 0xAA10
#define ITC_AIVI_ENGINE_SPEED_SIGNAL_ERROR                                    0xAA11
#define ITC_AIVI_MODE_CHANGE_CAN_COMM_FAIL_DR_MODE_SIG_4CAN                   0xAA12
#define ITC_AIVI_ANC_CTRL_CAN_COMM_FAIL_BCM_DOOR_OPEN_CLOSE                   0xAA13
#define ITC_AIVI_MODE_CHANGE_CAN_COMM_FAIL_IDM                                0xAA14
#define ITC_AIVI_AMP_TEMPERATURE                                              0xAA15
#define ITC_AIVI_AV_COMMUNICATION                                             0xAA16
#define ITC_AIVI_MODE_CHANGE_CAN_COMM_FAIL_TGW                                0xAA17
#define ITC_AIVI_X_END                                0xAAFF

// !!! old mapping (compatibility)                                       0x8200  do not use them for new development !!!
#define VDL_ITC_RSE_CONN_ERROR                     ITC_AIVI_RSE_CONN_ERROR
#define VDL_ITC_RSE_RR_DISP_UNIT_ERROR             ITC_AIVI_RSE_RR_DISP_UNIT_ERROR
#define VDL_ITC_RSE_RL_DISP_UNIT_ERROR             ITC_AIVI_RSE_RL_DISP_UNIT_ERROR
#define VDL_ITC_RSE_RR_DISP_HIGH_TEMP              ITC_AIVI_RSE_RR_DISP_HIGH_TEMP
#define VDL_ITC_RSE_RL_DISP_HIGH_TEMP              ITC_AIVI_RSE_RL_DISP_HIGH_TEMP
#define VDL_ITC_RSE_UNIT_ERROR                     ITC_AIVI_RSE_UNIT_ERROR
#define VDL_ITC_RSE_HIGH_TEMP                      ITC_AIVI_RSE_HIGH_TEMP

#define VDL_ITC_VCAN_BUS_OFF                       ITC_AIVI_VCAN_BUS_OFF
#define VDL_ITC_VCAN_ABSENT_ECM                    ITC_AIVI_VCAN_ABSENT_ECM
#define VDL_ITC_VCAN_ABSENT_VDC                    ITC_AIVI_VCAN_ABSENT_VDC
#define VDL_ITC_VCAN_ABSENT_CLUSTER                ITC_AIVI_VCAN_ABSENT_CLUSTER
#define VDL_ITC_VCAN_ABSENT_BCM                    ITC_AIVI_VCAN_ABSENT_BCM
#define VDL_ITC_VCAN_ABSENT_STRG                   ITC_AIVI_VCAN_ABSENT_STRG
#define VDL_ITC_VCAN_AVM_COM_ERR                   ITC_AIVI_VCAN_AVM_COM_ERR
#define VDL_ITC_VCAN_AVM_CFG_ERR                   ITC_AIVI_VCAN_AVM_CFG_ERR
#define VDL_ITC_VCAN_CONFIG_ERROR                  ITC_AIVI_VCAN_CONFIG_ERROR
#define VDL_ITC_VCAN_MUTE_ERROR                    ITC_AIVI_VCAN_MUTE_ERROR
#define VDL_ITC_VCAN_INITIALISATION_ERROR          ITC_AIVI_VCAN_INITIALISATION_ERROR
#define VDL_ITC_VCAN_ABSENT_USM                    ITC_AIVI_VCAN_ABSENT_USM
#define VDL_ITC_VCAN_ABSENT_COP                    ITC_AIVI_VCAN_ABSENT_COP
#define VDL_ITC_VCAN_ABSENT_RAS                    ITC_AIVI_VCAN_ABSENT_RAS
#define VDL_ITC_VCAN_ABSENT_SBMC                   ITC_AIVI_VCAN_ABSENT_SBMC
#define VDL_ITC_VCAN_ABSENT_TIREP                  ITC_AIVI_VCAN_ABSENT_TIREP
#define VDL_ITC_VCAN_ABSENT_HVAC                   ITC_AIVI_VCAN_ABSENT_HVAC
#define VDL_ITC_VCAN_ABSENT_VCM                    ITC_AIVI_VCAN_ABSENT_VCM
#define VDL_ITC_VCAN_ABSENT_RCV                    ITC_AIVI_VCAN_ABSENT_RCV
#define VDL_ITC_VCAN_ABSENT_SONAR                  ITC_AIVI_VCAN_ABSENT_SONAR
#define VDL_ITC_VCAN_ABSENT_IDM                    ITC_AIVI_VCAN_ABSENT_IDM
#define VDL_ITC_VCAN_ABSENT_TPMS                   ITC_AIVI_VCAN_ABSENT_TPMS
#define VDL_ITC_VCAN_ABSENT_ATCVT                  ITC_AIVI_VCAN_ABSENT_ATCVT
#define VDL_ITC_VCAN_ABSENT_DSC                    ITC_AIVI_VCAN_ABSENT_DSC

#define VDL_ITC_MCAN_METER_AUD_COM_ERR             ITC_AIVI_MCAN_METER_AUD_COM_ERR
#define VDL_ITC_MCAN_METER_SWC_COM_ERR             ITC_AIVI_MCAN_METER_SWC_COM_ERR
#define VDL_ITC_MCAN_METER_NAV_COM_ERR             ITC_AIVI_MCAN_METER_NAV_COM_ERR
#define VDL_ITC_MCAN_INITIALISATION_ERROR          ITC_AIVI_MCAN_INITIALISATION_ERROR
#define VDL_ITC_MCAN_BUS_OFF                       ITC_AIVI_MCAN_BUS_OFF
#define VDL_ITC_MCAN_METER_AUD_CMF_MUTE_ERR        ITC_AIVI_MCAN_METER_AUD_CMF_MUTE_ERR
#define VDL_ITC_MCAN_METER_SWC_CMF_MUTE_ERR        ITC_AIVI_MCAN_METER_SWC_CMF_MUTE_ERR
#define VDL_ITC_MCAN_METER_NAV_CMF_MUTE_ERR        ITC_AIVI_MCAN_METER_NAV_CMF_MUTE_ERR
#define VDL_ITC_MCAN_METER_AUD_MPDT_MUTE_ERR       ITC_AIVI_MCAN_METER_AUD_MPDT_MUTE_ERR
#define VDL_ITC_MCAN_METER_SWC_MPDT_MUTE_ERR       ITC_AIVI_MCAN_METER_SWC_MPDT_MUTE_ERR
#define VDL_ITC_MCAN_METER_NAV_MPDT_MUTE_ERR       ITC_AIVI_MCAN_METER_NAV_MPDT_MUTE_ERR
#define VDL_ITC_MCAN_TCU_COM_ERR                   ITC_AIVI_MCAN_TCU_COM_ERR
#define VDL_ITC_MCAN_BOSE_COM_ERR                  ITC_AIVI_MCAN_BOSE_COM_ERR
#define VDL_ITC_MCAN_RSE_COM_ERR                   ITC_AIVI_MCAN_RSE_COM_ERR
#define VDL_ITC_MCAN_TCU_CMF_MUTE_ERR              ITC_AIVI_MCAN_TCU_CMF_MUTE_ERR
#define VDL_ITC_MCAN_BOSE_CMF_MUTE_ERR             ITC_AIVI_MCAN_BOSE_CMF_MUTE_ERR
#define VDL_ITC_MCAN_RSE_CMF_MUTE_ERR              ITC_AIVI_MCAN_RSE_CMF_MUTE_ERR
#define VDL_ITC_MCAN_TCU_MPDT_MUTE_ERR             ITC_AIVI_MCAN_TCU_MPDT_MUTE_ERR
#define VDL_ITC_MCAN_BOSE_MPDT_MUTE_ERR            ITC_AIVI_MCAN_BOSE_MPDT_MUTE_ERR
#define VDL_ITC_MCAN_RSE_MPDT_MUTE_ERR             ITC_AIVI_MCAN_RSE_MPDT_MUTE_ERR
#define VDL_ITC_MCAN_AVM_COM_ERR                   ITC_AIVI_MCAN_AVM_COM_ERR
#define VDL_ITC_MCAN_AVM_CMF_MUTE_ERR              ITC_AIVI_MCAN_AVM_CMF_MUTE_ERR
#define VDL_ITC_MCAN_AVM_MPDT_MUTE_ERR             ITC_AIVI_MCAN_AVM_MPDT_MUTE_ERR
#define VDL_ITC_MCAN_AMP_COM_ERR                   ITC_AIVI_MCAN_AMP_COM_ERR
#define VDL_ITC_MCAN_AMP_CMF_MUTE_ERR              ITC_AIVI_MCAN_AMP_CMF_MUTE_ERR
#define VDL_ITC_MCAN_AMP_MPDT_MUTE_ERR             ITC_AIVI_MCAN_AMP_MPDT_MUTE_ERR
#define VDL_ITC_MCAN_SWITCH_COM_ERR                ITC_AIVI_MCAN_SWITCH_COM_ERR
#define VDL_ITC_MCAN_SWITCH_CMF_MUTE_ERR           ITC_AIVI_MCAN_SWITCH_CMF_MUTE_ERR
#define VDL_ITC_MCAN_SWITCH_MPDT_MUTE_ERR          ITC_AIVI_MCAN_SWITCH_MPDT_MUTE_ERR
#define VDL_ITC_MCAN_REAR_SW_COM_ERR               ITC_AIVI_MCAN_REAR_SW_COM_ERR
#define VDL_ITC_MCAN_REAR_SW_CMF_MUTE_ERR          ITC_AIVI_MCAN_REAR_SW_CMF_MUTE_ERR
#define VDL_ITC_MCAN_REAR_SW_MPDT_MUTE_ERR         ITC_AIVI_MCAN_REAR_SW_MPDT_MUTE_ERR
#define VDL_ITC_MCAN_ISP_CMF_MUTE_ERR              ITC_AIVI_MCAN_ISP_CMF_MUTE_ERR
#define VDL_ITC_MCAN_ISP_MPDT_MUTE_ERR             ITC_AIVI_MCAN_ISP_MPDT_MUTE_ERR
#define VDL_ITC_MCAN_RCS_CMF_MUTE_ERR              ITC_AIVI_MCAN_RCS_CMF_MUTE_ERR
#define VDL_ITC_MCAN_RCS_MPDT_MUTE_ERR             ITC_AIVI_MCAN_RCS_MPDT_MUTE_ERR

#define VDL_ITC_BOSE_AMP_TEMP_ERROR                ITC_AIVI_BOSE_AMP_TEMP_ERROR

#define DIAGLOG_MEMORY_REPROGRAMMING               DIAGLOG_MEMORY_UNUSED_04

/* CMC-19 ETHERNET */
#define ITC_CMC_ETHERNET_START                              0xAB00
#define ITC_CMC_ETHERNET_NO_COMMUNICATION 					0xAB00
#define ITC_CMC_ETHERNET_END                           		0xABFF

/* CMC-19 TUNER */
#define ITC_CMC_TUNER_START									0xAC00
#define ITC_CMC_AMPLIFIER_INIT_FAILED						0xAC00
#define ITC_CMC_TUNER_SXM_INIT_FAILED						0xAC01
#define ITC_CMC_TUNER_HD_RADIO_INIT_FAILED				    0xAC02
#define ITC_CMC_TUNER_STOP									0xACFF

/* CMC-19 Control Panel (MCP) Keys */
#define ITC_CMC_MCP_KEY_START								0xAD00
#define ITC_CMC_MCP_HOMEBUTTON_KEY_JAM						0xAD01
#define ITC_CMC_MCP_HOME_COCKPIT_KEY_JAM					0xAD02
#define ITC_CMC_MCP_SRC_COCKPIT_KEY_JAM						0xAD03
#define ITC_CMC_MCP_NAV_KEY_JAM								0xAD04
#define ITC_CMC_MCP_MAP_KEY_JAM								0xAD05
#define ITC_CMC_MCP_SRC_CABIN_KEY_JAM						0xAD06
#define ITC_CMC_MCP_HOME_CABIN_KEY_JAM						0xAD07
#define ITC_CMC_MCP_SET_COCKPIT_KEY_JAM						0xAD08
#define ITC_CMC_MCP_CAM_KEY_JAM								0xAD09
#define ITC_CMC_MCP_PHONE_ACCEPT_KEY_JAM					0xAD10
#define ITC_CMC_MCP_PHONE_REJECT_KEY_JAM					0xAD11
#define ITC_CMC_MCP_MON_KEY_JAM								0xAD12
#define ITC_CMC_MCP_SET_CABIN_KEY_JAM						0xAD13
#define ITC_CMC_MCP_VOLUMEBUTTON_COCKPIT_KEY_JAM			0xAD14
#define ITC_CMC_MCP_VOLUMEBUTTON_CABIN_KEY_JAM	 			0xAD15

#define ITC_CMC_MCP_HOMEBUTTON_ILLUMINATION_ERROR			0xAD16
#define ITC_CMC_MCP_HOME_COCKPIT_ILLUMINATION_ERROR			0xAD17
#define ITC_CMC_MCP_SRC_COCKPIT_ILLUMINATION_ERROR			0xAD18
#define ITC_CMC_MCP_NAV_ILLUMINATION_ERROR					0xAD19
#define ITC_CMC_MCP_MAP_ILLUMINATION_ERROR					0xAD20
#define ITC_CMC_MCP_SRC_CABIN_ILLUMINATION_ERROR			0xAD21
#define ITC_CMC_MCP_HOME_CABIN_ILLUMINATION_ERROR			0xAD22
#define ITC_CMC_MCP_SET_COCKPIT_ILLUMINATION_ERROR			0xAD23
#define ITC_CMC_MCP_CAM_ILLUMINATION_ERROR					0xAD24
#define ITC_CMC_MCP_PHONE_ACCEPT_ILLUMINATION_ERROR			0xAD25
#define ITC_CMC_MCP_PHONE_REJECT_ILLUMINATION_ERROR			0xAD26
#define ITC_CMC_MCP_MON_ILLUMINATION_ERROR					0xAD27
#define ITC_CMC_MCP_SET_CABIN_ILLUMINATION_ERROR			0xAD28
#define ITC_CMC_MCP_VOLUMEBUTTON_COCKPIT_ILLUMINATION_ERROR	0xAD29
#define ITC_CMC_MCP_VOLUMEBUTTON_CABIN_ILLUMINATION_ERROR 	0xAD30
#define ITC_CMC_MCP_KEY_STOP								0xADFF

/* CMC-19 Speakers */
#define ITC_CMC_SPEAKER_START								0xAE00
#define ITC_CMC_CABINOUTPUT_SHORT_TO_BATTERY			    0xAE01
#define ITC_CMC_CABINOUTPUT_SHORT_TO_LINES				    0xAE02
#define ITC_CMC_CABINOUTPUT_SHORT_TO_LOAD				    0xAE03
#define ITC_CMC_CABINOUTPUT_SHORT_TO_GROUND				    0xAE04
#define ITC_CMC_PRIVATESPEAKER_OUTPUT_SHORT_TO_BATTERY		0xAE05
#define ITC_CMC_PRIVATESPEAKER_OUTPUT_SHORT_TO_LINES		0xAE06
#define ITC_CMC_PRIVATESPEAKER_OUTPUT_SHORT_TO_LOAD			0xAE07
#define ITC_CMC_PRIVATESPEAKER_OUTPUT_SHORT_TO_GROUND		0xAE08
#define ITC_CMC_SPEAKER_STOP								0xAEFF

//LCM..Continue from core..
#define ITC_CMC_SWITCHABLE_OUTPUT_VOLTAGE_SHORT_TO_BATTERY  0x0904
#define ITC_CMC_SWITCHABLE_OUTPUT_VOLTAGE_SHORT_TO_GROUND   0x0905

// Heatcontrol / Thermalmanagment  .. Continue from core
#define ITC_HEATCONTROL_CMC_MAIN_PROCESSOR_CRITICAL_TEMP_HIGH               0x07f3 // (Imx)
#define ITC_HEATCONTROL_CMC_CO_PROCESSOR_CRITICAL_TEMP_HIGH                 0x07f4 // (eMMC)

#endif
