//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_snapshotDataConfiguration.cpp
// PROJECT:      GMMY16
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog ReportMemory creator class
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 20.04.15  | BSOT Plischke                | Initial version
//////////////////////////////////////////////////////////////////////////
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_snapshotDataConfiguration
   #include <common/framework/snapshotData/vd_diaglog_snapshotDataConfiguration.h>
#endif

#define SSD DIAGLOG_FREEZE_FRAME_DATA_TYPE_SNAPSHOTDATA
//#define XDD DIAGLOG_FREEZE_FRAME_DATA_TYPE_EXTENDEDDATA


/* HINT: number must not have any 0 between the DID's, a 0 is indicator for end of List
         also a 0 is not requiered if MAX_SNAPSHOT_RECORDS_SUPPORTED is reached         */
/*static*/ 
const trSnapShotRecordDidMapping vdl_tclSnapShotConfig::sRecordDidMapping[] =
{
   /* record , DID-List                      */
   { DIAGLOG_SNAPSHOTDATA_MILEAGE_OCC_COUNTER  , {SSD|0xF0D0,SSD|0xF0D1,0,0,0,0,0,0,0,0}                 } // milage and occ counter (record 1)
//   { DIAGLOG_SNAPSHOTDATA_OCC_COUNTER        , {SSD|0xF0D1,0,0,0,0,0,0,0,0,0}                          },  // occurence counter
};

/*static*/ 
int vdl_tclSnapShotConfig::iSnapShotRecordDidMappingSize(void)
{
  return (static_cast<int>(sizeof(sRecordDidMapping)/sizeof(trSnapShotRecordDidMapping)));
}



