//////////////////////////////////////////////////////////////////////////
// FILE:         ExtendedDataPrj.h
// PROJECT:      GMMY16
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog MainPrj class - Project Depending settings
//              Protocol, Plugins ...
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 08.08.12  | BSOT Plischke                | Initial version
// 28.12.18  | mky6kor						| Extended data configuration(RTC-434184)
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_ExtendedDataPrj
#define VD_DIAGLOG_INCLUDEGUARD_ExtendedDataPrj

#ifndef VD_DIAGLOG_INCLUDEGUARD_ExtendedData
   #include <common/framework/extendedData/ExtendedData.h>
#endif

class vdl_tclReportRecord;

namespace VDD
{

/*
class DummyFreezeFrame : public ExtendedData
{
public:
   DummyFreezeFrame() : ExtendedData(0x02, 10) {}
   virtual ~DummyFreezeFrame() {}
   virtual void collect();
};


class StandardFreezeFrame : public ExtendedData
{
public:
   StandardFreezeFrame(const vdl_tclReportRecord* const pRecord) : m_pRecord(pRecord),ExtendedData(0x01, 2) 
   {
      if(m_pRecord==NULL){NORMAL_M_ASSERT_ALWAYS();}
   }
   virtual ~StandardFreezeFrame() {}
   virtual void collect();
private:
   const vdl_tclReportRecord* const m_pRecord;
};*/


class MileageFreezeFrame : public ExtendedData
{
public:
   MileageFreezeFrame(const vdl_tclReportRecord* const pRecord) : m_pRecord(pRecord),ExtendedData(DIAGLOG_XD_MILEAGE, 3) 
   {
      if(m_pRecord==NULL){NORMAL_M_ASSERT_ALWAYS();}
   }
   virtual ~MileageFreezeFrame() {}
   virtual void collect();
private:
   const vdl_tclReportRecord* const m_pRecord;
};
class AgeingCounterFreezeFrame : public ExtendedData
{
public:
   AgeingCounterFreezeFrame(const vdl_tclReportRecord* const pRecord) : m_pRecord(pRecord),ExtendedData(DIAGLOG_XD_AGE_COUNTER, 1) 
   {
      if(m_pRecord==NULL){NORMAL_M_ASSERT_ALWAYS();}
   }
   virtual ~AgeingCounterFreezeFrame() {}
   virtual void collect();
private:
   const vdl_tclReportRecord* const m_pRecord;
};

class OccurenceCounterFreezeFrame : public ExtendedData
{
public:
   OccurenceCounterFreezeFrame(const vdl_tclReportRecord* const pRecord) : m_pRecord(pRecord),ExtendedData(DIAGLOG_XD_OCC_COUNTER, 1) 
   {
      if(m_pRecord==NULL){NORMAL_M_ASSERT_ALWAYS();}
   }
   virtual ~OccurenceCounterFreezeFrame() {}
   virtual void collect();
private:
   const vdl_tclReportRecord* const m_pRecord;
};

class StandardizedEnvironmentalDataFreezeFrame : public ExtendedData
{
	public:
	   enum
	   {
		   OCCURRENCE_FLAG_FAULT_VALUE = 0,
		   OCCURRENCE_FLAG_OCCURRENCE_VALUE = 1,
	   };

	   enum
	   {
			OCCURRENCE_FLAG_DEFAULT = OCCURRENCE_FLAG_OCCURRENCE_VALUE,
			EXTERN_TESTER_PRESENT_FLAG_DEFAULT = 0, // not in use
			ODOMETER_ORIGINAL_DEFAULT = 0xFFFF,
			ODOMETER_MOST_RECENT_DEFAULT = 0xFFFF,
			FREQUENCY_COUNTER_DEFAULT = 0, // no value in implementing class available
			IGNITION_CYCLES_DEFAULT = 0,
	   };

	   StandardizedEnvironmentalDataFreezeFrame(const vdl_tclReportRecord* const pRecord) : m_pRecord(pRecord),ExtendedData(DIAGLOG_XD_STANDARD_ENV, getStandardizedEnvironmentalDataSize())
	   {
	      if(m_pRecord==NULL){NORMAL_M_ASSERT_ALWAYS();}

			this->dtcEnvData.occFlg = OCCURRENCE_FLAG_DEFAULT;
			this->dtcEnvData.extTstrPrsntFlg =
					EXTERN_TESTER_PRESENT_FLAG_DEFAULT;
			this->dtcEnvData.origOdom = ODOMETER_ORIGINAL_DEFAULT;
			this->dtcEnvData.mstRcntOdom = ODOMETER_MOST_RECENT_DEFAULT;
			this->dtcEnvData.frqCnt = FREQUENCY_COUNTER_DEFAULT;
			this->dtcEnvData.ignCyclCnt = IGNITION_CYCLES_DEFAULT;

	   }

		virtual ~StandardizedEnvironmentalDataFreezeFrame(){}

		virtual void collect();

		void clear();
		
		tU8 getStandardizedEnvironmentalDataSize();

	private:
		const vdl_tclReportRecord* const m_pRecord;

		struct DiagnosticFaultRecordDtcEnvironmentalData
		{
				tU8 occFlg :1;
				tU8 extTstrPrsntFlg :1; // not supported currently
				tU16 origOdom ;
				tU16 mstRcntOdom ;
				tU8 frqCnt ;
				tU8 ignCyclCnt ;
		};

		DiagnosticFaultRecordDtcEnvironmentalData dtcEnvData;
};

}// namespace VDD

#endif