
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>


#ifndef VD_DIAGLOG_INCLUDEGUARD_ExtendedDataPrj
   #include <project/framework/extendedData/ExtendedDataPrj.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record
   #include <common/framework/vd_diaglog_report_record.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_can_if
   #include <project/plugin/can_if/vd_diaglog_can_if.h>
#endif
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main
   #include <common/framework/vd_diaglog_main.h>
#endif

#include "project/framework/asf/vd_asf_VehicleClient.h"

/* --Includes. */
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/ExtendedDataPrj.cpp.trc.h"   
#endif

namespace VDD
{
/*
void DummyFreezeFrame::collect()
{
   ETG_TRACE_COMP_THR(( "--- DummyFreezeFrame::collect"));
   vector<tU8> data(10,0);
   data[0] = 1;
   data[1] = 2;
   data[2] = 3;
   data[3] = 4;
   data[4] = 5;
   data[5] = 6;
   data[6] = 7;
   data[7] = 8;
   data[8] = 9;
   data[9] = 10;
   setData(data);
}


void StandardFreezeFrame::collect()
{
   ETG_TRACE_COMP_THR(( "--- StandardFreezeFrame::collect"));
   vector<tU8> data(2,0);

   if(m_pRecord != NULL)
   {
      data[0] = m_pRecord->u8GetFailOccurenceCounter();
      data[1] = m_pRecord->u8GetAgeingCounter();
   }
   else
   {
      NORMAL_M_ASSERT_ALWAYS();
      data[0] = 0;
      data[1] = 0;
   }

   setData(data);
}
*/
void MileageFreezeFrame::collect()
{
   ETG_TRACE_COMP_THR(( "--- MileageFreezeFrame::collect"));
   std::vector<tU8> data(3,0);
   if(m_pRecord != NULL)
   {
      tU32 mileage = 0;
      if(vdDiagLog_tclApp::m_poInstance != NULL)
      {
         if(vdDiagLog_tclApp::m_poInstance->m_poCanIF != NULL)
         {
            mileage = vdDiagLog_tclApp::m_poInstance->m_poCanIF->getMileage();
         }// if(vdDiagLog_tclApp::m_poInstance->m_poCanIF != NULL)
         else
         {
            NORMAL_M_ASSERT_ALWAYS();
         }// else // if(vdDiagLog_tclApp::m_poInstance->m_poCanIF != NULL)
      }// if(vdDiagLog_tclApp::m_poInstance != NULL)
      else
      {
         NORMAL_M_ASSERT_ALWAYS();
      }// else // if(vdDiagLog_tclApp::m_poInstance != NULL)
      ETG_TRACE_USR1_THR(( "--- MileageFreezeFrame::collect => mileage:%d km",mileage));  
      data[0] = (mileage >>16)& 0xFF;
      data[1] = (mileage >>8 )& 0xFF;
      data[2] = (mileage     )& 0xFF;
   }
   else
   {
      NORMAL_M_ASSERT_ALWAYS();
      data[0] = 0;
      data[1] = 0;
      data[2] = 0;
   }
   setData(data);
}
void AgeingCounterFreezeFrame::collect()
{
   ETG_TRACE_COMP_THR(( "--- AgeingCounterFreezeFrame::collect"));
   std::vector<tU8> data(1,0);

   if(m_pRecord != NULL)
   {
      if(m_pRecord->bGetIsHistory() == true)
	  {
		  tU8 maxAge = m_pRecord->u8GetMaxAge();
		  ETG_TRACE_COMP_THR(( "--- AgeingCounterFreezeFrame::collect max age = %d", maxAge));
		  tU8 currAgeCnt = m_pRecord->u8GetAgeingCounter(); // current Ageing count
		  ETG_TRACE_COMP_THR(( "--- AgeingCounterFreezeFrame::collect current ageing count = %d", currAgeCnt));
		  if(currAgeCnt == maxAge) // if maxAge has been reached
		  {
			 data[0] = 1; // ageing counter should remain at value 1.
		  }
		  else
		  {
			 data[0] = maxAge - currAgeCnt; // count down
		  }
		  ETG_TRACE_COMP_THR(( "--- AgeingCounterFreezeFrame::collect age count down = %d", data[0]));
	  }
	  else
	  {
		  ETG_TRACE_COMP_THR(( "--- AgeingCounterFreezeFrame::collect -- DTC not confirmed!"));
		  data[0] = 0;
	  }
   }
   else
   {
      NORMAL_M_ASSERT_ALWAYS();
      data[0] = 0;
   }

   setData(data);
}

void OccurenceCounterFreezeFrame::collect()
{
   ETG_TRACE_COMP_THR(( "--- OccurenceCounterFreezeFrame::collect"));
   std::vector<tU8> data(1,0);

   if(m_pRecord != NULL)
   {
      data[0] = m_pRecord->u8GetFailOccurenceCounter();
   }
   else
   {
      NORMAL_M_ASSERT_ALWAYS();
      data[0] = 0;
   }

   setData(data);
}

void StandardizedEnvironmentalDataFreezeFrame::collect()
{
   ETG_TRACE_COMP_THR(( "--- StandardizedEnvironmentalDataFreezeFrame::collect"));

   std::vector<tU8> data;

   if(m_pRecord != NULL)
   {
      // During Startup Copying Data from previous Env Data for persistent.
      std::vector<tU8> _envData = getData();
      tU8 temp = 0;
      temp = _envData[0];
      
      this->dtcEnvData.occFlg = temp & (0x01);
      this->dtcEnvData.extTstrPrsntFlg = (temp >> 1) & (0x01);
      this->dtcEnvData.origOdom =  ( (tU8) _envData[1] << 8 | (tU8) _envData[2] );
      this->dtcEnvData.mstRcntOdom = ( (tU8) _envData[3] << 8 | (tU8) _envData[4] );
      this->dtcEnvData.frqCnt = (tU8)(_envData[5]);
      this->dtcEnvData.ignCyclCnt = (tU8)(_envData[6]);
     
      tU16 odometer = 0;
      if(vdDiagLog_tclApp::m_poInstance != NULL)
      {
         //if(vdDiagLog_tclApp::m_poInstance->m_poCanIF != NULL)
    	  if(vd_asf_VehicleClientHandler::getInstance()!= NULL)
         {
        	 //odometer = vdDiagLog_tclApp::m_poInstance->m_poCanIF->getOdometerValue();
        	 odometer = vd_asf_VehicleClientHandler::getInstance()->getVehicleOdometerValue();
         }// if(vdDiagLog_tclApp::m_poInstance->m_poCanIF != NULL)
         else
         {
            NORMAL_M_ASSERT_ALWAYS();
         }// else // if(vdDiagLog_tclApp::m_poInstance->m_poCanIF != NULL)

		// update odometer values
		// check for original or most recent odometer
		if ( this->dtcEnvData.origOdom == ODOMETER_ORIGINAL_DEFAULT )
		{
			// new fault record, original odometer default or cleared
			// before
			this->dtcEnvData.origOdom = odometer;

			ETG_TRACE_COMP_THR(( "Original odometer at default, so store of actual odometer value %d as original odometer",	this->dtcEnvData.origOdom ));

			// DPRS 983, also update most recent odometer value to
			// "vehicle's current odometer value"
			this->dtcEnvData.mstRcntOdom = odometer;
		}
		else
		{
			// update of existing fault record, original odometer set
			// before
			// DPRS 1025, update most recent odometer value
			this->dtcEnvData.mstRcntOdom = odometer;

			ETG_TRACE_COMP_THR(( "Original odometer not at default, so store of actual odometer value %d as most recent odometer", odometer));
		}
		// update frequency counter
		ETG_TRACE_COMP_THR(( "Update frequency counter to %d", m_pRecord->u8GetFailOccurenceCounter()));
		this->dtcEnvData.frqCnt = m_pRecord->u8GetFailOccurenceCounter();

		// update ignition cycle counter. in fact, this is an operation
		// cycle counter. legacy implementation was that way

		ETG_TRACE_COMP_THR(( "Update ignition cycle counter to %d", m_pRecord->u8MonitoringCyclesSinceFirstFail()));
		this->dtcEnvData.ignCyclCnt =
				m_pRecord->u8MonitoringCyclesSinceFirstFail();

      }// if(vdDiagLog_tclApp::m_poInstance != NULL)
      else
      {
         NORMAL_M_ASSERT_ALWAYS();
      }// else // if(vdDiagLog_tclApp::m_poInstance != NULL)
   }
   else
   {
      NORMAL_M_ASSERT_ALWAYS();
   }

    tU8 tmp;

    // the so-called Enhanced DTC information byte
	tmp = this->dtcEnvData.occFlg;
	tmp |= (this->dtcEnvData.extTstrPrsntFlg << 1);
	data.push_back(tmp);
	// original odometer value
	data.push_back((tU8)(this->dtcEnvData.origOdom >> 8) & 0xFF);
	data.push_back((tU8)(this->dtcEnvData.origOdom >> 0) & 0xFF);
	// most recent odometer value
	data.push_back((tU8)(this->dtcEnvData.mstRcntOdom >> 8) & 0xFF);
	data.push_back((tU8)(this->dtcEnvData.mstRcntOdom >> 0) & 0xFF);
	// frequency counter
	data.push_back((tU8)(this->dtcEnvData.frqCnt));
	// ignition cycle counter
	data.push_back((tU8)(this->dtcEnvData.ignCyclCnt));

	setData(data);
}

tVoid StandardizedEnvironmentalDataFreezeFrame::clear()
{
	bpstl::vector< tU8> data;

	ETG_TRACE_COMP_THR(( "--> StandardizedEnvironmentalDataFreezeFrame::clear"));

	// clear sdd env data
	this->dtcEnvData.occFlg = OCCURRENCE_FLAG_DEFAULT;
	this->dtcEnvData.extTstrPrsntFlg = EXTERN_TESTER_PRESENT_FLAG_DEFAULT;
	this->dtcEnvData.origOdom = ODOMETER_ORIGINAL_DEFAULT;
	this->dtcEnvData.mstRcntOdom = ODOMETER_MOST_RECENT_DEFAULT;
	this->dtcEnvData.frqCnt = FREQUENCY_COUNTER_DEFAULT;
	this->dtcEnvData.ignCyclCnt = IGNITION_CYCLES_DEFAULT;
	
	// update the data in base class in order to use their
	// serialization (load/save). Not using base class' clear() as
	// it writes only zeros and we need different
    tU8 tmp;

    // the so-called Enhanced DTC information byte
	tmp = this->dtcEnvData.occFlg;
	tmp |= (this->dtcEnvData.extTstrPrsntFlg << 1);
	data.push_back(tmp);
	// original odometer value
	data.push_back((tU8)(this->dtcEnvData.origOdom >> 8) & 0xFF);
	data.push_back((tU8)(this->dtcEnvData.origOdom >> 0) & 0xFF);
	// most recent odometer value
	data.push_back((tU8)(this->dtcEnvData.mstRcntOdom >> 8) & 0xFF);
	data.push_back((tU8)(this->dtcEnvData.mstRcntOdom >> 0) & 0xFF);
	// frequency counter
	data.push_back((tU8)(this->dtcEnvData.frqCnt));
	// ignition cycle counter
	data.push_back((tU8)(this->dtcEnvData.ignCyclCnt));
    
	
	setData(data);
	ETG_TRACE_COMP_THR(( "<-- StandardizedEnvironmentalDataFreezeFrame::clear"));
}

tU8 StandardizedEnvironmentalDataFreezeFrame::getStandardizedEnvironmentalDataSize()
{
    bpstl::vector< tU8> extData;
    tU8 tmp = 0;
    tU8 sizeStdEnv = 0;
     
    ETG_TRACE_COMP_THR(( "%s", __FUNCTION__));
     // the so-called Enhanced DTC information byte
	tmp = this->dtcEnvData.occFlg;
	tmp |= (tU8)(this->dtcEnvData.extTstrPrsntFlg << 1);
	extData.push_back(tmp);
	// original odometer value
	extData.push_back((tU8)((tU8)(this->dtcEnvData.origOdom >> 8) & 0xFF));
	extData.push_back((tU8)(this->dtcEnvData.origOdom >> 0) & 0xFF);
	// most recent odometer value
	extData.push_back((tU8)((tU8)(this->dtcEnvData.mstRcntOdom >> 8) & 0xFF));
	extData.push_back((tU8)(this->dtcEnvData.mstRcntOdom >> 0) & 0xFF);
	// frequency counter
	extData.push_back((tU8)(this->dtcEnvData.frqCnt));
	// ignition cycle counter
	extData.push_back((tU8)(this->dtcEnvData.ignCyclCnt));
	
    sizeStdEnv = extData.size();
    
    ETG_TRACE_COMP_THR(( "Size of dtcEnvData %u ", sizeStdEnv));
 return sizeStdEnv;

}
}// namespace VDD


