/*!
 * \file       vd_diaglog_dtcDataPoolConfig.h
 *
 * \brief      class to read the DTC configuration from the datapool memory
 *
 * \details    This class hold implementation related to Datapool elements. 
 *             It provides interfaces to read/write DP elements
 *
 * \component  Diaglog
 *
 * \ingroup    DTC Enable/Disable Configuration
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       25.05.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_VD_DIAGLOG_DTC_DATAPOOL_CONFIGURATION__
#define __INCLUDED_VD_DIAGLOG_DTC_DATAPOOL_CONFIGURATION__

// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_diagdebug_if.h"
#include "dp_if.h"
#endif

class dtcDataPoolConfig
{
public:
    /**
    * Destructor of class DataPoolConfig
    * @return None
    */
    virtual ~dtcDataPoolConfig();
    /**
    * Singleton Class. Method to retrieve the instance of the class
    * @return Returns instance of the class
    */
    static dtcDataPoolConfig* getInstance();
	/**
    * Singleton Class. Method to delete the instance of the class
    * @return Returns nothing
    */
    static void deleteInstance();
    /**
    * Getter function to read the DTC Configuration Dp element
    * @return data read status
	* @param 
    */
    tDiaResult getDTCCfg(tU8* data);
    
private:

    // Instance of the class
    static dtcDataPoolConfig* _poDtcDpCfg;

    dtcDataPoolConfig();
    dtcDataPoolConfig(const dtcDataPoolConfig&);
    dtcDataPoolConfig& operator=(const dtcDataPoolConfig&);
      
};

dtcDataPoolConfig* getInstanceOfDTCDataPoolConfig (void);
void releaseInstanceOfDTCDataPoolConfig(void);

#endif /* __INCLUDED_VD_DIAGLOG_DTC_DATAPOOL_CONFIGURATION__ */
