/*!
 * \file       vd_diaglog_dtcDataPoolConfig.cpp
 *
 * \brief      class to read the DTC configuration from the datapool memory
 *
 * \details    This class hold implementation related to Datapool elements. 
 *             It provides interfaces to read/write DP elements
 *
 * \component  Diaglog
 *
 * \ingroup    DTC Enable/Disable Configuration
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       25.05.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
 
#ifndef __INCLUDED_VD_DIAGLOG_DTC_DATAPOOL_CONFIGURATION__
#include "project/framework/dtcConfiguration/vd_diaglog_dtcDataPoolConfig.h"
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_trace
#include <common/framework/vd_diaglog_trace.h>  
#endif

#ifndef __INCLUDED_VD_DIAGLOG_DTC_CONFIGURATION_DEFS__
#include "project/framework/dtcConfiguration/vd_diaglog_dtcConfig_defs.h"
#endif

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_diagdebug_if.h"
#include "dp_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_dtcDataPoolConfig.cpp.trc.h"   
#endif

// Instantiate the static class object
dtcDataPoolConfig* dtcDataPoolConfig::_poDtcDpCfg = NULL;

dtcDataPoolConfig*
getInstanceOfDTCDataPoolConfig ( void )
{
   return dtcDataPoolConfig::getInstance();
}

void
releaseInstanceOfDTCDataPoolConfig ( void )
{
   dtcDataPoolConfig::deleteInstance();
}


/**
 * Description     : getInstance, returns the instance of the class
 *                   dtcDataPoolConfig
 * @param[in]      : none
 * @param[in]      : none
 * @return         : dtcDataPoolConfig*
 */
dtcDataPoolConfig* 
dtcDataPoolConfig::getInstance()
{
   if (_poDtcDpCfg == NULL)
   {
      _poDtcDpCfg = new dtcDataPoolConfig();
   }
   return _poDtcDpCfg;
}

/**
 * Description     : deleteInstance, deletes the instance of the class
 *                   dtcDataPoolConfig
 * @param[in]      : none
 * @param[in]      : none
 * @return         : void
 */
void
dtcDataPoolConfig::deleteInstance ( void )
{
   if ( _poDtcDpCfg )
   {  
      delete _poDtcDpCfg; 
      _poDtcDpCfg = 0; 
   }
}

/**
 * Description     : Constructor of dtcDataPoolConfig
 *
 * @param[in]      : none
 * @param[in]      : None
 * @return         : void
 */
dtcDataPoolConfig::dtcDataPoolConfig()
{
   ETG_TRACE_USR1_THR(("--> dtcDataPoolConfig::dtcDataPoolConfig"));
   DP_vCreateDatapool();
   ETG_TRACE_USR1_THR(("<-- dtcDataPoolConfig::dtcDataPoolConfig"));
}

/**
 * Description     : Destructor of dtcDataPoolConfig
 *
 * @param[in]      : none
 * @param[in]      : None
 * @return         : void
 */
dtcDataPoolConfig::~dtcDataPoolConfig()
{
   if (_poDtcDpCfg != NULL)
   {
      delete _poDtcDpCfg;
   }
   _poDtcDpCfg = NULL;
}

/**
* Description     : getDTCCfg, provides dtc configuration data
*
* @param[out]     : dtcCfgData
* @param[out]     : size - size of the dtc cfg data
* @return         : tDiaResult status
*/
tDiaResult 
dtcDataPoolConfig::getDTCCfg(tU8* dtcCfgData)
{
	ETG_TRACE_USR1_THR(("--> dtcDataPoolConfig::getDTCCfg(...)"));
	
	dp_tclAppDiag_CMCDTCConfiguration dtcCfg;
	tU32 length = DTC_CFG_DATAPOOL_DATA_LENGTH;
	//tU8* data = new tU8[length];
	tDiaResult retVal = DIA_FAILED;
	
	tS32 s32Status = dtcCfg.s32GetData(dtcCfgData, length);
	ETG_TRACE_USR1_THR(( "--- dtcDataPoolConfig::getDTCCfg => STATUS:%d ", (tU32)s32Status));
    ETG_TRACE_USR1_THR(( "--- dtcDataPoolConfig::getDTCCfg => Lenth:%d ", length));	
	
	if(0 < s32Status)
	{/*
		if(0 < length)
		{
			//dtcCfgData.insert(dtcCfgData.end(), &data[0], &data[length-1]);
			(void)memcpy((void*)dtcCfgData, data, (tU32)length*sizeof(tU8));
			for(int i=0; i < length; i++)
			{
				ETG_TRACE_USR1_THR(( "--- dtcDataPoolConfig::getDTCCfg => value:%d ", data[i]));
			}
						
			retVal = DIA_SUCCESS;
		}
		else
		{
			ETG_TRACE_USR1_THR(( "--- dtcDataPoolConfig::getDTCCfg => Length is zero or less"));
			retVal = DIA_FAILED;	
		}*/
		retVal = DIA_SUCCESS;
	}
	else
	{
		ETG_TRACE_USR1_THR(( "--- dtcDataPoolConfig::getDTCCfg => Failed to Read Datapool"));
		retVal = DIA_FAILED;
	}
	
	ETG_TRACE_USR1_THR(("<-- dtcDataPoolConfig::getDTCCfg(...)"));
	//delete [] data;
	return retVal;
}

