/*!
 * \file       vd_diaglog_dtcConfigurationChk.h
 *
 * \brief      class to check whether DTC is enabled or disabled
 *
 * \details    ...
 *
 * \component  Diaglog
 *
 * \ingroup    DTC Enable/Disable Configuration
 *
 * \author     Arjun Manjunath Sanu (RBEI/ECA2)
 *
 * \date       26.05.2020
 *
 * \copyright  (c) 2020 Robert Bosch Engineering & Business Solutions Ltd.
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_VD_DIAGLOG_DTC_CONFIGURATION_CHECK__
#define __INCLUDED_VD_DIAGLOG_DTC_CONFIGURATION_CHECK__

// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

class dtcConfigurationChk
{
public:
    /**
    * Destructor of class DataPoolConfig
    * @return None
    */
    virtual ~dtcConfigurationChk();
    /**
    * Singleton Class. Method to retrieve the instance of the class
    * @return Returns instance of the class
    */
    static dtcConfigurationChk* getInstance();
	/**
    * Singleton Class. Method to delete the instance of the class
    * @return Returns nothing
    */
    static void deleteInstance();
    /**
    * Function to prepare the DTC Configuration Database
    * @return None
	* @param  None
    */
    virtual void prepareDatabase( void );
    /**
    * Function to check if the ITC is enabled or disabled
    * @return bool - yes/no
	* @param  tU16 - ITC 
    */
    virtual bool isDTCEnabled( tU16 /* ITC */ );
	/**
    * Function to check if the DTC is enabled or disabled
    * @return bool - yes/no
	* @param  tU32 - DTC 
    */
    virtual bool isDTCEnabled( tU32 /* DTC */ );
	/**
    * We use 2 level constructor strategy
    * @return tDiaResult
    */
    virtual tDiaResult setup ( void );
	
protected:
	/**
    * 2nd level destructor
    * @return tDiaResult
    */
    virtual tDiaResult tearDown ( void );
   
private:

    // Instance of the class
    static dtcConfigurationChk* _poDtcCfgChk;
	
	// config data storage read from datapool
	tU8* mDtcCfgData;
	// map table for ITC and DTC
	static const std::map<const tU16, const tU32> _itc2dtcMapTable;
	// map table for DTC and Current Configuration
	std::map<const tU32, tU8> _dtcConfigTable;

    dtcConfigurationChk();
    dtcConfigurationChk(const dtcConfigurationChk&);
    dtcConfigurationChk& operator=(const dtcConfigurationChk&);
      
};

// reference array of the DTC
extern const tU32 g_dtcList[];
extern int g_dtcListSize();

dtcConfigurationChk* getInstanceOfDTCCfgChecker (void);
void releaseInstanceOfDTCCfgChecker(void);

#endif /* __INCLUDED_VD_DIAGLOG_DTC_CONFIGURATION_CHECK__ */