//////////////////////////////////////////////////////////////////////////
// FILE:         vd_asf_VehicleClientHandler.h
// PROJECT:      GEN3
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog vd_asf_VehicleClientHandler creator class
//
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2021 Robert Bosch GmbH, Hildesheim
// HISTORY:
// Date      | Author                       | Modification
// 14.03.22  | nik6kor						| Send the CAN signal to Vehicle data
//////////////////////////////////////////////////////////////////////////

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_asf_vehicleClienthandler
#define VD_DIAGLOG_INCLUDEGUARD_vd_asf_vehicleClienthandler

#include <common/framework/vd_diaglog_settings.h>


#include "VEHICLE_MAIN_FIProxy.h"
#include "vehicle_main_fi_types.h"

#include <asf/core/Proxy.h>

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"



class vdl_tclTrace;                    //lint !e763

using namespace VEHICLE_MAIN_FI;
class vd_asf_VehicleClientHandler
    : public ::asf::core::ServiceAvailableIF
	, public HUS_DM1_StatusCallbackIF
	, public TotalVehDistDiagCallbackIF
	, public VIN_64CallbackIF
{
   public:

    static vd_asf_VehicleClientHandler* getInstance()
    {
       if (NULL == m_povd_asf_VehicleClientHandler)
       {
    	   m_povd_asf_VehicleClientHandler = new vd_asf_VehicleClientHandler();
       }

       return m_povd_asf_VehicleClientHandler;
    }

      virtual ~vd_asf_VehicleClientHandler();
      vd_asf_VehicleClientHandler();

      bool vSendDM1DataMessage(tU8* dm1Frame);

      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
	  void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

	  void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& /*stateChange*/);
	  void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& /*stateChange*/);

	  virtual void onHUS_DM1_StatusError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< HUS_DM1_StatusError >& error);
	  virtual void onHUS_DM1_StatusResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< HUS_DM1_StatusResult >& status);

	  virtual void onVIN_64Error(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VIN_64Error >& error);

	  virtual void onVIN_64Status(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VIN_64Status >& status);


	  virtual void onTotalVehDistDiagError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< TotalVehDistDiagError >& error);

	  virtual void onTotalVehDistDiagStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< TotalVehDistDiagStatus >& status);

	  bool fetchGetTotalVehDistanceValue(uint64& value) const;
	  tU16 getVehicleOdometerValue();

      uint32 m_OdometerValue;
      uint64 m_VinValue;
   private:
	  static vd_asf_VehicleClientHandler* m_povd_asf_VehicleClientHandler;
      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy> m_vehicleProxy;

};

#endif
