//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_external_data_timestamp.cpp
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog FreeteFrame Data TimeStamp
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 10.05.13  | BSOT Plischke                | Initial version
//
//////////////////////////////////////////////////////////////////////////
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_external_data
   #include <project/externaldata/vd_diaglog_external_data.h>  
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_trace
   #include <common/framework/vd_diaglog_trace.h>  
#endif    

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_external_data_timestamp.cpp.trc.h"   
#endif



///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: tU32 vdl_tclExternalData::u32GetGlobalTimestamp
// 
// DESCRIPTION:  get the current timestep from the Clock Module
//
// PARAMETER:  void
//
// RETURNVALUE: current TimeStep
// 
///////////////////////////////////////////////////////////////////////////////////
//
/*static*/
tU32 vdl_tclExternalData::u32GetCurrentTimestamp() 
{
   ETG_TRACE_USR3_THR(( "--> vdl_tclExternalData::u32GetCurrentTimestamp"));
   tU8 Year  = 01;
   tU8 Month = 01;
   tU8 Day   = 01;
   tU8 Hour  = 01;
   tU8 Min   = 01;
   tU8 Sec   = 01;

  
   // u32CurrentTimestamp yyyyyymm mmdddddh hhhhmmmm mmssssss
   tU32  u32CurrentTimestamp  = (tU32)(Year & 0x3F)     << 26;
         u32CurrentTimestamp |= (tU32)(Month & 0x0F)    << 22;
         u32CurrentTimestamp |= (tU32)(Day & 0x1F)      << 17;
         u32CurrentTimestamp |= (tU32)(Hour & 0x1F)     << 12;
         u32CurrentTimestamp |= (tU32)(Min & 0x3F)      << 6;
         u32CurrentTimestamp |= (tU32)(Sec & 0x3F);


    ETG_TRACE_USR3_THR(( "<-- vdl_tclExternalData::u32GetCurrentTimestamp"));
   return u32CurrentTimestamp;
}
