//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_external_data_distance.cpp
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog FreeteFrame Data Distance
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 10.05.13  | BSOT Plischke                | Initial version
//
//////////////////////////////////////////////////////////////////////////
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_external_data
   #include <project/externaldata/vd_diaglog_external_data.h>  
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_trace
   #include <common/framework/vd_diaglog_trace.h>  
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_external_data_distance.cpp.trc.h"   
#endif



///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: tU32 vdl_tclExternalData::u32GetCurrentDistance
// 
// DESCRIPTION:  get the current distance
//
// PARAMETER:  void
//
// RETURNVALUE: current TimeStep
// 
///////////////////////////////////////////////////////////////////////////////////
//
/*static*/
tU32 vdl_tclExternalData::u32GetCurrentDistance() 
{
   ETG_TRACE_USR3_THR(( "--> vdl_tclExternalData::u32GetCurrentDistance"));
   ETG_TRACE_USR3_THR(( "<-- vdl_tclExternalData::u32GetCurrentDistance"));
   return 0;
}
