//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_plugin_if.h
// PROJECT:      all
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Baseclass for PlugIns
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 28.09.12  | BSOT Plischke                | Initial version
//
//////////////////////////////////////////////////////////////////////////
#ifndef _VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_plugin_if
#define _VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_plugin_if

// forward declaration
class vdl_tclReportRecord;    //lint !e763
struct vdl_tsDiaglogPlugInReport; //lint !e763

class vdl_tclPluginBaseClass  
{
public:
   vdl_tclPluginBaseClass();
   virtual ~vdl_tclPluginBaseClass();

   virtual tVoid vOnInit()              {};
   virtual tVoid vTimer(tS32 /*s32TimerId*/)   {};
   virtual tVoid vIgnitionCycleStart()     {};
   virtual tVoid vIgnitionCycleEnd()       {};
   virtual tVoid vOperationCycleStart()    {};
   virtual tVoid vOperationCycleEnd()      {};
   virtual tVoid vClear()                  {};
   virtual tBool bSetToDefault()           {return true;};
   virtual tVoid vFailQualified(vdl_tclReportRecord* const /*pReportRecord*/)       {};  // this event is running in LockMemorySemaphore, because pReportRecord must be protected and never copy this pointer, because record could be deleted
   virtual tVoid vPassQualified(vdl_tclReportRecord* const /*pReportRecord*/)       {};  // this event is running in LockMemorySemaphore, because pReportRecord must be protected and never copy this pointer, because record could be deleted
   virtual tVoid vAgeingCompleted(vdl_tclReportRecord* const /*pReportRecord*/)     {};  // this event is running in LockMemorySemaphore, because pReportRecord must be protected and never copy this pointer, because record could be deleted
   virtual tVoid vUpdateAfterBlockingMode()                                         {};

   virtual tVoid vFailQualified(vdl_tsDiaglogPlugInReport /*reportRecord*/)       {};  // this event is running in LockMemorySemaphore
   virtual tVoid vPassQualified(vdl_tsDiaglogPlugInReport /*reportRecord*/)       {};  // this event is running in LockMemorySemaphore
   virtual tVoid vAgeingCompleted(vdl_tsDiaglogPlugInReport /*reportRecord*/)     {};  // this event is running in LockMemorySemaphore

   virtual tVoid vClearByMask(vdl_tsDiaglogPlugInReport /*reportRecord*/)         {};

protected:
   tS32 s32CreateTimer ();
   tBool bSetTimer (tS32 s32TimerId, tS32 s32Time) const;

   // plugin call functions, to set/get data from Memory/Record
   // never use vdl_tclReportRecord* because this one can be deleted
   bool bSetQualificationTimeforITC(tU8 memoryId, tU16 itc, tS32 passValue, tS32 failValue)const;
};

#endif // _VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_plugin_if
