//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_plugin_if.cpp
// PROJECT:      all
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Baseclass for PlugIns
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 28.09.12  | BSOT Plischke                | Initial version
//
//////////////////////////////////////////////////////////////////////////
// first include diaglog settings
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main
   #include <common/framework/vd_diaglog_main.h>
#endif

#include <common/framework/vd_diaglog_settings.h>

#include "vd_diaglog_plugin_if.h"

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_memory_master
   #include <common/framework/vd_diaglog_memory_master.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record
   #include <common/framework/vd_diaglog_report_record.h>
#endif


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_plugin_if.cpp.trc.h"
#endif

/*********************************************************************************/
/*********************************************************************************/
/*********************************************************************************/
/*                            PLUGIN BASIC FUNCTIONS                             */
/*********************************************************************************/
/*********************************************************************************/
/*********************************************************************************/

vdl_tclPluginBaseClass::vdl_tclPluginBaseClass()  
{
   if(vdDiagLog_tclApp::m_poInstance != NULL)
   {
      (tVoid) vdDiagLog_tclApp::m_poInstance->bRegisterForEvent(this);
   }
   else
   {
      ETG_TRACE_ERRMEM(( "!!! vdl_tclPluginBaseClass::vdl_tclPluginBaseClass => NULL == m_poInstance"));
      NORMAL_M_ASSERT_ALWAYS();
   }
}


vdl_tclPluginBaseClass::~vdl_tclPluginBaseClass()
{
   _BP_TRY_BEGIN
   {
      if(vdDiagLog_tclApp::m_poInstance != NULL)
      {
         (tVoid) vdDiagLog_tclApp::m_poInstance->bDeleteTimer(this);
         (tVoid) vdDiagLog_tclApp::m_poInstance->bUnRegisterForEvent(this);
      }
   }
   _BP_CATCH_ALL
   {
      ETG_TRACE_ERRMEM(( "!!! vdl_tclPluginBaseClass::~vdl_tclPluginBaseClass => _BP_CATCH_ALL"));
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}


///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: tS32 vdl_tclPluginBaseClass::s32CreateTimer () 
// 
// DESCRIPTION: creates a Plugin Timer
//
// PARAMETER:  void
//
// RETURNVALUE: Timer handle
// 
///////////////////////////////////////////////////////////////////////////////////
//
tS32 vdl_tclPluginBaseClass::s32CreateTimer () 
{
   tS32 s32TimerHandle = -1;
   if(vdDiagLog_tclApp::m_poInstance != NULL)
   {
      s32TimerHandle = vdDiagLog_tclApp::m_poInstance->s32CreateTimer(this);
   }
   else
   {
      ETG_TRACE_ERRMEM(( "!!! vdl_tclPluginBaseClass::s32CreateTimer => NULL == m_poInstance"));
      NORMAL_M_ASSERT_ALWAYS();
   }
   return s32TimerHandle;
}

///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: tBool vdl_tclPluginBaseClass::bSetTimer (tS32 s32TimerId, tS32 s32Time) const
// 
// DESCRIPTION: Set a PluginTimer
//
// PARAMETER:  s32TimerId: Timer handle
//             s32Time:    Time to set
//
// RETURNVALUE: TRUE/FALSE
// 
///////////////////////////////////////////////////////////////////////////////////
//
tBool vdl_tclPluginBaseClass::bSetTimer (tS32 s32TimerId, tS32 s32Time) const
{
   tBool bReturn = false;
   if(vdDiagLog_tclApp::m_poInstance != NULL)
   {
      bReturn = vdDiagLog_tclApp::m_poInstance->bSetTimer(s32TimerId,s32Time);
   }
   else
   {
      ETG_TRACE_ERRMEM(( "!!! vdl_tclPluginBaseClass::bSetTimer => NULL == m_poInstance"));
      NORMAL_M_ASSERT_ALWAYS();
   }
   return bReturn;
}

/*****************************************************************************************************************************************/
/*****************************************************************************************************************************************/
/*****************************************************************************************************************************************/
/*                                           PLUGIN DIAGLOG INTERFACE FUNCTIONS                                                          */
/*****************************************************************************************************************************************/
/*****************************************************************************************************************************************/
/*****************************************************************************************************************************************/  

///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: bool vdl_tclPluginBaseClass::bSetQualificationTimeforITC(tU8 memoryId, tU16 itc, tU32 passValue tU32 failValue)
// 
// DESCRIPTION: this function is to overwrite the Qualification time, 
//              by projectspecific Data e.g. by EOL/Calibration Data
//              this value will NOT be stored persistence
//
// RESTRICTION: forbidden to run in => this will result in a DEADLOCK!!!
//    - virtual tVoid vFailQualified(vdl_tsDiaglogPlugInReport reportRecord) 
//    - virtual tVoid vPassQualified(vdl_tsDiaglogPlugInReport reportRecord) 
//    - virtual tVoid vAgeingCompleted(vdl_tsDiaglogPlugInReport reportRecord) 
//    
//
// PARAMETER:  memoryId:   User Memory ID (CUSTOMER/ BOSCH ..)
//             itc:        ITC
//             passValue:  new qualification pass Value
//             failValue:  new qualification fail Value
//
// RETURNVALUE: true = ITC found, 
//             false = ITC not found
// 
///////////////////////////////////////////////////////////////////////////////////
//
bool vdl_tclPluginBaseClass::bSetQualificationTimeforITC(tU8 memoryId, tU16 itc, tS32 passValue, tS32 failValue)const
{
   bool bReturn = false;
   if(vdDiagLog_tclApp::m_poInstance != NULL)
   {
      (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.LockMemorySemaphore();
      {  // the following part must be protected
         vdl_tclReportRecord* pRecord = (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.pGetReportRecord(memoryId, itc);
         if(pRecord != NULL)
         {
            ETG_TRACE_COMP_THR(( "--- vdl_tclPluginBaseClass::bSetQualificationTimeforITC =>MemoryId:%d ITC:%04x Pass:%d Fail:%d",memoryId,itc,passValue,failValue));
            pRecord->vSetFailValue(failValue);
            pRecord->vSetPassValue(passValue);
            bReturn = true;
         }// if(pRecord != NULL)
         else
         {
            ETG_TRACE_ERR_THR(( "!!! vdl_tclPluginBaseClass::bSetQualificationTimeforITC => Record not found Id:%d ITC:%04x",memoryId,itc));
            NORMAL_M_ASSERT_ALWAYS();
         }
      }// end of  the following part must be protected
      (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.FreeMemorySemaphore();
   }// if((vdDiagLog_tclApp::m_poInstance) != NULL)
   else
   {
      // should never happen
      ETG_TRACE_ERRMEM(( "!!! vdl_tclPluginBaseClass::bSetQualificationTimeforITC => NULL == m_poInstance  Parameter: Id:%02x ITC:%04x",memoryId,itc));
      NORMAL_M_ASSERT_ALWAYS();
   }// else // if((vdDiagLog_tclApp::m_poInstance) != NULL)
   return bReturn;
}


