//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_typedefs.h
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Typdef Definitions, this defines could be config dpendend
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 08.08.12  | BSOT Plischke               | Initial version
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs_basic
   #include <common/framework/vd_diaglog_typedefs_basic.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_configuration
   #include <project/framework/vd_diaglog_configuration.h>
#endif

struct trReportRecordData
{
   tU16                             m_u16ITC;                     // ITC ID
   tU32                             m_u32DTC;                     // DTC Id
   vdl_teDiaglogReportType          m_eReportType;                // Report Typ
   tU8                              m_u8Variant;                  // variant depending DTC
   tU8                              m_u8Severity;                 // unused
   tU32                             m_bWarningIndicator:1;        // unused
   tU32                             m_bDTCEnabled:1;              // unused
   tU32                             m_bCanClear:1;                // clearcommand allowed
   tU32                             m_bAgeingAllowed:1;           // automatic clearing allowed
   tU32                             m_bClearOnFirstPass:1;        // clear on first pass
   tU32                             m_bClearOnStartup:1;          // clear on each startup
   tU32                             m_bChangeWithoutDebounce:1;   // Test will directly switch to fail, but History only after debouncing Time
   tS32                             m_s32FailDelta;               // Fail debouncetime in [ms]
   tS32                             m_s32PassDelta;               // Pass debouncetime in [ms]
   tU8                              m_u8MaxAge;                   // Agingvalue, number of cycles before automatic clearing
   vdl_teDiaglogAgeingCycle         m_eAgeingTrigger;             // Ageingtrigger event
   tU8                              m_U8TestFrequency;            // currently unused
   tU32                             m_u32BlockingDTCList[DIAGLOG_MAX_BLOCKDTCLIST];      // List of DTC's which block this DTC
   tU32                             m_u32DTCBlockingMode;         // Bitfield if blocked in special conditions
   tU32                             m_u32AppID;                   // The CCA ID of the Application that is responsbile for reporting this DTC 
   tU8                              m_extendedDataRecords[DIAGLOG_MAX_EXTENDED_RECORDS_SUPPORTED];     // extended data record numbers
   tU8                              m_snapshotDataRecords[DIAGLOG_MAX_SNAPSHOT_RECORDS_SUPPORTED];     // snapshot data record numbers
};

struct tMemoryFactory
{
   tU8                           u8MemoryId;                  // unique Memory ID for Read/Clear Request
   vdl_teDiaglogReportProtocol   eReportProtcol;             // Report Protocol
   tU8                           u8StatusAvailabilityMask;   // Status Flags which have to be supported
   const trReportRecordData*     pConstRecordDataArray;      // Pointer to ReporRecord Struct
   int                           iSizeOfRecordDataArray;     // Size of ReportRecord Struct
   tCString                      acMemoryFileName;           // File destination + name for Storeing
};


#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_typedefs
