/************************************************************************
* FILE:         vdDiagLog_main.cpp
* PROJECT:      FORD HRNS/LRNS
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION: DiagLog trace class
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2006 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 08.02.05  | CM-DI/ESA2 Barber  | initial version
*
*************************************************************************/
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main
   #include <common/framework/vd_diaglog_main.h>
#endif

#include "vd_diaglog_trace.h"

// we have undefined the etrace macro definition for "_" in dia_trace.h, but as we use some etrace within this file we need to redefine here locally
#ifndef _
#define _ ,
#endif


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_memory_master
   #include <common/framework/vd_diaglog_memory_master.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_snapshotdata
   #include <common/framework/snapshotData/vd_diaglog_snapshotdata.h>
#endif

#define DIAGLOG_TR_CMD_DUMP_BY_ID         0x03
#define DIAGLOG_TR_CMD_DUMP               0x04
#define DIAGLOG_TR_CMD_GETBLOCKINGMODE    0x05
//USE THE FOLLOWING ONLY FOR DEBUGGING PURPOSES
//#define DIAGLOG_TR_CMD_SIMULATEFAIL       0x06
//#define DIAGLOG_TR_CMD_SIMULATEPASS       0x07
//#define DIAGLOG_TR_CMD_GETDTCSTATUS       0x08
//#define DIAGLOG_TR_CMD_SIMULATEPASSALLDTCS   0x09
                              
//#define DIAGLOG_TR_CMD_SIMULATEFAILPASS      0x0C
//#define DIAGLOG_TR_CMD_SIMULATESTARTIGNCYCLE 0x0D
//#define DIAGLOG_TR_CMD_SIMULATEENDIGNCYCLE 0x0E
//#define DIAGLOG_TR_CMD_CLEAR_ALL       0x0E
//#define DIAGLOG_TR_CMD_DISABLE_DTC_BLOCKING  0x11
//#define DIAGLOG_TR_CMD_ENABLE_DTC_BLOCKING   0x12
//#define DIAGLOG_TR_CMD_SIMULATE_IGN_END    0x13
//#define DIAGLOG_TR_CMD_SIMULATE_IGN_START  0x14
#define DIAGLOG_TR_CMD_SIMULATE_AGING_MESSAGE  0x15
#define DIAGLOG_TR_CMD_SIMULATE_CONTROL  0x16
#define DIAGLOG_TR_CMD_SIMULATE_ITC  0x17
#define DIAGLOG_TR_CMD_SIMULATE_DYNAMIC_DTC  0x18
//#define DIAGLOG_TR_CMD_SIMULATE_OPERATION_START 0x19
//#define DIAGLOG_TR_CMD_SIMULATE_OPERATION_END 0x1A
#define DIAGLOG_TR_CMD_SIMULATE_BLOCKING_REASON 0x1B
#define DIAGLOG_TR_CMD_SHOW_SNAPSHOTLIST  0x1C
#define DIAGLOG_TR_CMD_SIMULATE_POWER_EVENT 0x1D

/* --Includes. */
/*
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
*/

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_trace.cpp.trc.h"
#endif




vdl_tclTrace::vdl_tclTrace(vdDiagLog_tclApp* poApp) :
   m_poApp(poApp)
{
}

vdl_tclTrace::~vdl_tclTrace()
{
   m_poApp = NULL;
}

tVoid vdl_tclTrace::vTraceRx(tU8 const* pu8Data) const
{
   tU8 u8Cmd = pu8Data[1];
   switch(u8Cmd)
   {
      case DIAGLOG_TR_CMD_DUMP:
      {
         vDumpReportMem();
         break;
      }

      case DIAGLOG_TR_CMD_DUMP_BY_ID:
      {
         vDumpReportMemById(pu8Data[2]);
         break;
      }

      case DIAGLOG_TR_CMD_SIMULATE_POWER_EVENT:
      {      
         if(vdDiagLog_tclApp::m_poInstance != NULL)
         {
            (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.processSystemEvent(static_cast<vdl_teDiaglogSystemEvent>(pu8Data[2]));
         }
         break;
      }

      case DIAGLOG_TR_CMD_SIMULATE_AGING_MESSAGE:
      {
         if(vdDiagLog_tclApp::m_poInstance != NULL)
         {
            (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.vProcessExternalAgeingCounter(pu8Data[2]);
         }
         break;
      }

      case DIAGLOG_TR_CMD_SIMULATE_CONTROL:
      {
         if(vdDiagLog_tclApp::m_poInstance != NULL)
         {
            vdl_teDiaglogControlMsg eControlMsg = (vdl_teDiaglogControlMsg) (pu8Data[2]);
            tU32 u32DTC = (((tU32)pu8Data[3])<<16) + (((tU32)pu8Data[4])<<8) + pu8Data[5];
            tDTCListArray oDTCList;
            oDTCList.push_back(u32DTC);

            (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.bProcessControlCommand(eControlMsg, oDTCList);
         }
         break;
      }

      case DIAGLOG_TR_CMD_SIMULATE_ITC:
      {
         if(vdDiagLog_tclApp::m_poInstance != NULL)
         {
            vdl_teDiaglogReportMsg eStatus = (vdl_teDiaglogReportMsg) (pu8Data[2]);
            tU16 u16ITC = (tU16)((pu8Data[3] << 8) + pu8Data[4]);

            (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.bProcessTestReport(u16ITC, eStatus);
         }
         break;
      }


      case DIAGLOG_TR_CMD_GETBLOCKINGMODE:
      {
         if(vdDiagLog_tclApp::m_poInstance != NULL)
         {
            tU32 BlockingMode = (vdDiagLog_tclApp::m_poInstance)->u32GetSystemBlockingMode();
            ETG_TRACE_ERR_THR(("--- vdl_tclTrace::vTraceRx => Blockingmode:%x",BlockingMode));
         }
         break;
      }
      
      case DIAGLOG_TR_CMD_SIMULATE_DYNAMIC_DTC:
      {
         if(vdDiagLog_tclApp::m_poInstance != NULL)
         {
            vdl_tsDiaglogTestResult oTestResult;

            oTestResult.eReportStatus = (vdl_teDiaglogReportMsg) (pu8Data[2]);
            oTestResult.u32DTC = (((tU32)pu8Data[3]) << 16) + (((tU32)pu8Data[4]) << 8) + pu8Data[5];
            oTestResult.bDynamicalDTC = true;

            (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.bProcessTestReport(oTestResult);
         }
         break;
      }

      case DIAGLOG_TR_CMD_SIMULATE_BLOCKING_REASON:
      {
         if(vdDiagLog_tclApp::m_poInstance != NULL)
         {
            tU8   Mode = pu8Data[2];
            tU32  BlockingMode = (((tU32)pu8Data[3]) << 24) + (((tU32)pu8Data[4]) << 16) + (((tU32)pu8Data[5]) << 8) + pu8Data[6];

            if(Mode == 0x01)
            {
               (vdDiagLog_tclApp::m_poInstance)->vSetBlockingMode(BlockingMode);
            }
            else if (Mode == 0x02)
            {
               (vdDiagLog_tclApp::m_poInstance)->vResetBlockingMode(BlockingMode);
            }
         }
         break;
      }

      case DIAGLOG_TR_CMD_SHOW_SNAPSHOTLIST:
      {
         if(vdDiagLog_tclApp::m_poInstance != NULL)
         {
            if(vdDiagLog_tclApp::m_poInstance->m_poSnapShotData != NULL)
            {
              vdDiagLog_tclApp::m_poInstance->m_poSnapShotData->traceSnapShotMap();
            }
         }
         break;
      }



      default:
      {
         break;
      }
   }
}

tVoid vdl_tclTrace::vDumpReportMem() const
{
   if(vdDiagLog_tclApp::m_poInstance != NULL)
   {
      (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.vTraceReports(0xFF);
   }
}

tVoid vdl_tclTrace::vDumpReportMemById(tU8 MemoryID) const
{
   if(vdDiagLog_tclApp::m_poInstance != NULL)
   {
      (vdDiagLog_tclApp::m_poInstance)->m_oMemoryMaster.vTraceReports(MemoryID);
   }
}

