//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_system_variables.h
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Global System Variables and Functions
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 04.10.12  | BSOT Plischke               | Initial version
//
//////////////////////////////////////////////////////////////////////////
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_system_variables
#define VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_system_variables


class vdl_tclGlobalSystemVariables 
{
public:
   vdl_tclGlobalSystemVariables() {};
   virtual ~vdl_tclGlobalSystemVariables() {};

private:
   static tU8  m_u8SystemConf;         // System Configuartion: Base, Connectivity, Color or Naviation
   static tU16 m_u16MostBusDelayTimer; // Most Bus Delay Timer
   static tU16 m_u16DTCCrankDelayTime; // Crank Delay Timer
   static tU8  m_u8MaxAge;  
   static bool m_bIgnoreCalibration;
   static bool m_bEarlyDiagnosticsSupported;

public:
   static tU8   u8GetSystemConf()       {return m_u8SystemConf;}
   static tVoid vSetSystemConf(tU8 var) {m_u8SystemConf = var;}

   static tU16 u16GetMostBusDelayTimer()        {return m_u16MostBusDelayTimer;}
   static tVoid vSetMostBusDelayTimer(tU16 var) {m_u16MostBusDelayTimer = var;}

   static tU16 u16GetCrankDelayTime()        {return m_u16DTCCrankDelayTime;}
   static tVoid vSetCrankDelayTime(tU16 var) {m_u16DTCCrankDelayTime = var;}

   static tVoid vSetMaxAge(tU8 u8Age) {m_u8MaxAge = u8Age;}
   static tU8   u8GetMaxAge()         {return m_u8MaxAge;}

   static void vSetIgnoreCalibration()          {m_bIgnoreCalibration = true;}
   static void vReSetIgnoreCalibration()        {m_bIgnoreCalibration = false;}
   static tU8  bGetIgnoreCalibrationSetting()   {return m_bIgnoreCalibration;}

   static void vSetEarlyDiagnosticsMode()       {m_bEarlyDiagnosticsSupported = true;}
   static bool bIsEarlyDiagnosticsSupported()   {return m_bEarlyDiagnosticsSupported;}
};



#endif // VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_system_variables
