//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_storage_interface.cpp
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog storage User Inferface, this one should be used by everyone who want to store data
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 28.10.14  | BSOT Plischke                | Initial version
//
//////////////////////////////////////////////////////////////////////////
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_object
   #include <common/framework/vd_diaglog_object.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_file_storage_interface
   #include <common/framework/vd_diaglog_storage_interface.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main
   #include <common/framework/vd_diaglog_main.h>
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_storage_interface.cpp.trc.h"
#endif



///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: vdl_tclStorageUserInterface::vdl_tclStorageUserInterface()
// 
// DESCRIPTION: constructor
//
// PARAMETER:  
//
// RETURNVALUE: tVoid
// 
///////////////////////////////////////////////////////////////////////////////////
//
vdl_tclStorageUserInterface::vdl_tclStorageUserInterface ():
   m_poStorageObject(NULL)
{
     // should never used     
     ETG_TRACE_ERRMEM(( "!!! vdl_tclStorageUserInterface::vdl_tclStorageUserInterface"));
     NORMAL_M_ASSERT_ALWAYS();
}

///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: vdl_tclStorageUserInterface::vdl_tclStorageUserInterface()
// 
// DESCRIPTION: constructor
//
// PARAMETER:  
//
// RETURNVALUE: tVoid
// 
///////////////////////////////////////////////////////////////////////////////////
//
vdl_tclStorageUserInterface::vdl_tclStorageUserInterface (tCString const szFilename):
   m_poStorageObject((vdDiagLog_tclApp::m_poInstance)->m_oStorageHandler.registerNewStorageObject(this, szFilename))
{
   // register for storage Handler
   if(NULL == m_poStorageObject)
   {           
      ETG_TRACE_ERRMEM(( "!!! vdl_tclStorageUserInterface::vdl_tclStorageUserInterface => NULL == m_poStorageObject"));
      NORMAL_M_ASSERT_ALWAYS();
   }
}

///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION: vdl_tclStorageUserInterface::~vdl_tclStorageUserInterface()
// 
// DESCRIPTION: constructor
//
// PARAMETER:  
//
// RETURNVALUE: tVoid
// 
///////////////////////////////////////////////////////////////////////////////////
//
vdl_tclStorageUserInterface::~vdl_tclStorageUserInterface()
{
   _BP_TRY_BEGIN
   {
      if(NULL != m_poStorageObject)
      {  
         (vdDiagLog_tclApp::m_poInstance)->m_oStorageHandler.unregisterNewStorageObject(m_poStorageObject);
         m_poStorageObject = NULL;
      }
   }

   _BP_CATCH_ALL
   {
      ETG_TRACE_ERRMEM(( "!!! vdl_tclStorageUserInterface::~vdl_tclStorageUserInterface => _BP_CATCH_ALL"));
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}


///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION:     vdl_tclStorageUserInterface::u32GetDataBaseTimestamp
//
// DESCRIPTION:  forward the EventStep to the Storge Handler
//             
// PARAMETER:     none
//
// RETURNVALUE:  none
//
///////////////////////////////////////////////////////////////////////////////////
tU32 vdl_tclStorageUserInterface::u32GetDataBaseTimestamp()const
{
   tU32 bReturn = 0;
   if(m_poStorageObject != NULL)
   {
      bReturn = m_poStorageObject->u32GetDataBaseTimestamp();
   }
   return bReturn;
}

///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION:     vdl_tclStorageUserInterface::loadDataBaseIfNotLoaded
//
// DESCRIPTION:  forward the EventStep to the Storge Handler
//             
// PARAMETER:     none
//
// RETURNVALUE:  none
//
///////////////////////////////////////////////////////////////////////////////////
bool vdl_tclStorageUserInterface::loadDataBaseIfNotLoaded()
{
   bool bReturn = false;
   if(m_poStorageObject != NULL)
   {
      bReturn = m_poStorageObject->loadDataBaseIfNotLoaded();
   }
   return bReturn;
}

///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION:     vdl_tclStorageUserInterface::requestForSaveIfModified
//
// DESCRIPTION:  forward the EventStep to the Storge Handler
//             
// PARAMETER:     none
//
// RETURNVALUE:  none
//
///////////////////////////////////////////////////////////////////////////////////
tVoid vdl_tclStorageUserInterface::requestForSaveIfModified()
{
   if(m_poStorageObject != NULL)
   {
      m_poStorageObject->requestForSaveIfModified();
   }
}

///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION:     vdl_tclStorageUserInterface::saveNowIfModified
//
// DESCRIPTION:  forward the EventStep to the Storge Handler
//             
// PARAMETER:     none
//
// RETURNVALUE:  none
//
///////////////////////////////////////////////////////////////////////////////////
tVoid vdl_tclStorageUserInterface::saveNowIfModified()
{
   if(m_poStorageObject != NULL)
   {
      m_poStorageObject->saveNowIfModified();
   }
}

///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION:     vdl_tclStorageUserInterface::vSetModified
//
// DESCRIPTION:  forward the EventStep to the Storge Handler
//             
// PARAMETER:    bool status => true: status changed
//
// RETURNVALUE:  none
//
///////////////////////////////////////////////////////////////////////////////////
tVoid vdl_tclStorageUserInterface::setModified()
{
   if(m_poStorageObject != NULL)
   {
      m_poStorageObject->setModified();
   }
}

///////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION:     vdl_tclStorageUserInterface::vSetModified
//
// DESCRIPTION:  forward the EventStep to the Storge Handler
//             
// PARAMETER:    bool status => true: status changed
//
// RETURNVALUE:  none
//
///////////////////////////////////////////////////////////////////////////////////
bool vdl_tclStorageUserInterface::isDataBaseLoaded()const
{
   bool bReturn = false;
   if(m_poStorageObject != NULL)
   {
      bReturn = m_poStorageObject->isDataBaseLoaded();
   }
   return bReturn;
}
